/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter0Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter1Decimals;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import java.util.Comparator;
import java.util.Iterator;

public class FormulaConverter
implements Converter<Object, String> {
    @Override
    public String convert(Object o, Node<Object> currentNode, Object ... param) {
        Node<Object> n = currentNode;
        if (n != null) {
            n.getChildsAsList().sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    Node l1 = (Node)o1;
                    Node l2 = (Node)o2;
                    return Integer.compare(((PackagingQuantityComplete)l1.getValue()).getSequenceNumber(), ((PackagingQuantityComplete)l2.getValue()).getSequenceNumber());
                }
            });
            Iterator<Node<?>> it = n.getChilds();
            String retString = "";
            double amount = 1.0;
            int currentNumber = -1;
            FormattedDoubleConverter0Decimals conv0 = ConverterRegistry.getConverter(FormattedDoubleConverter0Decimals.class);
            FormattedDoubleConverter1Decimals conv1 = ConverterRegistry.getConverter(FormattedDoubleConverter1Decimals.class);
            FormattedDoubleConverter2Decimals conv2 = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            while (it.hasNext()) {
                UnitComplete unit;
                Node<?> u = it.next();
                double dd = 0.0;
                if (u.getChildNamed(PackagingQuantityComplete_.amount) != null) {
                    Object am = u.getChildNamed(PackagingQuantityComplete_.amount).getValue();
                    if (am instanceof Double) {
                        dd = (Double)am;
                    } else if (am instanceof Integer) {
                        dd = ((Integer)am).doubleValue();
                    }
                }
                currentNumber = this.getMaxNumbers("" + dd, currentNumber);
                Converter<Number, String> con = null;
                con = currentNumber == -1 || currentNumber == 0 ? conv0 : (currentNumber == 1 ? conv1 : (currentNumber >= 2 ? conv2 : conv0));
                String fr = con.convert(amount *= dd, null, new Object[0]);
                retString = retString + fr + " ";
                if (u == null || u.getChildNamed(PackagingQuantityComplete_.unit) == null || (unit = (UnitComplete)u.getChildNamed(PackagingQuantityComplete_.unit).getValue()) == null) continue;
                retString = retString + unit.getShortName() + " = ";
            }
            if (retString.length() > 3) {
                retString = retString.substring(0, retString.length() - 3);
            }
            return retString;
        }
        return "";
    }

    private int getMaxNumbers(String value, int currentNumber) {
        int i = value.indexOf(".");
        if (i != -1) {
            int ci = value.length() - i - 1;
            String t = value.substring(i + 1, value.length());
            try {
                int a = Integer.valueOf(t);
                if (a == 0) {
                    ci -= t.length();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (currentNumber < ci) {
                return ci;
            }
        }
        return currentNumber;
    }

    @Override
    public Class<?> getParameterClass() {
        return null;
    }
}

