/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.converter;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter2Decimals;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;

public class QuantityConverter2DecimalUnnormalizedNodeBased
implements Converter<Object, String> {
    @Override
    public String convert(Object o, Node<Object> currentNode, Object ... param) {
        StoreQuantityComplete q;
        QuantityComplete d;
        Node<Object> n = currentNode;
        Node unit = n.getChildNamed(QuantityComplete_.unit);
        Node amount = n.getChildNamed(QuantityComplete_.quantity);
        if (amount == null) {
            amount = n.getChildNamed(StoreQuantityComplete_.amount);
        }
        if (amount == null) {
            return "-";
        }
        if (amount.getValue() instanceof Double) {
            Double e = (Double)amount.getValue();
            QuantityComplete c = new QuantityComplete(e, (UnitComplete)unit.getValue());
            d = new QuantityComplete(e, c.getUnit());
        } else if (amount.getValue() instanceof Integer) {
            q = new StoreQuantityComplete(Long.valueOf(((Integer)amount.getValue()).longValue()), (UnitComplete)unit.getValue());
            d = new QuantityComplete(new Double(q.getAmount().longValue()), q.getUnit());
        } else {
            q = new StoreQuantityComplete((Long)amount.getValue(), (UnitComplete)unit.getValue());
            d = new QuantityComplete(new Double(q.getAmount().longValue()), q.getUnit());
        }
        if (d.getQuantity() != null) {
            FormattedDoubleConverter2Decimals conv = ConverterRegistry.getConverter(FormattedDoubleConverter2Decimals.class);
            String fr = (String)conv.convert(d.getQuantity(), null, new Object[0]);
            return fr + " " + (d.getUnit() != null ? d.getUnit().getShortName() : "");
        }
        return "-";
    }

    @Override
    public Class<?> getParameterClass() {
        return null;
    }
}

