/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.mealplan;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientActionOnServerException;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupReference;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleReference;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantLight;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.ICateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.mealplan.LoadingGroupTemplateComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.services.mealplan.MealPlanService;
import java.util.List;

public class MealPlanServiceManagerImpl
implements MealPlanServiceManager {
    @Override
    public ListWrapper<CateringServiceScheduleVariantLight> getMealPlanLightVariants(CateringServiceScheduleReference reference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getMealPlanLightVariants(reference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CateringServiceScheduleVariantComplete> getMealPlanVariants(CateringServiceScheduleReference reference) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getMealPlanVariants(reference);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CateringServiceScheduleComplete> getServiceSchedules(MealPlanReference mealPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getServiceSchedules(mealPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MealPlanComplete> createFromTemplate(MealPlanReference template) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).createFromTemplate(template);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MealPlanComplete> createMealPlan(MealPlanComplete mealplan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).createMealPlan(mealplan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MealPlanComplete> updateMealPlan(MealPlanComplete mealplan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).updateMealPlan(mealplan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MealPlanComplete> getMealPlan(MealPlanReference mealplan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getMealPlan(mealplan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<MealPlanLight> getMealPlanLight(MealPlanReference mealplan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getMealPlanLight(mealplan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CateringServiceScheduleComplete> createServiceSchedule(MealPlanReference mealplan, CateringServiceScheduleComplete serviceSchedule, ListWrapper<CateringServiceScheduleVariantReference> variants2Save) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).createServiceSchedule(mealplan, serviceSchedule, variants2Save);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CateringServiceScheduleComplete> updateServiceSchedule(CateringServiceScheduleComplete serviceSchedule, ListWrapper<CateringServiceScheduleVariantReference> variants) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).updateServiceSchedule(serviceSchedule, variants);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CateringServiceScheduleReference> getUsedServices(MealPlanReference mealPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getUsedServices(mealPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<ALoadingGroupReference> getUsedLoadingGroups(StowingListTemplateVariantReference stowingListTemplate, CateringServiceScheduleReference service) throws ClientServerCallException {
        try {
            stowingListTemplate = stowingListTemplate == null ? new StowingListTemplateVariantReference() : stowingListTemplate;
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getUsedLoadingGroups(stowingListTemplate, service);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public List<ALoadingGroupReference> getUsedLoadingGroups(StowingListTemplateVariantReference stowingListTemplate, CateringServiceScheduleComplete service) throws ClientServerCallException {
        return this.getUsedLoadingGroups(stowingListTemplate, new CateringServiceScheduleReference(service.getId())).getList();
    }

    @Override
    public ListWrapper<MealplanTemplateLegComplete> getUsedLegs(MealPlanReference mealPlan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getUsedLegs(mealPlan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StowingListTemplateVariantLight> getReferencingStowingListTemplatesByReference(MealPlanReference mealplan) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getReferencingStowingListTemplatesByReference(mealplan);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StowingListTemplateVariantLight> getReferencingStowingListTemplatesForService(CateringServiceScheduleReference service) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getReferencingStowingListTemplatesForService(service);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public ListWrapper<StowingListTemplateVariantLight> getReferencingStowingListTemplates(ALoadingGroupReference loadingGroup) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getReferencingStowingListTemplates(loadingGroup);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CateringServiceScheduleComplete> removeLoadingGroup(LoadingGroupTemplateComplete lgtc) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).removeLoadingGroup(lgtc);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<CateringServiceScheduleVariantLight> getVariants(ListWrapper<ICateringServiceScheduleVariantReference> variants) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getVariants(variants);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CateringServiceScheduleVariantComplete> getVariant(CateringServiceScheduleVariantReference ref) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getVariant(ref);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CateringServiceScheduleComplete> getServiceSchedule(CateringServiceScheduleComplete service) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getServiceSchedule(service);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getMealPlanArticlesReport(ListWrapper<MealPlanReference> references, TimestampWrapper timestamp, boolean showCosts, boolean includeAll) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).getMealPlanArticlesReport(references, timestamp, showCosts, includeAll);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }

    @Override
    public ListWrapper<String> validateLoadingGroupConfiguration(CateringServiceScheduleComplete schedule, CateringServiceScheduleVariantComplete variant, ListWrapper<LoadingGroupTemplateComplete> loadingGroups) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(MealPlanService.class).validateLoadingGroupConfiguration(schedule, variant, loadingGroups);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientActionOnServerException(e);
        }
    }
}

