/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SpotCheckServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.ccp0102.CCP0102SpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.HACCPSpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.haccp.PurchaseQualitySpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewLight;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.halal.HalalSpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.oprp05.OPRP05SpotCheckReviewComplete;
import ch.icit.pegasus.server.core.dtos.spotcheck.oprp05.OPRP05SpotCheckReviewReference;
import ch.icit.pegasus.server.core.dtos.spotcheck.oprp05.OPRP05SpotCheckSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.SpotCheckService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotCheckServiceManagerImpl
implements SpotCheckServiceManager {
    private static Logger log = LoggerFactory.getLogger(SpotCheckServiceManagerImpl.class);

    @Override
    public void resolveCCP0102SpotCheck(CCP0102SpotCheckReviewReference spotCheck) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).resolveCCP0102SpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanSpotCheckReviewComplete> createDocumentScanSpotCheck(DocumentScanSpotCheckReviewComplete spotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createDocumentScanSpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanSpotCheckReviewComplete> updateDocumentScanSpotCheck(DocumentScanSpotCheckReviewComplete spotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateDocumentScanSpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanSpotCheckReviewComplete> getDocumentSpotCheck(DocumentScanSpotCheckReviewReference spotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getDocumentSpotCheck(spotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createDocumentScanSpotCheckDetailReport(ListWrapper<DocumentScanSpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createDocumentScanSpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05SpotCheckReviewComplete> createOPRP05SpotCheck(OPRP05SpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createOPRP05SpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05SpotCheckReviewComplete> updateOPRP05SpotCheck(OPRP05SpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateOPRP05SpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05SpotCheckReviewComplete> getOPRP05SpotCheck(OPRP05SpotCheckReviewReference halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getOPRP05SpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createOPRP05SpotCheckDetailReport(ListWrapper<OPRP05SpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createOPRP05SpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05SpotCheckSettingsComplete> getOPRP05Settings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getOPRP05Settings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<OPRP05SpotCheckSettingsComplete> updateOPRP05nSettings(OPRP05SpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateOPRP05nSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanSpotCheckSettingsComplete> getDocumentScanSpotCheckSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getDocumentScanSpotCheckSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateDocumentScanSpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateDocumentScanSpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateOPRP05SpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateOPRP05SpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateAllergenSpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateAllergenSpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateHACCPSpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateHACCPSpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateHalalSpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateHalalSpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void generateCCP0102SpotCheck() throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(SpotCheckService.class).generateCCP0102SpotCheck();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AllergenSpotCheckSettingsComplete> getAllergenSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getAllergenSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseQualitySpotCheckSettingsComplete> getHACCPSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getHACCPSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HalalSpotCheckSettingsComplete> getHalalSettings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getHalalSettings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102SpotCheckSettingsComplete> getCCP0102Settings() throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getCCP0102Settings();
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AllergenSpotCheckSettingsComplete> updateAllergenSettings(AllergenSpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateAllergenSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PurchaseQualitySpotCheckSettingsComplete> updateHACCPSettings(PurchaseQualitySpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateHACCPSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HalalSpotCheckSettingsComplete> updateHalalSettings(HalalSpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateHalalSettings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102SpotCheckSettingsComplete> updateCCP0102Settings(CCP0102SpotCheckSettingsComplete settings) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateCCP0102Settings(settings);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102SpotCheckReviewComplete> createCCP0102SpotCheck(CCP0102SpotCheckReviewComplete ccp0102SpotCheckReview) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createCCP0102SpotCheck(ccp0102SpotCheckReview);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102SpotCheckReviewComplete> getCCP0102SpotCheck(CCP0102SpotCheckReviewReference ccp0102SpotCheckReview) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getCCP0102SpotCheck(ccp0102SpotCheckReview);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<CCP0102SpotCheckReviewComplete> updateCCP0102SpotCheck(CCP0102SpotCheckReviewComplete ccp0102SpotCheckReview) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateCCP0102SpotCheck(ccp0102SpotCheckReview);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createCCP0102SpotCheckDetailReport(ListWrapper<CCP0102SpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createCCP0102SpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HalalSpotCheckReviewComplete> createHalalSpotCheck(HalalSpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createHalalSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HalalSpotCheckReviewComplete> updateHalalSpotCheck(HalalSpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateHalalSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HalalSpotCheckReviewComplete> getHalalSpotCheck(HalalSpotCheckReviewLight halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getHalalSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AllergenSpotCheckReviewComplete> createAllergenSpotCheck(AllergenSpotCheckReviewComplete allergenSpotCheckReviewComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createAllergenSpotCheck(allergenSpotCheckReviewComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AllergenSpotCheckReviewComplete> updateAllergenSpotCheck(AllergenSpotCheckReviewComplete allergenSpotCheckReviewComplete) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateAllergenSpotCheck(allergenSpotCheckReviewComplete);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<AllergenSpotCheckReviewComplete> getAllergenSpotCheck(AllergenSpotCheckReviewLight allergenSpotCheckReviewLight) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getAllergenSpotCheck(allergenSpotCheckReviewLight);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HACCPSpotCheckReviewComplete> createHACCPSpotCheck(HACCPSpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createHACCPSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HACCPSpotCheckReviewComplete> updateHACCPSpotCheck(HACCPSpotCheckReviewComplete halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).updateHACCPSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<HACCPSpotCheckReviewComplete> getHACCPSpotCheck(HACCPSpotCheckReviewLight halalSpotCheck) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).getHACCPSpotCheck(halalSpotCheck);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createHalalSpotCheckDetailReport(ListWrapper<HalalSpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createHalalSpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createAllergenSpotCheckDetailReport(ListWrapper<AllergenSpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createAllergenSpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> createHACCPSpotCheckDetailReport(ListWrapper<HACCPSpotCheckReviewReference> checks) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(SpotCheckService.class).createHACCPSpotCheckDetailReport(checks);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

