/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ClientExceptionHandlerListener;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.exception.ValidationException;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.system.LoggingService;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    static Logger log = LoggerFactory.getLogger(ExceptionHandler.class);
    private static boolean EMAIL = true;
    public static boolean TESTING = false;
    private static ExceptionHandler singleTon;
    private ClientExceptionHandlerListener clientExceptionHandler;
    private byte[] currentScreenShot;

    public static ExceptionHandler getHandler() {
        if (singleTon == null) {
            singleTon = new ExceptionHandler();
        }
        return singleTon;
    }

    private ExceptionHandler() {
        EMAIL = this.isMailExceptionReport();
    }

    public boolean isMailExceptionReport() {
        return false;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.fireException(t, e, true);
    }

    public String stackTraceAsString(Throwable t) {
        StringWriter result = new StringWriter();
        PrintWriter pw = new PrintWriter(result);
        t.printStackTrace(pw);
        return result.toString();
    }

    public void sendMail(Throwable tb, UserComplete user, String msg) {
        String server;
        byte[] screenshot = this.currentScreenShot;
        if (this.clientExceptionHandler != null) {
            screenshot = this.clientExceptionHandler.getScreenShot();
        }
        String userName = user == null ? "<unknown user>" : user.getUserName();
        String hostName = "<unknown host>";
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        String stackTrace = "No stacktrace.";
        if (tb != null) {
            stackTrace = this.stackTraceAsString(tb);
        }
        String version = "v" + this.getApplicationVersionString();
        try {
            server = EjbContextFactory.getInstance().getOrbConfig().getName();
        }
        catch (IOException e2) {
            server = "unresolved_server";
        }
        String subject = "[C: " + userName + "@" + hostName + ", " + version + " on " + server + "]";
        if (tb != null) {
            LoggingService ls;
            try {
                ls = EjbContextFactory.getInstance().getService(LoggingService.class);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return;
            }
            if (tb instanceof ServiceException) {
                try {
                    ls.sendBugMailToDefaultAddress(subject, msg, stackTrace, screenshot);
                }
                catch (ServiceException serviceException) {}
            } else {
                if (tb instanceof IllegalStateException && tb.getMessage().contains(Words.NO_EJB_AVAILABLE)) {
                    throw new ValidationException(Words.SERVER_DOWN_WITH_HELP);
                }
                try {
                    ls.sendBugMail(subject, msg, stackTrace, screenshot, null);
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
        }
    }

    public String getApplicationVersionString() {
        if (this.clientExceptionHandler != null) {
            return this.clientExceptionHandler.getClientVersion();
        }
        return "";
    }

    public void fireException(Thread t, Throwable e, boolean uncaught) {
        StackTraceElement[] serverStack = e.getStackTrace();
        StackTraceElement[] clientStack = new Exception().getStackTrace();
        StackTraceElement[] combinedStack = new StackTraceElement[serverStack.length + clientStack.length - 1];
        System.arraycopy(serverStack, 0, combinedStack, 0, serverStack.length);
        System.arraycopy(clientStack, 1, combinedStack, serverStack.length, clientStack.length - 1);
        if (uncaught) {
            this.sendUnexpectedExceptionMail(e);
        }
        e.setStackTrace(combinedStack);
        e.printStackTrace();
    }

    public void showExceptionPopup(String message) {
        if (this.clientExceptionHandler != null) {
            this.clientExceptionHandler.showErrorPopup(message);
        }
    }

    public void showUnexpectedExceptionPopup(Throwable e, boolean uncaught) {
        if (this.clientExceptionHandler != null) {
            this.clientExceptionHandler.showUnexpectedErrorPopup(e);
        }
    }

    public void sendUnexpectedExceptionMail(Throwable e) {
        if (this.clientExceptionHandler != null) {
            this.sendMail(e, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser(), "Uncaught Exception Occured");
        }
    }

    public static final void registerAWTQueueHandler() {
        SwingUtilities.invokeLater(() -> {
            if (SwingUtilities.isEventDispatchThread()) {
                Thread t = Thread.currentThread();
                t.setUncaughtExceptionHandler(ExceptionHandler.getHandler());
            } else {
                log.error("Unexpected error. Try to register AWTQueueHandler but was unable to find the AWTEventThread");
                System.exit(0);
            }
        });
    }

    public void registerClientExceptionHandler(ClientExceptionHandlerListener clientExceptionHandler) {
        SwingUtilities.invokeLater(() -> {
            if (SwingUtilities.isEventDispatchThread()) {
                this.clientExceptionHandler = clientExceptionHandler;
            }
        });
    }

    public void logout() {
        if (this.clientExceptionHandler != null) {
            this.clientExceptionHandler.logout();
        }
    }
}

