/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.report;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.GenericReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationReference;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.MatDispoConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.report.GenericReportService;
import ch.icit.pegasus.server.core.services.report.WSReportService;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.IDTO;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericReportServiceManagerImpl
implements GenericReportServiceManager {
    private static Logger logger = LoggerFactory.getLogger(GenericReportServiceManagerImpl.class);

    @Override
    public <E extends IDTO> Future<PegasusFileComplete> getReportWithReportFile(ADtoSearchConfiguration<E, ?> searchConfig, AGenericReportConfiguration reportConfig, ReportFileComplete reportFileComplete, final String callerID) throws ClientServerCallException {
        try {
            if (!EjbContextFactory.getInstance().getUseWebServices()) {
                return EjbContextFactory.getInstance().getService(GenericReportService.class).getReportWithReportFile(searchConfig, reportConfig, reportFileComplete, callerID);
            }
            EjbContextFactory.getInstance().getService(WSReportService.class).getReportWithReportFile(searchConfig, reportConfig, reportFileComplete, callerID);
            return new Future<PegasusFileComplete>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    try {
                        return EjbContextFactory.getInstance().getService(WSReportService.class).isDone(callerID);
                    }
                    catch (ServiceException e) {
                        logger.error("", (Throwable)e);
                        return false;
                    }
                }

                @Override
                public PegasusFileComplete get() throws InterruptedException, ExecutionException {
                    try {
                        return EjbContextFactory.getInstance().getService(WSReportService.class).getFile(callerID);
                    }
                    catch (ServiceException e) {
                        logger.error("", (Object)logger);
                        return null;
                    }
                }

                @Override
                public PegasusFileComplete get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    return null;
                }
            };
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public <E extends IDTO> Future<PegasusFileComplete> getReport(ADtoSearchConfiguration<E, ?> searchConfig, AGenericReportConfiguration reportConfig, final String callerID) throws ClientServerCallException {
        try {
            if (EjbContextFactory.getInstance().getUseWebServices()) {
                EjbContextFactory.getInstance().getService(WSReportService.class).getReport(searchConfig, reportConfig, callerID);
                return new Future<PegasusFileComplete>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).isDone(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return false;
                        }
                    }

                    @Override
                    public PegasusFileComplete get() throws InterruptedException, ExecutionException {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).getFile(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return null;
                        }
                    }

                    @Override
                    public PegasusFileComplete get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return null;
                    }
                };
            }
            return EjbContextFactory.getInstance().getService(GenericReportService.class).getReport(searchConfig, reportConfig, callerID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Future<PegasusFileComplete> getFlightCostReport(AGenericReportConfiguration reportConfiguration, final String callerID) throws ClientServerCallException {
        try {
            if (EjbContextFactory.getInstance().getUseWebServices()) {
                EjbContextFactory.getInstance().getService(WSReportService.class).getFlightCostReport(reportConfiguration, callerID);
                return new Future<PegasusFileComplete>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).isDone(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return false;
                        }
                    }

                    @Override
                    public PegasusFileComplete get() throws InterruptedException, ExecutionException {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).getFile(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return null;
                        }
                    }

                    @Override
                    public PegasusFileComplete get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return null;
                    }
                };
            }
            return EjbContextFactory.getInstance().getService(GenericReportService.class).getFlightCostReport(reportConfiguration, callerID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Future<PegasusFileComplete> createMatDispoFromConfig(MatDispoConfiguration matDispoConfiguration, final String callerID) throws ClientServerCallException {
        try {
            if (EjbContextFactory.getInstance().getUseWebServices()) {
                EjbContextFactory.getInstance().getService(WSReportService.class).createMatDispoFromConfig(matDispoConfiguration, callerID);
                return new Future<PegasusFileComplete>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).isDone(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return false;
                        }
                    }

                    @Override
                    public PegasusFileComplete get() throws InterruptedException, ExecutionException {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).getFile(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return null;
                        }
                    }

                    @Override
                    public PegasusFileComplete get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return null;
                    }
                };
            }
            return EjbContextFactory.getInstance().getService(GenericReportService.class).createMatDispoFromConfig(matDispoConfiguration, callerID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Future<PegasusFileComplete> createMatDispo(MaterialDispositionCalculationReference calculationReference, final String callerID) throws ClientServerCallException {
        try {
            if (EjbContextFactory.getInstance().getUseWebServices()) {
                EjbContextFactory.getInstance().getService(WSReportService.class).createMatDispo(calculationReference, callerID);
                return new Future<PegasusFileComplete>(){

                    @Override
                    public boolean cancel(boolean mayInterruptIfRunning) {
                        return false;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }

                    @Override
                    public boolean isDone() {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).isDone(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return false;
                        }
                    }

                    @Override
                    public PegasusFileComplete get() throws InterruptedException, ExecutionException {
                        try {
                            return EjbContextFactory.getInstance().getService(WSReportService.class).getFile(callerID);
                        }
                        catch (ServiceException e) {
                            logger.error("", (Throwable)e);
                            return null;
                        }
                    }

                    @Override
                    public PegasusFileComplete get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                        return null;
                    }
                };
            }
            return EjbContextFactory.getInstance().getService(GenericReportService.class).createMatDispo(calculationReference, callerID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }

    @Override
    public Tuple<Long, Long> getProgressTuple(String CallerID) throws ClientServerCallException {
        try {
            if (EjbContextFactory.getInstance().getUseWebServices()) {
                return EjbContextFactory.getInstance().getService(WSReportService.class).getProgressTuple(CallerID);
            }
            return EjbContextFactory.getInstance().getService(GenericReportService.class).getProgressTuple(CallerID);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientGetFromServerException(e);
        }
    }
}

