/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.ArticleSwapServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportComplete;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportLight;
import ch.icit.pegasus.server.core.dtos.swap.ArticleSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.swap.stock.ArticleStockSwapDataImportReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.ArticleSwapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleSwapServiceManagerImpl
implements ArticleSwapServiceManager {
    private static Logger log = LoggerFactory.getLogger(ArticleSwapServiceManagerImpl.class);

    @Override
    public ListWrapper<StoreLight> getStores(ArticleStockSwapDataImportReference swap) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).getStores(swap);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleSwapDataImportComplete> resolve(ArticleSwapDataImportReference data) throws ClientSaveOnServerException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).resolve(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleSwapDataImportComplete> createArticleSwapData(ArticleSwapDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).createArticleSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<PegasusFileComplete> getArticleSwapReport(ListWrapper<ArticleSwapDataImportReference> s) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).getArticleSwapReport(s);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleSwapDataImportComplete> getArticleSwapData(ArticleSwapDataImportLight data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).getArticleSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleSwapDataImportComplete> updateArticleSwapData(ArticleSwapDataImportComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).updateArticleSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<ArticleSwapDataImportComplete> performArticleSwapData(ArticleSwapDataImportReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(ArticleSwapService.class).performArticleSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public void deleteArticleSwapData(ArticleSwapDataImportReference data) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(ArticleSwapService.class).deleteArticleSwapData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

