/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.services.impl.supply;

import ch.icit.pegasus.client.ejb.EjbContextFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.DocumentScanServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ErrorSupport;
import ch.icit.pegasus.client.util.exception.ClientSaveOnServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.services.supply.DocumentScanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentScanServiceManagerImpl
implements DocumentScanServiceManager {
    private static Logger log = LoggerFactory.getLogger(DocumentScanServiceManagerImpl.class);

    @Override
    public void stripText(ListWrapper<DocumentScanReference> docScans) throws ClientServerCallException {
        try {
            EjbContextFactory.getInstance().getService(DocumentScanService.class).stripText(docScans);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanComplete> getDocumentScanData(DocumentScanReference data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(DocumentScanService.class).getDocumentScanData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanComplete> createDocumentScanData(DocumentScanComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(DocumentScanService.class).createDocumentScanData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }

    @Override
    public OptionalWrapper<DocumentScanComplete> updateDocumentScanData(DocumentScanComplete data) throws ClientServerCallException {
        try {
            return EjbContextFactory.getInstance().getService(DocumentScanService.class).updateDocumentScanData(data);
        }
        catch (Exception e) {
            ErrorSupport.fireException(Thread.currentThread(), e, e.getMessage(), true, true, ServiceManagerRegistry.getService(UserServiceManager.class).getCurrentUser());
            throw new ClientSaveOnServerException(e);
        }
    }
}

