/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarUtil {
    public static final long minuteMillis = 60000L;
    public static final long hourMillis = 3600000L;
    public static final long dayMillis = 86400000L;
    static Logger log = LoggerFactory.getLogger(CalendarUtil.class);

    public static java.sql.Date getDefaultStartDate(boolean today) {
        if (today) {
            return new java.sql.Date(System.currentTimeMillis());
        }
        Calendar c = TimeUtil.createCalendar();
        c.set(5, 1);
        c.set(2, 0);
        c.set(1, 2010);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static Timestamp mergeTimes(Timestamp original, Time newTime) {
        LocalDate d = new LocalDate(original.getTime());
        LocalTime t = new LocalTime(newTime.getTime());
        DateTime dateTime = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond());
        return new Timestamp(dateTime.getMillis());
    }

    public static boolean isBetween(PeriodComplete period, DateTime datetime) {
        if (period == null || datetime == null) {
            return false;
        }
        return period.getStartDate().getTime() <= datetime.getMillis() && period.getEndDate().getTime() > datetime.getMillis();
    }

    public static Period getPeriod(DateDurationComplete duration) {
        Period p;
        if (duration == null || duration.getDuration() == null) {
            return null;
        }
        int intValue = (int)Math.floor(duration.getDuration());
        double fraction = duration.getDuration() - (double)intValue;
        switch (duration.getUnit()) {
            case DAY: {
                p = Period.days((int)intValue);
                break;
            }
            case MONTH: {
                p = Period.months((int)intValue);
                break;
            }
            case WEEK: {
                p = Period.weeks((int)intValue);
                break;
            }
            case YEAR: {
                p = Period.years((int)intValue);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid ");
            }
        }
        int additionalMillis = (int)(8.64E7 * fraction);
        p.plusMillis(additionalMillis);
        return p;
    }

    public static java.sql.Date getInfinityDate() {
        Calendar c = TimeUtil.createCalendar();
        c.set(5, 6);
        c.set(2, 6);
        c.set(1, 6666);
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return new java.sql.Date(c.getTimeInMillis());
    }

    public static boolean isInfinityDate(java.sql.Date date) {
        Calendar c = TimeUtil.createCalendar();
        c.setTime(date);
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        return y == 6666 && m == 6 && d == 6;
    }

    public static Timestamp getTimestamp(Node n) {
        Object o = n.getValue();
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        if (o instanceof java.sql.Date) {
            return new Timestamp(((java.sql.Date)o).getTime());
        }
        if (o instanceof Date) {
            return new Timestamp(((Date)o).getTime());
        }
        return null;
    }

    public static boolean isBetween(TimestampPeriodComplete p, Timestamp date) {
        return date.getTime() >= p.getStartTime().getTime() && date.getTime() <= p.getEndTime().getTime();
    }

    public static boolean isBetween(PeriodComplete p, Timestamp date) {
        return date.getTime() >= p.getStartDate().getTime() && date.getTime() <= p.getEndDate().getTime();
    }

    public static boolean isBetween(TimestampPeriodComplete p, Date date) {
        return date.getTime() >= p.getStartTime().getTime() && date.getTime() <= p.getEndTime().getTime();
    }

    public static boolean isBetween(PeriodComplete p, Date date) {
        return date.getTime() >= p.getStartDate().getTime() && date.getTime() <= p.getEndDate().getTime();
    }

    public static boolean isWinterPeriod(Date startDate, Date endDate) {
        Calendar start = TimeUtil.createCalendar();
        start.setTimeInMillis(startDate.getTime());
        Calendar end = TimeUtil.createCalendar();
        end.setTimeInMillis(endDate.getTime());
        int sy = start.get(1);
        int ey = end.get(1);
        if (sy == ey) {
            Date w2s = CalendarUtil.getWinter2SummerTimeChangeDate(sy);
            Date s2w = CalendarUtil.getSummer2WinterTimeChangeDate(sy);
            if (startDate.getTime() < w2s.getTime()) {
                return true;
            }
            return endDate.getTime() >= s2w.getTime();
        }
        return true;
    }

    public static Timestamp mergeTimestamps(Timestamp date, Timestamp time) {
        Calendar c1 = TimeUtil.createCalendar();
        c1.setTimeInMillis(date.getTime());
        Calendar c2 = TimeUtil.createCalendar();
        c2.setTimeInMillis(time.getTime());
        Calendar c3 = TimeUtil.createCalendar();
        c3.set(1, c1.get(1));
        c3.set(2, c1.get(2));
        c3.set(5, c1.get(5));
        c3.set(11, c2.get(11));
        c3.set(12, c2.get(12));
        c3.set(13, 0);
        c3.set(14, 0);
        return new Timestamp(c3.getTimeInMillis());
    }

    public static Timestamp mergeTimestamps(Date date, Time time) {
        Calendar c1 = TimeUtil.createCalendar();
        c1.setTimeInMillis(date.getTime());
        Calendar c2 = TimeUtil.createCalendar();
        c2.setTimeInMillis(time.getTime());
        Calendar c3 = TimeUtil.createCalendar();
        c3.set(1, c1.get(1));
        c3.set(2, c1.get(2));
        c3.set(5, c1.get(5));
        c3.set(11, c2.get(11));
        c3.set(12, c2.get(12));
        c3.set(13, 0);
        c3.set(14, 0);
        return new Timestamp(c3.getTimeInMillis());
    }

    public static Date getDateWithoutTime(long t, boolean isTimestamp) {
        Calendar cal = TimeUtil.createCalendar();
        cal.setTimeInMillis(t);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (isTimestamp) {
            return new Timestamp(cal.getTimeInMillis());
        }
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static boolean isWithin(int hours, Date date) {
        if (date == null) {
            return false;
        }
        Calendar now = TimeUtil.createCalendar();
        now.setTimeInMillis(System.currentTimeMillis());
        now.roll(11, -1 * hours);
        return date.getTime() >= now.getTimeInMillis();
    }

    public static boolean isMorning(Date date) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(date.getTime());
        int h = c.get(11);
        return h <= 11;
    }

    public static boolean isSummerPeriod(Date startDate, Date endDate) {
        Calendar start = TimeUtil.createCalendar();
        start.setTimeInMillis(startDate.getTime());
        Calendar end = TimeUtil.createCalendar();
        end.setTimeInMillis(endDate.getTime());
        int sy = start.get(1);
        int ey = end.get(1);
        if (sy == ey) {
            Date w2s = CalendarUtil.getWinter2SummerTimeChangeDate(sy);
            Date s2w = CalendarUtil.getSummer2WinterTimeChangeDate(sy);
            if (startDate.getTime() >= w2s.getTime() && startDate.getTime() < s2w.getTime()) {
                return true;
            }
            if (endDate.getTime() >= w2s.getTime() && endDate.getTime() < s2w.getTime()) {
                return true;
            }
            if (startDate.getTime() < w2s.getTime() && endDate.getTime() >= s2w.getTime()) {
                return true;
            }
        } else {
            Date ss2w = CalendarUtil.getSummer2WinterTimeChangeDate(sy);
            Date ew2s = CalendarUtil.getWinter2SummerTimeChangeDate(ey);
            if (startDate.getTime() < ss2w.getTime()) {
                return true;
            }
            if (startDate.getTime() >= ss2w.getTime()) {
                return endDate.getTime() >= ew2s.getTime();
            }
        }
        return false;
    }

    private static Date getWinter2SummerTimeChangeDate(int year) {
        Calendar cal = TimeUtil.createCalendar();
        cal.set(year, 2, 31);
        while (cal.get(7) != 1) {
            cal.set(5, cal.get(5) - 1);
        }
        Date d = new Date(cal.getTimeInMillis());
        return d;
    }

    private static Date getSummer2WinterTimeChangeDate(int year) {
        Calendar cal = TimeUtil.createCalendar();
        cal.set(year, 9, 31);
        while (cal.get(7) != 1) {
            cal.set(5, cal.get(5) - 1);
        }
        Date d = new Date(cal.getTimeInMillis());
        return d;
    }

    public static long getTimeDiffInHours(Date date1, Date date2) {
        long dif = Math.abs(date1.getTime() - date2.getTime());
        long hours = dif / 1000L / 60L / 60L;
        return hours;
    }

    public static boolean isContaining(Date start1, Date end1, Date start2) {
        long s1 = start1.getTime();
        long e1 = end1.getTime();
        long s2 = start2.getTime();
        return s1 <= s2 && e1 >= s2;
    }

    public static boolean isIntersecting(PeriodComplete p1, PeriodComplete p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        long t1 = p1.getStartDate().getTime();
        long t2 = p1.getEndDate().getTime();
        long a1 = p2.getStartDate().getTime();
        long a2 = p2.getEndDate().getTime();
        if (a1 > t1 && a1 < t2) {
            return true;
        }
        if (a2 > t1 && a2 < t2) {
            return true;
        }
        return a1 < t1 && a2 > t1;
    }

    public static Timestamp getInventoryTimestamp(InventoryLight inventory) {
        LocalDate d = new LocalDate(inventory.getInventoryDate().getTime());
        LocalTime t = new LocalTime(inventory.getInventoryTime().getTime());
        DateTime dateTime = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond());
        return new Timestamp(dateTime.getMillis());
    }

    public static boolean isSameDay(java.sql.Date currentCalendar, int offset) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(System.currentTimeMillis());
        int d = c.get(5);
        int m = c.get(2);
        int y = c.get(1);
        c.setTimeInMillis(currentCalendar.getTime());
        int nd = c.get(5);
        int nm = c.get(2);
        int ny = c.get(1);
        if (d == nd && m == nm && y == ny) {
            return true;
        }
        if (m == nm && y == ny) {
            for (int i = 0; i <= offset; ++i) {
                if (d + i != nd) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isADayBefore(java.sql.Date checkedDate, java.sql.Date refDate) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(refDate.getTime());
        int d = c.get(5);
        int m = c.get(2);
        int y = c.get(1);
        c.setTimeInMillis(checkedDate.getTime());
        int nd = c.get(5);
        int nm = c.get(2);
        int ny = c.get(1);
        if (ny < y) {
            return true;
        }
        if (ny == y) {
            if (nm < m) {
                return true;
            }
            if (nm == m && nd < d) {
                return true;
            }
        }
        return false;
    }

    public static void printOutDate(java.sql.Date currentDate) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(currentDate.getTime());
        int d = c.get(5);
        int m = c.get(2);
        int y = c.get(1);
        log.debug("day " + d + ", month " + (m + 1) + ", year " + y);
    }

    public static boolean isBetween(java.sql.Date myDate, java.sql.Date startDate, java.sql.Date endDate) {
        return myDate.getTime() >= startDate.getTime() && myDate.getTime() <= endDate.getTime();
    }

    public static boolean isBetween(java.sql.Date myDate, PeriodComplete period) {
        return CalendarUtil.isBetween(myDate, period.getStartDate(), period.getEndDate());
    }

    public static long getHourAndMinutes(Time flightDate) {
        Calendar c = TimeUtil.createCalendar();
        c.setTimeInMillis(flightDate.getTime());
        int hour = c.get(11);
        int minutes = c.get(12);
        return 3600000L * (long)hour + (long)minutes * 60000L;
    }

    public static String getDateFormatInfo() {
        String t = "<b>Date format:</b><br/>";
        SimpleDateFormat df = TimeUtil.createDateFormat();
        df.applyPattern("dd.MM.yyyy");
        t = t + "<ul><li>y = Year</li><li>M = Month</li><li>w = Week in Year, W = Week in Month</li><li>D = Day in Year, d = Day in Month, F = Day of Week, E = Dayname</li></ul>";
        t = t + "<br/><b>Example</b><br/>";
        t = t + "<ul><li>dd.MM.yyyy = " + df.format(new Date(System.currentTimeMillis())) + "</li>";
        df.applyPattern("E dd/MM/yy");
        t = t + "<li>E dd/MM/yy = " + df.format(new Date(System.currentTimeMillis())) + "</li></ul>";
        return t;
    }

    public static String getDefaultDateFormat() {
        return "dd.MM.yyyy";
    }

    public static String getDefaultTimeFormat() {
        return "HH:mm";
    }

    public static Timestamp getTimestampWithoutSecond(Timestamp s) {
        Calendar c = TimeUtil.createCalendar();
        c.setTime(s);
        c.set(13, 0);
        c.set(14, 0);
        return new Timestamp(c.getTimeInMillis());
    }

    public static String getTimeFormatInfo() {
        String t = "<b>Time format:</b><br/>";
        SimpleDateFormat df = TimeUtil.createDateFormat();
        df.applyPattern("HH:mm.ss");
        t = t + "<ul><li>H = Hour in Day (0-23), h = Hour in Day (1-12)</li>";
        t = t + "<li>K = Hour in day (0-11), k = Hour in Day (1-24)</li>";
        t = t + "<li>m = Minutes, s = Seconds</li>";
        t = t + "<li>a = add am/pm marker</li></ul>";
        t = t + "<br/><b>Example</b><br/>";
        t = t + "<ul><li>HH:mm.ss = " + df.format(new Date(System.currentTimeMillis())) + "</li>";
        df.applyPattern("KK:mm a");
        t = t + "<li>KK:mm a = " + df.format(new Date(System.currentTimeMillis())) + "</li></ul>";
        return t;
    }

    public static PeriodComplete getWholeDay(Date date) {
        PeriodComplete period = new PeriodComplete();
        Calendar c = TimeUtil.createCalendar();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        period.setStartDate(new java.sql.Date(c.getTimeInMillis()));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        period.setEndDate(new java.sql.Date(c.getTimeInMillis()));
        return period;
    }

    public static long getDuration(DateDurationComplete dateDuration) {
        long dif = 0L;
        switch (dateDuration.getUnit()) {
            case DAY: {
                dif = 86400000L;
                break;
            }
            case MONTH: {
                dif = 2592000000L;
                break;
            }
            case WEEK: {
                dif = 604800000L;
                break;
            }
            case YEAR: {
                dif = 31104000000L;
                break;
            }
        }
        dif = (long)((double)dif * dateDuration.getDuration());
        return dif;
    }
}

