/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.catit.exceptionhandler;

import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.services.exception.ServiceExceptionMessages;
import java.util.Formatter;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageHandler {
    private static Logger logger = LoggerFactory.getLogger(ErrorMessageHandler.class);
    private ResourceBundle bundle;
    private static Formatter formatter = new Formatter();

    public ErrorMessageHandler(ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public String getErrorMessage(ServiceException se) {
        ServiceExceptionMessages code = se.getErrorCode();
        String message = this.bundle.getString(code.toString());
        if (message == null) {
            logger.warn("No message is defined for the error code '" + code + "' for the locale '" + this.bundle.getLocale() + "' !");
            throw new IllegalArgumentException("No message is defined for the error code '" + code + "' for the locale '" + this.bundle.getLocale() + "' !");
        }
        String[] replacments = se.getReplacements();
        formatter.format(message, replacments);
        return message;
    }

    public String getErrorMessage(String errorCode, String replacments) {
        String message = this.bundle.getString(errorCode);
        if (message == null) {
            logger.warn("No message is defined for the error code '" + errorCode + "' for the locale '" + this.bundle.getLocale() + "' !");
            throw new IllegalArgumentException("No message is defined for the error code '" + errorCode + "' for the locale '" + this.bundle.getLocale() + "' !");
        }
        formatter.format(message, replacments);
        return message;
    }
}

