/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.SessionManagerImpl;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.modules.login.LoginModule;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Screen;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DTONodeCreator;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.util.ClientExceptionHandler;
import ch.icit.pegasus.client.util.ClientExceptionHandlerListener;
import ch.icit.pegasus.client.util.ConfigHelper;
import ch.icit.pegasus.client.util.ExceptionHandler;
import ch.icit.pegasus.client.util.logger.LoggerOutputProxy;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    static Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        new Main(args);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void initTimeZoneAndLocale(SystemSettingsComplete settings) {
        String cou;
        String loc;
        String tz;
        String string = tz = settings != null ? settings.getDefaultTimeZone() : "Europe/Zurich";
        if (tz != null && !tz.isEmpty()) {
            TimeZone.setDefault(TimeZone.getTimeZone(tz));
            System.setProperty("user.timezone", tz);
        }
        String string2 = loc = settings != null ? settings.getDefaultLocale() : "en";
        if (loc == null || loc.isEmpty()) {
            loc = "en";
        }
        String string3 = cou = settings != null ? settings.getDefaultCountry() : "de";
        if (cou == null || cou.isEmpty()) {
            cou = "de";
        }
        Locale.setDefault(new Locale(loc, cou));
    }

    private void initApplicationSettings() {
        boolean isAnimating;
        AnimationProvider.isAnimationActiv = isAnimating = AttributesConverter.getBoolean4String(ApplicationSettingsLoader.getLoader().getAttribute("animation_active")).booleanValue();
    }

    public Main(String[] args) {
        if (args.length > 0) {
            System.setOut(LoggerOutputProxy.createDebugLoggingProxy(System.out));
            System.setErr(LoggerOutputProxy.createErrorLoggingProxy(System.err));
        }
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.YYYY hh:mm");
        logger.info("Start CATIT Client at " + df.format(new Date(System.currentTimeMillis())));
        INodeCreator.setDefaultImpl((INodeCreator)new DTONodeCreator());
        this.processEJBProperties(args);
        LafLoader.loadSkin();
        AttributeLoader.getAttributeLoader();
        LafLoader.getLafLoader();
        ApplicationSettingsLoader.getLoader();
        this.initApplicationSettings();
        SessionManagerImpl sessionManager = new SessionManagerImpl();
        ExceptionHandler.registerAWTQueueHandler();
        boolean retBoolean = false;
        if (args.length > 9) {
            String testSystemBool = args[9];
            if (testSystemBool != null && !testSystemBool.isEmpty()) {
                try {
                    retBoolean = Boolean.valueOf(testSystemBool);
                }
                catch (Exception e) {
                    retBoolean = false;
                }
            } else {
                retBoolean = false;
            }
        }
        MainFrame frame = new MainFrame(sessionManager, retBoolean);
        sessionManager.setApplication(frame);
        ExceptionHandler.getHandler().registerClientExceptionHandler((ClientExceptionHandlerListener)new ClientExceptionHandler(frame));
        frame.showScreen(new Screen(new LoginModule(sessionManager, frame, false)), null);
        System.out.println("CATIT Client is up");
    }

    private void processEJBProperties(String[] args) {
        System.out.println("Init Start Up with arguments:");
        ConfigHelper confHelper = ConfigHelper.getInstance();
        String customerCode = "";
        String forceWebService = "";
        String serverName = "";
        String serverUrl = "";
        String serverPort = "";
        String description = "";
        String useSSL = "";
        String protocol = "";
        String ejbOverHttp = "";
        String appVersion = "";
        Boolean test = null;
        if (args.length > 0) {
            customerCode = args[0];
        }
        if (args.length > 4) {
            forceWebService = args[4];
        }
        if (args.length > 6) {
            serverName = args[6];
        }
        if (args.length > 7) {
            serverUrl = args[7];
        }
        if (args.length > 8) {
            serverPort = args[8];
        }
        if (args.length > 9) {
            test = Boolean.valueOf(args[9]);
        }
        if (args.length > 10) {
            description = args[10];
        }
        if (args.length > 11) {
            useSSL = args[11];
        }
        if (args.length > 12) {
            ejbOverHttp = args[12];
        }
        if (args.length > 13) {
            protocol = args[13];
        }
        if (args.length > 14) {
            appVersion = args[14];
        }
        if (customerCode == null || customerCode.isEmpty()) {
            customerCode = confHelper.getProperty("customercode");
        }
        Properties props = System.getProperties();
        if (customerCode != null && !customerCode.equals("")) {
            props.setProperty("pegasus.client.customercode", customerCode);
        }
        if (forceWebService != null && !forceWebService.equals("")) {
            props.setProperty("pegasus.client.forceWebService", forceWebService);
        }
        if (!StringUtil.isBlank((String)serverName)) {
            props.setProperty("pegasus.client.servername", serverName);
        }
        if (!StringUtil.isBlank((String)serverUrl)) {
            props.setProperty("pegasus.client.serverurl", serverUrl);
        }
        if (!StringUtil.isBlank((String)serverPort)) {
            props.setProperty("pegasus.client.serverPort", serverPort);
        }
        if (!StringUtil.isBlank((String)description)) {
            props.setProperty("pegasus.client.description", description);
        }
        if (!StringUtil.isBlank((String)useSSL)) {
            props.setProperty("pegasus.client.useSSL", useSSL);
        }
        if (!StringUtil.isBlank((String)protocol)) {
            props.setProperty("pegasus.client.protocol", protocol);
        }
        if (!StringUtil.isBlank((String)ejbOverHttp)) {
            props.setProperty("pegasus.client.ejbOverHttp", ejbOverHttp);
        }
        System.out.println("- customer code = " + customerCode);
        System.out.println("- force web service = " + forceWebService);
        System.out.println("- server name = " + serverName);
        System.out.println("- server url = " + serverUrl);
        System.out.println("- port = " + serverPort);
        System.out.println("- test system = " + test);
        System.out.println("- server description = " + description);
        System.out.println("- use ssl = " + useSSL);
        System.out.println("- ejb over http = " + ejbOverHttp);
        System.out.println("- used protocol = " + protocol);
        System.out.println("- app launcher version = " + appVersion);
        logger.info("Init Start Up done");
    }
}

