/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.attributes;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.server.core.util.ResourcesLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeLoader {
    private static final Logger logger = LoggerFactory.getLogger(AttributeLoader.class);
    public static final String ALL_ATTRIBUTES = "All attributes changed";
    public static final String ATT_ANIMATIONTIME = "animationTime";
    public static final String ATT_ANIMATIONRATE = "animationRate";
    public static final String ATT_APPLICATION_HORIZONTAL_BORDER = "application_horizontal_border";
    public static final String ATT_APPLICATION_VERTICAL_BORDER = "application_vertical_border";
    public static final String ATT_INNER_HORIZONTAL_TITLE_BORDER = "inner_horizontal_title_border";
    public static final String ATT_HORIZONTAL_ICON_GAP_IN_TITLE = "horizontal_icon_gap_in_title";
    public static final String ATT_PADDING_INSET = "padding_inset";
    public static final String ATT_TABLE_CELL_HORIZONTAL_PADDING = "table_cell_horizontal_padding";
    public static final String ATT_SCREEN_HORIZONTAL_SCREEN_INSET = "screen_horizontal_inset";
    public static final String ATT_SCREEN_VERTICAL_BORDER_TO_APPTITLE = "screen_vertical_border_to_apptitle";
    public static final String ATT_SCREEN_VERTICAL_BORDER_TO_SCREENTITLE = "screen_vertical_border_to_screentitle";
    public static final String ATT_SCREEN_VERTICAL_BORDER_TO_CHAINTITLE = "screen_vertical_border_to_chaintitle";
    public static final String ATT_SCREEN_FILTER_CHAIN_HEIGHT = "screen_filter_chain_height";
    public static final String ATT_SCREEN_VERTICAL_BORDER_TO_FILTER_CHAIN = "screen_vertical_border_to_filter_chain";
    public static final String ATT_SCREEN_VERTICAL_BORDER_TO_TABLETITLE = "screen_vertical_border_to_tabletitle";
    public static final String ATT_DEFAULT_DATA_RECHECK_INTERVALL = "recheck_data_intervall";
    public static final String ATT_TABLE_SAVECANCEL_BUTTON_FONT_SIZE = "default_font_size";
    public static final String ATT_TABLE_SAVECANCEL_BUTTON_FONT_TYPE = "table_savecancel_button_font_type";
    public static final String ATT_STOWING_DEFAULT_TABLEROW_HADD_EDIT = "st_default_tablerow_hadd_edit";
    public static final String ATT_STOWING_DEFAULT_TABLEROW_HADD_READ = "st_default_tablerow_hadd_read";
    public static final String ATT_STOWING_MINIMAL_ITEM_DRAG_WIDTH = "gc_minimal_drag_item_width";
    public static final String ATT_STOWING_MINIMAL_ITEM_DRAG_HEIGHT = "gc_minimal_drag_item_height";
    public static final String ATT_DETAILS_PANEL_ARC_WIDTH = "details_panel_arcWidth";
    public static final String ATT_DETAILS_PANEL_ARC_HEIGHT = "details_panel_arcHeight";
    public static final String ATT_MINIMAL_COMBOWIDTH = "minimal_combo_width";
    public static final String ATT_MINIMAL_MULTIPARTCHOOSER_WIDTH = "minimal_multipartchooser_width";
    public static final String ATT_SCROLLPANE_DEFAULT_BLOCK_INCREMENT = "scrollbar_block_increment";
    public static final String ATT_HUD_BUTTON_DEFAULT_WIDTH = "hud_button_default_width";
    public static final String ATT_HUD_BUTTON_DEFAULT_HEIGHT = "hud_button_default_height";
    public static final String ATT_HUD_HORIZONTAL_GAP = "hud_horizontal_gap";
    public static final String ATT_HUD_VERTICAL_GAP = "hud_vertical_gap";
    public static final String ATT_INPUTCOMBO_MIN_UNITTEXT = "inputcombo_min_unittext";
    public static final String ATT_INPUTCOMBO_MIN_AMOUNTTEXT = "inputcombo_min_amounttext";
    public static final String ATT_DATECHOOSER_MIN_TEXT = "datechooser_min_text";
    public static final String ATT_DAYTIMECHOOSER_MIN_TEXT = "daytimechooser_min_text";
    public static final String ATT_FILTER_CHAIN_HORIZONTAL_COMPONENT_GAP = "filter_chain_horizontal_component_gap";
    public static final String ATT_FILTER_CHAIN_SEARCHBOX_WIDTH = "filter_chain_searchbox_width";
    public static final String ATT_FILTER_CHAIN_COMBOBOX_WIDTH = "filter_chain_combobox_width";
    public static final String ATT_FILTER_CHAIN_RESETBUTTON_WIDTH = "filter_chain_resetbutton_width";
    public static final String ATT_FILTER_CHAIN_RESETBUTTON_HEIGHT = "filter_chain_resetbutton_height";
    public static final String ATT_FILTER_CHAIN_SEPARATOR_WIDTH = "filter_chain_separator_width";
    public static final String ATT_FILTER_CHAIN_SEPARATOR_Y = "filter_chain_separator_y";
    public static final String ATT_FILTER_CHAIN_COMPONENT_Y = "filter_chain_component_y";
    public static final String ATT_FILTER_CHAIN_LABEL_TO_COMPONENT_GAP = "filter_chain_label_to_components_gap";
    public static final String ATT_LOGIN_TEXTFIELD_WIDTH = "login_textfield_width";
    public static final String ATT_LOGIN_VERTICAL_GAP = "login_vertical_gap";
    public static final String ATT_LOGIN_VERTICAL_TOP_BORDER = "login_vertical_top_border";
    public static final String ATT_TABLE_VERTICAL_ROW_BORDER = "table_vertical_row_border";
    public static final String ATT_TABLE_HORIZONTAL_ROW_BORDER = "table_horizontal_row_border";
    public static final String ATT_TABLE_DETAILS_EDITOR_TITLEBAR_ROUNDNESS = "table_details_editor_titlebar_roundness";
    public static final String ATT_TABLE_DETAILS_EDITOR_TITLEBAR_HEIGHT = "table_details_editor_titlebar_height";
    public static final String ATT_TABLE_DETAILS_EDITOR_HORIZONTAL_TITLE_TEXT_BORDER = "table_details_editor_horizontal_title_text_border";
    public static final String ATT_TABLE_DETAILS_HORIZONTAL_BORDER = "table_details_horizontal_border";
    public static final String ATT_TABLE_DETAILS_VERTICAL_BORDER = "table_details_vertical_border";
    public static final String ATT_TABLE_DETAILS_INNER_HORIZONTAL_BORDER = "table_details_inner_horizontal_border";
    public static final String ATT_TABLE_DETAILS_INNER_VERTICAL_BORDER = "table_details_inner_vertical_border";
    public static final String ATT_NUMERICSTEPPER_DEFAULT_WIDTH = "numeric_stepper_default_width";
    public static final String ATT_POPUP_XBORDER = "popup_xborder";
    public static final String ATT_POPUP_YBORDER = "popup_yborder";
    public static final String ATT_POPUP_GAP_BETWEEN_BUTTONS = "popup_gap_between_buttons";
    public static final String ATT_POPUP_GAP_TO_TITLE = "popup_gap_to_title";
    public static final String ATT_GC_TABLE_INSERT_INSET = "gc_table_insert_inset";
    public static final String ATT_GC_TABLE_BATCH_INSET = "gc_table_batch_inset";
    public static final String ATT_GC_GALLEYBOX_SPLITTED_NAME_INSET_DISABLED = "gc_galleybox_splitted_name_inset_disabled";
    public static final String ATT_GC_GALLEYBOX_SPLITTED_NAME_INSET_ACTIVE = "gc_galleybox_splitted_name_inset_active";
    public static final String ATT_GC_DEFAULT_GRIDSIZE_V = "gc_default_gridsize_v";
    public static final String ATT_GC_DEFAULT_GRIDSIZE_H = "gc_default_gridsize_h";
    public static final String ATT_GC_LABEL_MAINBORDER = "gc_label_mainborder";
    public static final String ATT_GC_LABEL_INNERBORDER = "gc_label_innerborder";
    public static final String ATT_GC_LABEL_TAB_BORDER = "gc_label_tabborder";
    public static final String ATT_GC_DEFAULT_GRID_INSET = "gc_grid_default_inset";
    public static final String ATT_CALENDAR_TEXTFIELD_ICON_GAP = "calendar_textfield_icon_gap";
    public static final String ATT_CALENDAR_WIDGET_HORIZONTAL_BORDER = "calendar_widget_horizontal_border";
    public static final String ATT_CALENDAR_WIDGET_VERTICAL_BORDER = "calendar_widget_vertial_border";
    public static final String ATT_CALENDAR_WIDGET_HORIZONTAL_ICON_GAP = "calendar_widget_horizontal_icon_gap";
    public static final String ATT_CALENDAR_WIDGET_VERTICAL_BUTTON_LINE_GAP = "calendar_widget_vertical_button_line_gap";
    public static final String ATT_CALENDAR_WIDGET_VERTICAL_LINE_DAYS_GAP = "calendar_widget_vertical_line_days_gap";
    public static final String ATT_CALENDAR_WIDGET_VERTICAL_DAYS_DATES_GAP = "calendar_widget_vertical_days_dates_gap";
    public static final String ATT_CALENDAR_WIDGET_VERTICAL_DATES_DATES_GAP = "calendar_widget_vertical_dates_dates_gap";
    public static final String ATT_CALENDAR_WIDGET_HORIZONTAL_DAYS_INSET = "calendar_widget_horizontal_days_inset";
    public static final String ATT_CALENDAR_WIDGET_HORIZONTAL_DAYS_KW_GAP = "calendar_widget_horizontal_days_kw_gap";
    public static final String ATT_CALENDAR_WIDGET_FILLED_ROUNDNESS = "calendar_widget_filled_roundness";
    public static final String ATT_CALENDAR_CLOSE_SCHEDULE_TIME = "calendar_close_scheduled_time";
    public static final String ATT_CALENDAR_FADEOUT_TIME = "calendar_fadeout_widget_time";
    public static final String ATT_TABLE_ADD_ROW_HORIZONTAL_ICON_INSET = "table_add_row_horizontal_icon_inset";
    public static final String ATT_TABLE_ADD_ROW_HORIZONTAL_ICON_TEXT_GAP = "table_add_row_horizontal_icon_text_gap";
    public static final String ATT_TABLE_CELL_VIEW_INNER_SEPARATOR_Y = "table_cell_view_inner_separator_y";
    public static final String ATT_TABLE_CELL_VIEW_INNER_HORIZONTAL_SPLIT_GAP = "table_cell_view_inner_horizontal_split_gap";
    public static final String ATT_TABLE_EDITOR_DETAILS_HORIZONTAL_GAP = "table_editor_details_inner_horizontal_gap";
    public static final String ATT_TABLE_EDITOR_DETAILS_VERTICAL_GAP = "table_editor_details_inner_vertical_gap";
    public static final String ATT_TABLE_EDITOR_BUTTON_HORIZONTAL_GAP = "table_editor_button_horizontal_gap";
    public static final String ATT_TABLE_EDITOR_BUTTON_VERTICAL_GAP = "table_editor_button_vertical_gap";
    public static final String ATT_TABLE_EDITOR_PARAGRAPH_HORIZONTAL_GAP = "table_editor_paragraph_horizontal_gap";
    public static final String ATT_TABLE_EDITOR_PARAGRAPH_VERTICAL_GAP = "table_editor_paragraph_vertical_gap";
    public static final String ATT_LEG_TABLE_DEFAULT_ROWNR_WIDTH = "leg_table_default_rownr_width";
    public static final String ATT_DEFAULT_TABLE_ROW_HEIGHT = "default_table_row_height";
    public static final String ATT_LEG_TABLE_DEFAULT_DELETE_ROW_WIDTH = "leg_table_default_deleterow_width";
    public static final String ATT_TABLE_DEFAULT_CELLPADDING = "table_default_cellpadding";
    public static final String ATT_TABLE_DEFAULT_INNER_CELLPADDING = "table_default_innercellpadding";
    public static final String ATT_TABLE2_DEFAULT_ROW_HEIGHT = "table2_default_row_height";
    public static final String ATT_BUTTON_DEFAULT_INNER_HORIZONTAL_BORDER = "button_default_inner_horizontal_border";
    public static final String ATT_DETAILS_VIEW_TABLE_TITLE_HEIGHT = "details_view_table_title_height";
    public static final String ATT_DETAILS_VIEW_TABLE_ROW_HEIGHT = "details_view_table_row_height";
    public static final String ATT_GC_DEFAULT_DIALOG_WIDTH = "gc_default_dialog_width";
    public static final String ATT_GC_DEFAULT_DIALOG_BUTTON_WIDTH = "gc_default_dialog_button_width";
    public static final String ATT_GC_MINIMAL_DRAG_DISTANCE = "gc_minimal_drag_distance";
    public static final String ATT_GC_TITLEBAR_TEXT_X = "gc_titlebar_text_x";
    public static final String ATT_GC_LABEL_DEFAULT_WIDTH = "gc_label_default_width";
    public static final String ATT_GC_LABEL_DEFAULT_HEIGHT = "gc_label_default_height";
    public static final String ATT_GC_LABEL_BARCODE_DEFAULT_HEIGHT = "gc_label_barcode_height";
    public static final String ATT_GC_LABEL_BARCODE_DEFAULT_WIDTH = "gc_label_barcode_width";
    public static final String ATT_GC_LISTVIEW_SCROLLPANE_DEFAULT_HEIGHT = "gc_listview_scrollpane_default_height";
    public static final String ATT_GC_LISTVIEW_TITLEBAR_SCROLLPANE_GAP = "gc_list_titlebar_view_gap";
    public static final String ATT_GC_AIRCRAFT_ADDPOSITION_BUTTON_INSET = "gc_aircraft_addpositionbutton_inset";
    public static final String ATT_GC_AIRCRAFT_DETAILS2_HEADER_HEIGHT = "gc_aircraft_details2_tableheader_height";
    public static final String ATT_GC_AIRCRAFT_DETAILS2_RIGHT_ALIGNMENT_INSET = "gc_aircraft_details2_right_alignment_inset";
    public static final String ATT_GC_SUBGALLEY_WIDTH = "gc_subgalley_width";
    public static final String ATT_TABLE_FIRST_COLUMN_INSET = "table_first_column_inset";
    public static final String ATT_COMBOBOX_DEFAULT_INSET = "combobox_default_inset";
    public static final String ATT_BUTTON_MINIMAL_WIDTH = "button_minimal_width";
    public static final String ATT_GC_FILL_FLIGHT_ICONBAR_WIDTH = "gc_fill_flight_iconbar_tabbedbutton_width";
    public static final String ATT_LOADING_ANIMATION_TIME = "loading_animation_time";
    public static final String ATT_SMARTSCREEN_ANIMATION_TIME = "smartscreen_animation_time";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS1_BORDER2RECIPE = "product_overview_details1_border2recipe";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS1_ARCRADIUS = "product_overview_details1_arcradius";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS1_BASEGAP = "product_overview_details1_base_gap";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS1_VERTICAL_GAP = "product_overview_details1_vertical_gap";
    public static final String ATT_TABLE_DETAILSPARAGRAPH_SHAPE_DASHES = "table_detailsparagraph_shape_dash";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS2_VERTICAL_GAP = "product_overview_details2_vertical_gap";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS4_FACTOR_FIELD_WIDTH = "product_overview_details4_default_factor_field_width";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS4_SMALL_VERTICAL_GAP = "product_overview_details4_small_vertical_gap";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS4_DEFAULT_TABLE_HEIGHT = "product_overview_details4_default_table_height";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS4_SEPARATOR_GAP = "product_overview_details4_separator_gap";
    public static final String ATT_PRODUCTOVERVIEW_DETAILS4_DEFAULT_PANEL_WIDTH = "product_overview_details4_default_panel_width";
    public static final String ATT_TABLE_ROWHEIGHT_RO = "table_rowheight_ro";
    public static final String ATT_TABLE_ROWHEIGHT_RW = "table_rowheight_rw";
    public static final String ATT_TABLE_HEADER_ROWHEIGHT = "table_header_rowheight";
    public static final String ATT_TABLE_INSETX = "table_insertx";
    public static final String ATT_DETAILS_HEADER_HEIGHT = "details_header_height";
    public static final String ATT_GC_LISTVIEW_SEARCHBAR_HEIGHT = "gc_listview_searchbar_height";
    public static final String ATT_MEALPLAN_EXPAND_ARROW_SIZE = "mealplan_expand_arrow_size";
    private static AttributeLoader singltonLoader;
    private ArrayList<AttributeListener> listeners = new ArrayList();
    private Properties properties;

    private AttributeLoader() {
        InputStream in = null;
        in = ResourcesLoader.getResourceAsStream((String)"attributes.properties");
        this.load(in);
    }

    public void load(InputStream in) {
        this.properties = new Properties();
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            logger.error("Unable to load Attribute Properties: " + e.getMessage());
        }
        this.fireEvent(ALL_ATTRIBUTES);
    }

    public static AttributeLoader getAttributeLoader() {
        if (singltonLoader == null) {
            singltonLoader = new AttributeLoader();
        }
        return singltonLoader;
    }

    public String getAttribute(String name) {
        return (String)this.properties.get(name);
    }

    private void fireEvent(String attribute) {
        for (AttributeListener listener : this.listeners) {
            listener.attributeChanged(attribute);
        }
    }
}

