/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.attributes;

import ch.icit.pegasus.server.core.util.ResourcesLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageAttributeLoader {
    private static final Logger logger = LoggerFactory.getLogger(ImageAttributeLoader.class);
    public static final String ATT_POPUP_13FIELD_SKIN_NORTH_INSET = "popup_13field_skin_north_inset";
    public static final String ATT_POPUP_13FIELD_SKIN_EAST_INSET = "popup_13field_skin_east_inset";
    public static final String ATT_POPUP_13FIELD_SKIN_SOUTH_INSET = "popup_13field_skin_south_inset";
    public static final String ATT_POPUP_13FIELD_SKIN_WEST_INSET = "popup_13field_skin_west_inset";
    private static ImageAttributeLoader singletonLoader;
    private Properties properties;

    private ImageAttributeLoader() {
        InputStream in = ResourcesLoader.getResourceAsStream((String)"imageAttributes.properties");
        this.load(in);
    }

    public void load(InputStream in) {
        this.properties = new Properties();
        try {
            this.properties.load(in);
        }
        catch (IOException e) {
            logger.error("Unable to load Language Properties: " + e.getMessage());
        }
    }

    public static ImageAttributeLoader getImageAttributeLoader() {
        if (singletonLoader == null) {
            singletonLoader = new ImageAttributeLoader();
        }
        return singletonLoader;
    }

    public String getImageAttribute(String name) {
        return (String)this.properties.get(name);
    }
}

