/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotificationmanager.details;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.IntegerSignedConverter;
import ch.icit.pegasus.client.converter.ProductForChangeNotificationConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ChangeNotificationDetailsPanel
extends DefaultDetailsPanel<ChangeNotificationLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> product;
    private TitledItem<TextLabel> cabinClass;
    private TitledItem<TextLabel> qty;
    private TitledItem<RDTextField> remark;

    public ChangeNotificationDetailsPanel(RowEditor<ChangeNotificationLight> editor, RDProvider provider) {
        super(editor, provider);
        boolean isAddRow = editor.getModel().isAddRow();
        this.setTitleText(Words.DETAILS);
        this.setCustomLayouter(new Layout());
        this.product = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(ProductForChangeNotificationConverter.class)), Words.PRODUCT, TitledItem.TitledItemOrientation.NORTH);
        this.product.getElement().setReadOnlyTextField(true);
        this.cabinClass = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(CabinClassConverter.class)), Words.CABIN_CLASS, TitledItem.TitledItemOrientation.NORTH);
        this.cabinClass.getElement().setReadOnlyTextField(true);
        this.qty = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerSignedConverter.class)), Words.UPDATE, TitledItem.TitledItemOrientation.NORTH);
        this.qty.getElement().setReadOnlyTextField(true);
        this.remark = new TitledItem<RDTextField>(new RDTextField(provider), Words.REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.remark.setIgnorePrefHeight(true);
        this.addToView(this.product);
        this.addToView(this.cabinClass);
        this.addToView(this.qty);
        this.addToView(this.remark);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.product.getElement().setNode(node.getChildNamed(new DtoField[]{ChangeNotificationComplete_.product, ProductComplete_.currentVariant}));
        this.cabinClass.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.cabinClass));
        this.qty.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.difference));
        this.remark.getElement().setNode(node.getChildNamed(ChangeNotificationComplete_.remark));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isAddRow = this.editor.getModel().isAddRow();
        ChangeNotificationStateE state = (ChangeNotificationStateE)this.editor.getModel().getNode().getChildNamed(ChangeNotificationComplete_.state).getValue();
        ChangeNotificationTypeE type = (ChangeNotificationTypeE)this.editor.getModel().getNode().getChildNamed(ChangeNotificationComplete_.type).getValue();
        super.setEnabled(isEnabled && isAddRow);
        this.product.setEnabled(isEnabled);
        this.cabinClass.setEnabled(isEnabled);
        this.qty.setEnabled(isEnabled);
        this.remark.setEnabled(isEnabled && isAddRow || !isAddRow && ChangeNotificationStateE.OPEN == state && ChangeNotificationTypeE.MANUAL == type);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        RDTextField element = this.remark.getElement();
        String value = (String)element.getNode().getValue();
        if (value.length() > 100) {
            ScreenValidationObject warning = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Maximum remark length is 100 characters");
            validationObjects.add(warning);
        }
        return validationObjects;
    }

    @Override
    public boolean grabsFocus() {
        return !this.editor.getModel().isAddRow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.product);
        CheckedListAdder.addToList(focusList, this.cabinClass);
        CheckedListAdder.addToList(focusList, this.qty);
        CheckedListAdder.addToList(focusList, this.remark);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.product.kill();
        this.cabinClass.kill();
        this.qty.kill();
        this.remark.kill();
        this.product = null;
        this.cabinClass = null;
        this.qty = null;
        this.remark = null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.remark.requestFocusInWindowNow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 2 * ChangeNotificationDetailsPanel.this.horizontalBorder;
            ChangeNotificationDetailsPanel.this.product.setLocation(ChangeNotificationDetailsPanel.this.horizontalBorder, ChangeNotificationDetailsPanel.this.verticalBorder);
            ChangeNotificationDetailsPanel.this.product.setSize((w -= ChangeNotificationDetailsPanel.this.inner_horizontalBorder / 2) + ChangeNotificationDetailsPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationDetailsPanel.this.product.getPreferredSize().getHeight());
            ChangeNotificationDetailsPanel.this.cabinClass.setLocation(ChangeNotificationDetailsPanel.this.horizontalBorder, ChangeNotificationDetailsPanel.this.product.getY() + ChangeNotificationDetailsPanel.this.product.getHeight() + ChangeNotificationDetailsPanel.this.inner_verticalBorder);
            ChangeNotificationDetailsPanel.this.cabinClass.setSize(w + ChangeNotificationDetailsPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationDetailsPanel.this.cabinClass.getPreferredSize().getHeight());
            ChangeNotificationDetailsPanel.this.qty.setLocation(ChangeNotificationDetailsPanel.this.horizontalBorder, ChangeNotificationDetailsPanel.this.cabinClass.getY() + ChangeNotificationDetailsPanel.this.cabinClass.getHeight() + ChangeNotificationDetailsPanel.this.inner_verticalBorder);
            ChangeNotificationDetailsPanel.this.qty.setSize(w + ChangeNotificationDetailsPanel.this.inner_horizontalBorder / 2, (int)ChangeNotificationDetailsPanel.this.qty.getPreferredSize().getHeight());
            ChangeNotificationDetailsPanel.this.remark.setLocation(ChangeNotificationDetailsPanel.this.horizontalBorder, ChangeNotificationDetailsPanel.this.qty.getY() + ChangeNotificationDetailsPanel.this.qty.getHeight() + ChangeNotificationDetailsPanel.this.inner_verticalBorder);
            ChangeNotificationDetailsPanel.this.remark.setSize(parent.getWidth() - ChangeNotificationDetailsPanel.this.remark.getX() * 2, (int)ChangeNotificationDetailsPanel.this.remark.getPreferredSize().getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = ChangeNotificationDetailsPanel.this.verticalBorder;
            currentY += ChangeNotificationDetailsPanel.this.product.getHeight() + ChangeNotificationDetailsPanel.this.verticalBorder;
            currentY += ChangeNotificationDetailsPanel.this.cabinClass.getHeight() + ChangeNotificationDetailsPanel.this.verticalBorder;
            currentY += ChangeNotificationDetailsPanel.this.qty.getHeight() + ChangeNotificationDetailsPanel.this.verticalBorder;
            return new Dimension(260, currentY += ChangeNotificationDetailsPanel.this.remark.getHeight() + ChangeNotificationDetailsPanel.this.verticalBorder);
        }
    }
}

