/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking2.details;

import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ConversionDetailsPanel
extends TableDetailsPanel<ArticleChargeLight> {
    private Set<UnitSystemComplete> usedUnits = new HashSet<UnitSystemComplete>();

    public ConversionDetailsPanel(RowEditor<ArticleChargeLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Conversion");
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> column = new ArrayList<TableColumnInfo>();
        column.add(new TableColumnInfo(Words.AMOUNT, null, null, null, "", 30, 30, 30));
        column.add(new TableColumnInfo(Words.UNIT, null, null, null, "", 30, 30, 30));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        column.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)column.get(0)).setxExpand(0.5);
        ((TableColumnInfo)column.get(1)).setxExpand(0.5);
        ((TableColumnInfo)column.get(2)).setxExpand(0.0);
        return column;
    }

    @Override
    public void setNode(Node<?> node) {
        for (PackagingQuantityComplete conversion : (List)node.getChildNamed(ArticleChargeComplete_.packingQuantities).getValue()) {
            this.usedUnits.add(conversion.getUnit().getUnitSystem());
        }
        this.table.getModel().setNode(node.getChildNamed(ArticleChargeComplete_.packingQuantities));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        HashSet<UnitSystemComplete> found = new HashSet<UnitSystemComplete>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(ArticleChargeComplete_.packingQuantities).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node conversion = (Node)it.next();
            found.add(((UnitComplete)conversion.getChildNamed(PackagingQuantityComplete_.unit).getValue()).getUnitSystem());
        }
        HashSet<UnitSystemComplete> oldOnes = new HashSet<UnitSystemComplete>(this.usedUnits);
        oldOnes.removeAll(found);
        if (!oldOnes.isEmpty()) {
            for (UnitSystemComplete unitSystem : oldOnes) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Unit System " + unitSystem.getName() + " is not in Conversion Table"));
            }
        }
        return validationObjects;
    }

    @Override
    public void configTable(Table2 table) {
        table.setTitleText(Words.CONVERSION);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        PackagingQuantityComplete o = new PackagingQuantityComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        o.setAmount(Integer.valueOf(1));
        o.setSequenceNumber(Integer.valueOf(this.table.getRowCount() - 1));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.updateSequenceNumber();
    }

    @Override
    public void childRemoved() {
        this.updateSequenceNumber();
    }

    private void updateSequenceNumber() {
        int count = 0;
        for (Table2RowPanel row : this.table.getRows()) {
            row.getModel().getNode().getChildNamed(PackagingQuantityComplete_.sequenceNumber).setValue((Object)count, 0L);
            ++count;
        }
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        return new TableRowImpl(model);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private RDTextField amount;
        private RDComboBox unit;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.amount = new RDTextField(ConversionDetailsPanel.this.provider, TextFieldType.INT);
            this.unit = new RDComboBox(ConversionDetailsPanel.this.provider, ConverterRegistry.getConverter(UnitConverter.class));
            this.amount.setOverrideName(ArticleChargeComplete_.packingQuantities);
            this.unit.setOverrideName(ArticleChargeComplete_.packingQuantities);
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> this.model.getNode().getParent().removeChild(this.model.getNode(), 0L));
            this.unit.refreshPossibleValues(UnitToolkit.getAllUnits());
            this.amount.setNode(this.model.getNode().getChildNamed(PackagingQuantityComplete_.amount));
            this.unit.setNode(this.model.getNode().getChildNamed(PackagingQuantityComplete_.unit));
            this.add(this.amount);
            this.add(this.unit);
            this.add(this.delete);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(PackagingQuantityComplete_.sequenceNumber).getValue();
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.amount);
            CheckedListAdder.addToList(focusList, this.unit);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.amount.setEnabled(isEnabled);
            this.unit.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            super.requestFocusInWindowNow();
            this.unit.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.amount.kill();
            this.amount = null;
            this.unit.kill();
            this.unit = null;
            if (this.delete != null) {
                this.delete.kill();
            }
            this.delete = null;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.unit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.unit.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.unit.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

