/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.chargetracking2.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.customsdeadline.CustomsDeadlineEntryComplete;
import ch.icit.pegasus.server.core.dtos.store.customsdeadline.CustomsDeadlineEntryComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class CustomsDeadlineDetailsPanel
extends TableDetailsPanel<ArticleChargeLight> {
    public CustomsDeadlineDetailsPanel(RowEditor<ArticleChargeLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.CUSTOMS_DEADLINES);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int pw = 2 * this.table.getCellPadding() + TableColumnInfo.periodColumnWidth;
        columns.add(new TableColumnInfo(Words.START_DATE, null, null, null, "", pw, pw, pw));
        columns.add(new TableColumnInfo(Words.END_DATE, null, null, null, "", pw, pw, pw));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(ArticleChargeComplete_.deadlineEntries));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void configTable(Table2 table) {
        table.setUseAccessRight(true);
        table.setUseWriteAccessRight(true);
        table.setOverrideName(ArticleChargeLight_.deadlineArticle);
        table.setTitleText(Words.CUSTOMS_DEADLINES);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        ArticleChargeLight charge = (ArticleChargeLight)this.editor.getModel().getNode().getValue(ArticleChargeLight.class);
        Boolean use = Boolean.TRUE.equals(charge.getDeadlineArticle());
        super.setEnabled(use);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        CustomsDeadlineEntryComplete o = new CustomsDeadlineEntryComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        return new TableRowImpl(model);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.startDate = new RDDateChooser(CustomsDeadlineDetailsPanel.this.getProvider());
            this.endDate = new RDDateChooser(CustomsDeadlineDetailsPanel.this.getProvider());
            this.startDate.setOverrideName(ArticleChargeComplete_.deadlineArticle);
            this.endDate.setOverrideName(ArticleChargeComplete_.deadlineArticle);
            this.startDate.setNode(this.model.getNode().getChildNamed(CustomsDeadlineEntryComplete_.startDate));
            this.endDate.setNode(this.model.getNode().getChildNamed(CustomsDeadlineEntryComplete_.endDate));
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> {
                if (source == this.delete) {
                    this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
                }
            });
            this.setLayout(new Layout3());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.delete);
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return super.isInnerComponent(c);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.delete.kill();
            this.startDate = null;
            this.endDate = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.startDate);
            CheckedListAdder.addToList(a, this.endDate);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(TableRowImpl.this.startDate.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(TableRowImpl.this.endDate.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

