/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.customer.details;

import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InvoiceDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDCheckBox> showDefaultAutoTax;
    private TitledItem<RDComboBox> defaultAutoTax;
    private TitledItem<RDCheckBox> accountingOnInvoice;
    private TitledItem<RDTextField> productAccountNumber;
    private TitledItem<RDTextField> airportAccountNumber;
    private TitledItem<RDTextField> handlingCostAccountNumber;
    private TitledItem<RDCheckBox> taxTermsSwitch;
    private TitledItem<RDCheckBox> payTermsSwitch;
    private RDTextArea taxTerms;
    private RDTextArea payTerms;
    private HorizontalSeparator horizontalSep;

    public InvoiceDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        super(editor, provider);
        this.setOpaque(false);
        this.setTitleText(Words.INVOICE_DETAILS);
        this.setCustomLayouter(new Layout());
        this.showDefaultAutoTax = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.SHOW_DEFAULT_AUTO_TAX, TitledItem.TitledItemOrientation.EAST);
        this.showDefaultAutoTax.getElement().addButtonListener(this);
        this.defaultAutoTax = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(TaxRateConverter.class), true), Words.DEFAULT_TAXRATE, TitledItem.TitledItemOrientation.NORTH);
        this.accountingOnInvoice = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.ACCOUNTING_ON_INVOICE, TitledItem.TitledItemOrientation.EAST);
        this.accountingOnInvoice.getElement().addButtonListener(this);
        this.productAccountNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.PRODUCT_ACCOUNT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.airportAccountNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.AIRPORT_ACCOUNT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.handlingCostAccountNumber = new TitledItem<RDTextField>(new RDTextField(provider), Words.HANDLINGCOST_ACCOUNT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.horizontalSep = new HorizontalSeparator();
        this.horizontalSep.setSeparatorColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("leg_table_line_color")));
        this.taxTermsSwitch = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.TAX_TERMS, TitledItem.TitledItemOrientation.EAST);
        this.taxTermsSwitch.getElement().addButtonListener(this);
        this.payTermsSwitch = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.PAYMENT_TERMS, TitledItem.TitledItemOrientation.EAST);
        this.payTermsSwitch.getElement().addButtonListener(this);
        this.taxTerms = new RDTextArea(provider);
        this.payTerms = new RDTextArea(provider);
        this.addToView(this.showDefaultAutoTax);
        this.addToView(this.defaultAutoTax);
        this.addToView(this.accountingOnInvoice);
        this.addToView(this.productAccountNumber);
        this.addToView(this.airportAccountNumber);
        this.addToView(this.handlingCostAccountNumber);
        this.addToView(this.horizontalSep);
        this.addToView(this.taxTermsSwitch);
        this.addToView(this.payTermsSwitch);
        this.addToView(this.taxTerms);
        this.addToView(this.payTerms);
    }

    @Override
    public void setNode(Node<?> node) {
        this.showDefaultAutoTax.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceShowDefaultAutoTax));
        this.defaultAutoTax.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TaxRateComplete.class));
        this.defaultAutoTax.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceDefaultAutoTax));
        this.productAccountNumber.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceFoodProductAccountNumber));
        this.airportAccountNumber.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceAirportFeeAccountNumber));
        this.handlingCostAccountNumber.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceHandlingCostAccountNumber));
        this.accountingOnInvoice.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceAccountingOnInvoice));
        this.taxTerms.setNode(node.getChildNamed(CustomerComplete_.invoiceTaxTermsText));
        this.payTerms.setNode(node.getChildNamed(CustomerComplete_.invoicePaymentTermsText));
        this.taxTermsSwitch.getElement().setNode(node.getChildNamed(CustomerComplete_.invoiceTaxTermsActivated));
        this.payTermsSwitch.getElement().setNode(node.getChildNamed(CustomerComplete_.invoicePaymentTermsActivated));
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> focusList = new ArrayList<ScreenValidationObject>();
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.showDefaultAutoTax.kill();
        this.defaultAutoTax.kill();
        this.accountingOnInvoice.kill();
        this.productAccountNumber.kill();
        this.airportAccountNumber.kill();
        this.handlingCostAccountNumber.kill();
        this.horizontalSep.kill();
        this.taxTerms.kill();
        this.payTerms.kill();
        this.taxTermsSwitch.kill();
        this.payTermsSwitch.kill();
        this.showDefaultAutoTax.kill();
        this.defaultAutoTax = null;
        this.accountingOnInvoice.kill();
        this.productAccountNumber = null;
        this.airportAccountNumber = null;
        this.handlingCostAccountNumber = null;
        this.horizontalSep = null;
        this.taxTerms = null;
        this.payTerms = null;
        this.taxTermsSwitch = null;
        this.payTermsSwitch = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.showDefaultAutoTax.setEnabled(isEnabled);
        this.defaultAutoTax.setEnabled(this.showDefaultAutoTax.getElement().isChecked() && isEnabled);
        this.accountingOnInvoice.setEnabled(isEnabled);
        this.productAccountNumber.setEnabled(this.accountingOnInvoice.getElement().isChecked() && isEnabled);
        this.airportAccountNumber.setEnabled(this.accountingOnInvoice.getElement().isChecked() && isEnabled);
        this.handlingCostAccountNumber.setEnabled(this.accountingOnInvoice.getElement().isChecked() && isEnabled);
        this.taxTermsSwitch.setEnabled(isEnabled);
        this.payTermsSwitch.setEnabled(isEnabled);
        this.taxTerms.setEnabled(this.taxTermsSwitch.getElement().isChecked() && isEnabled);
        this.payTerms.setEnabled(this.payTermsSwitch.getElement().isChecked() && isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.defaultAutoTax);
        CheckedListAdder.addToList(a, this.productAccountNumber);
        CheckedListAdder.addToList(a, this.airportAccountNumber);
        CheckedListAdder.addToList(a, this.handlingCostAccountNumber);
        CheckedListAdder.addToList(a, this.taxTerms);
        CheckedListAdder.addToList(a, this.payTerms);
        CheckedListAdder.addToList(a, this.taxTermsSwitch);
        CheckedListAdder.addToList(a, this.payTermsSwitch);
        CheckedListAdder.addToList(a, this.accountingOnInvoice);
        CheckedListAdder.addToList(a, this.showDefaultAutoTax);
        return a;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.showDefaultAutoTax.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source.equals(this.taxTermsSwitch.getElement().getEditor()) || source.equals(this.payTermsSwitch.getElement().getEditor()) || source.equals(this.accountingOnInvoice.getElement().getEditor()) || source.equals(this.showDefaultAutoTax.getElement().getEditor())) {
            this.setEnabled(this.isEnabled());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            InvoiceDetailsPanel.this.showDefaultAutoTax.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.showDefaultAutoTax.setSize(InvoiceDetailsPanel.this.showDefaultAutoTax.getPreferredSize());
            InvoiceDetailsPanel.this.defaultAutoTax.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.showDefaultAutoTax.getY() + InvoiceDetailsPanel.this.showDefaultAutoTax.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.defaultAutoTax.setSize(210, (int)InvoiceDetailsPanel.this.defaultAutoTax.getPreferredSize().getHeight());
            InvoiceDetailsPanel.this.accountingOnInvoice.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.defaultAutoTax.getY() + InvoiceDetailsPanel.this.defaultAutoTax.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.accountingOnInvoice.setSize(InvoiceDetailsPanel.this.accountingOnInvoice.getPreferredSize());
            InvoiceDetailsPanel.this.productAccountNumber.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.accountingOnInvoice.getY() + InvoiceDetailsPanel.this.accountingOnInvoice.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.productAccountNumber.setSize(InvoiceDetailsPanel.this.productAccountNumber.getPreferredSize());
            InvoiceDetailsPanel.this.airportAccountNumber.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.productAccountNumber.getY() + InvoiceDetailsPanel.this.productAccountNumber.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.airportAccountNumber.setSize(InvoiceDetailsPanel.this.productAccountNumber.getPreferredSize());
            InvoiceDetailsPanel.this.handlingCostAccountNumber.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.airportAccountNumber.getY() + InvoiceDetailsPanel.this.airportAccountNumber.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.handlingCostAccountNumber.setSize(InvoiceDetailsPanel.this.handlingCostAccountNumber.getPreferredSize());
            InvoiceDetailsPanel.this.horizontalSep.setLocation(0, InvoiceDetailsPanel.this.handlingCostAccountNumber.getY() + InvoiceDetailsPanel.this.handlingCostAccountNumber.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.horizontalSep.setSize(parent.getWidth(), 1);
            InvoiceDetailsPanel.this.taxTermsSwitch.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.horizontalSep.getY() + InvoiceDetailsPanel.this.horizontalSep.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.taxTermsSwitch.setSize(InvoiceDetailsPanel.this.taxTermsSwitch.getPreferredSize());
            InvoiceDetailsPanel.this.taxTerms.setLocation(InvoiceDetailsPanel.this.taxTermsSwitch.getX() + InvoiceDetailsPanel.this.taxTermsSwitch.getWidth() + InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.taxTermsSwitch.getY());
            InvoiceDetailsPanel.this.taxTerms.setSize(parent.getWidth() - (InvoiceDetailsPanel.this.taxTermsSwitch.getWidth() + 3 * InvoiceDetailsPanel.this.horizontalBorder), 65);
            InvoiceDetailsPanel.this.payTermsSwitch.setLocation(InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.taxTerms.getY() + InvoiceDetailsPanel.this.taxTerms.getHeight() + InvoiceDetailsPanel.this.verticalBorder);
            InvoiceDetailsPanel.this.payTermsSwitch.setSize(InvoiceDetailsPanel.this.payTermsSwitch.getPreferredSize());
            InvoiceDetailsPanel.this.payTerms.setLocation(InvoiceDetailsPanel.this.payTermsSwitch.getX() + InvoiceDetailsPanel.this.payTermsSwitch.getWidth() + InvoiceDetailsPanel.this.horizontalBorder, InvoiceDetailsPanel.this.payTermsSwitch.getY());
            InvoiceDetailsPanel.this.payTerms.setSize(parent.getWidth() - (InvoiceDetailsPanel.this.payTermsSwitch.getWidth() + 3 * InvoiceDetailsPanel.this.horizontalBorder), 65);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.showDefaultAutoTax.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.defaultAutoTax.getHeight();
            h += InvoiceDetailsPanel.this.accountingOnInvoice.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.productAccountNumber.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.airportAccountNumber.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.handlingCostAccountNumber.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.horizontalSep.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.taxTerms.getHeight();
            h += InvoiceDetailsPanel.this.verticalBorder;
            h += InvoiceDetailsPanel.this.payTerms.getHeight();
            return new Dimension(300, h += InvoiceDetailsPanel.this.verticalBorder);
        }
    }
}

