/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.converter.ESpecsLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.ESpecsImportSheetListTable;
import ch.icit.pegasus.client.gui.utils.tables.UserSearchTable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.ESpecsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.ESpecsSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.MailTypeE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.especs.ESpecsDataImportComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete_;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ESpecsInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useEspecsSynch;
    private TitledItem<CheckBox> autoSendActive;
    private TitledItem<CheckBox> autoReceiveActive;
    private TitledItem<TextField> companyID;
    private TitledItem<TextField> ftpURL;
    private TitledItem<NumberTextField> port;
    private TitledItem<TextField> sendURL;
    private TitledItem<TextField> receiveURL;
    private TitledItem<TextField> userName;
    private TitledItem<PasswordTextField> password;
    private TitledItem<NumberTextField> sendRate;
    private ComboBox sendRateUnit;
    private TitledItem<NumberTextField> receiveRate;
    private ComboBox receiveRateUnit;
    private TextLabel articleCategories;
    private HorizontalSeparator sep1;
    private Node<List<ESpecsDataImportComplete>> eSpecsData;
    private TextLabel lastUpdates;
    private ESpecsImportSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton receiveButton;
    private TablePanelAddSaveButton saveButton;
    private TextButton resetLastReceiveDate;
    private UserSearchTable usersToInform;
    private final Node<ESpecsConfig> node;
    private final DataExchangeModule module;
    private Node<ESpecsSettingsComplete> settings;
    private TitledItem<CheckBox> moveFilesIntoBackup;

    public ESpecsInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        ESpecsConfig e = new ESpecsConfig();
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, false, false);
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useEspecsSynch = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ESpecsSettingsComplete_.useEspecs)), Words.ENABLE_ESPECS, TitledItem.TitledItemOrientation.EAST);
        this.useEspecsSynch.getElement().addButtonListener(this);
        this.autoSendActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ESpecsSettingsComplete_.autoSendData)), Words.AUTO_SEND, TitledItem.TitledItemOrientation.EAST);
        this.autoReceiveActive = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(ESpecsSettingsComplete_.autoReceiveData)), Words.AUTO_RECEIVE, TitledItem.TitledItemOrientation.EAST);
        this.ftpURL = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangeURL})), Words.FTP_URL, TitledItem.TitledItemOrientation.NORTH);
        this.port = new TitledItem<NumberTextField>(new NumberTextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangePort}), TextFieldType.INT_NULLABLE), Words.FTP_PORT, TitledItem.TitledItemOrientation.NORTH);
        this.sendURL = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangeFolder})), Words.SEND_URL, TitledItem.TitledItemOrientation.NORTH);
        this.receiveURL = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.receiveDataExchangeSettings, SFTPDataExchangeSettingsComplete_.dataExchangeFolder})), Words.RECEIVE_URL, TitledItem.TitledItemOrientation.NORTH);
        this.companyID = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(ESpecsSettingsComplete_.companyID)), Words.ESPECS_COMPANY_ID, TitledItem.TitledItemOrientation.NORTH);
        this.userName = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.loginUser})), Words.USER, TitledItem.TitledItemOrientation.NORTH);
        this.password = new TitledItem<PasswordTextField>(new PasswordTextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.loginPwd, EncryptedStringComplete_.password})), Words.PASSWORD, TitledItem.TitledItemOrientation.NORTH);
        this.sendRate = new TitledItem<NumberTextField>(new NumberTextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendTimerServiceSettings, TimerServiceSettingsComplete_.intervallRateValue}), TextFieldType.DOUBLE), Words.SEND_RATE, TitledItem.TitledItemOrientation.NORTH);
        this.sendRateUnit = ComboBoxFactory.getTimeDurationComboBoxWithoutSeconds((Node<TimeUnitE>)this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendTimerServiceSettings, TimerServiceSettingsComplete_.intervallRateUnit}), false);
        this.receiveRate = new TitledItem<NumberTextField>(new NumberTextField(this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.receiveTimerServiceSettings, TimerServiceSettingsComplete_.intervallRateValue}), TextFieldType.DOUBLE), Words.RECEIVE_RATE, TitledItem.TitledItemOrientation.NORTH);
        this.receiveRateUnit = ComboBoxFactory.getTimeDurationComboBoxWithoutSeconds((Node<TimeUnitE>)this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.receiveTimerServiceSettings, TimerServiceSettingsComplete_.intervallRateUnit}), false);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(ESpecsLastUpdateConverter.class));
        this.articleCategories = new TextLabel(Words.RELEVANT_CATEGORY_DEFINED_IN_MASTER_DATA);
        this.moveFilesIntoBackup = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.receiveDataExchangeSettings, SFTPDataExchangeSettingsComplete_.moveParsedFilesIntoBackupFolder})), Words.MOVE_PARSED_FILES_INTO_BACKUP_FOLDER, TitledItem.TitledItemOrientation.EAST);
        this.sep1 = new HorizontalSeparator();
        this.usersToInform = new UserSearchTable();
        this.usersToInform.getModel().setNode(this.settings.getChildNamed(ESpecsSettingsComplete_.user));
        this.history = new ESpecsImportSheetListTable();
        this.history.setNode(this.eSpecsData);
        this.resetLastReceiveDate = new TextButton("Reset last receive Date");
        this.resetLastReceiveDate.setProgress(1.0f);
        this.resetLastReceiveDate.addButtonListener(this);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.receiveButton = new TablePanelAddSaveButton();
        this.receiveButton.setText(Words.RECEIVE);
        this.receiveButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.port);
        this.configPanel.add(this.useEspecsSynch);
        this.configPanel.add(this.autoSendActive);
        this.configPanel.add(this.autoReceiveActive);
        this.configPanel.add(this.companyID);
        this.configPanel.add(this.ftpURL);
        this.configPanel.add(this.sendURL);
        this.configPanel.add(this.receiveURL);
        this.configPanel.add(this.userName);
        this.configPanel.add(this.password);
        this.configPanel.add(this.sendRate);
        this.configPanel.add(this.sendRateUnit);
        this.configPanel.add(this.receiveRate);
        this.configPanel.add(this.receiveRateUnit);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.articleCategories);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sep1);
        this.configPanel.add(this.resetLastReceiveDate);
        this.configPanel.add(this.usersToInform);
        this.configPanel.add(this.moveFilesIntoBackup);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.sendPanel.add(this.receiveButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SFTPDataExchangeSettingsComplete c;
                ESpecsSettingsComplete s;
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                ESpecsSettingsComplete esc = null;
                try {
                    esc = (ESpecsSettingsComplete)((ESpecsServiceManager)ServiceManagerRegistry.getService(ESpecsServiceManager.class)).getEspecsSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    s = new ESpecsSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getSendDataExchangeSettings() == null) {
                    c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings(c);
                }
                if (esc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                if (esc.getReceiveDataExchangeSettings() == null) {
                    c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setReceiveDataExchangeSettings(c);
                }
                if (esc.getReceiveDataExchangeSettings().getLoginPwd() == null) {
                    esc.getReceiveDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                if (esc.getSendTimerServiceSettings() == null) {
                    s = new TimerServiceSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(720.0)));
                    s.setIntervallRateUnit(TimeUnitE.MINUTE);
                    s.setIntervallRateValue(Double.valueOf(720.0));
                    esc.setSendTimerServiceSettings((TimerServiceSettingsComplete)s);
                }
                if (esc.getReceiveTimerServiceSettings() == null) {
                    s = new TimerServiceSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(20.0)));
                    s.setIntervallRateUnit(TimeUnitE.MINUTE);
                    s.setIntervallRateValue(Double.valueOf(20.0));
                    esc.setReceiveTimerServiceSettings((TimerServiceSettingsComplete)s);
                }
                ESpecsInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                ESpecsInsert.this.eSpecsData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ESpecsInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useEspecsSynch.setEnabled(isEnabled);
            boolean b = isEnabled && this.useEspecsSynch.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.receiveButton.setEnabled(b);
            this.autoReceiveActive.setEnabled(b);
            this.autoSendActive.setEnabled(b);
            this.companyID.setEnabled(b);
            this.sendURL.setEnabled(b);
            this.ftpURL.setEnabled(b);
            this.receiveURL.setEnabled(b);
            this.userName.setEnabled(b);
            this.password.setEnabled(b);
            this.port.setEnabled(b);
            this.sendRate.setEnabled(b);
            this.sendRateUnit.setEnabled(b);
            this.receiveRate.setEnabled(b);
            this.receiveRateUnit.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.articleCategories.setEnabled(b);
            this.sep1.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
            this.resetLastReceiveDate.setEnabled(b);
            this.moveFilesIntoBackup.setEnabled(b);
            this.usersToInform.setEnabled(b);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.autoReceiveActive.kill();
            this.autoSendActive.kill();
            this.sendButton.kill();
            this.port.kill();
            this.history.kill();
            this.ftpURL.kill();
            this.sendURL.kill();
            this.receiveURL.kill();
            this.userName.kill();
            this.password.kill();
            this.sendRate.kill();
            this.sendRateUnit.kill();
            this.receiveRate.kill();
            this.receiveRateUnit.kill();
            this.companyID.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.articleCategories.kill();
            this.sep1.kill();
            this.useEspecsSynch.kill();
            this.resetLastReceiveDate.kill();
            this.resetLastReceiveDate = null;
            this.usersToInform.kill();
            this.usersToInform = null;
            this.moveFilesIntoBackup.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.port = null;
        this.sendButton = null;
        this.receiveButton = null;
        this.ftpURL = null;
        this.sendURL = null;
        this.receiveURL = null;
        this.history = null;
        this.userName = null;
        this.password = null;
        this.autoReceiveActive = null;
        this.autoSendActive = null;
        this.sendRate = null;
        this.sendRateUnit = null;
        this.receiveRate = null;
        this.receiveRateUnit = null;
        this.lastUpdates = null;
        this.companyID = null;
        this.saveButton = null;
        this.articleCategories = null;
        this.sep1 = null;
        this.useEspecsSynch = null;
        this.moveFilesIntoBackup = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.ESPECS;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.receiveButton || source == this.saveButton) {
            this.node.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_ESPECS);
                this.processFiles(false);
            } else if (source == this.receiveButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_ESPECS);
                this.processFiles(true);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else if (source == this.resetLastReceiveDate) {
            this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.sendDataExchangeSettings, SFTPDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.getChildNamed(new DtoField[]{ESpecsSettingsComplete_.receiveDataExchangeSettings, SFTPDataExchangeSettingsComplete_.lastDataTransaction}).setValue((Object)new Timestamp(0L), 0L);
            this.settings.commit();
            this.lastUpdates.setNode((Node)this.settings);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ESpecsInsert.this.settings.commit(ESpecsSettingsComplete.class);
                ESpecsSettingsComplete espec = (ESpecsSettingsComplete)ESpecsInsert.this.settings.getValue();
                espec.setMailType(MailTypeE.SendMail);
                espec.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                TimeUnitE unitSend = (TimeUnitE)ESpecsInsert.this.sendRateUnit.getSelectedItem();
                Double rateSend = (Double)((NumberTextField)ESpecsInsert.this.sendRate.getElement()).getNode().getValue();
                TimeDurationComplete tdcSend = null;
                if (espec.getSendTimerServiceSettings() == null) {
                    TimerServiceSettingsComplete tss = new TimerServiceSettingsComplete();
                    espec.setSendTimerServiceSettings(tss);
                }
                tdcSend = new TimeDurationComplete(unitSend, rateSend);
                espec.getSendTimerServiceSettings().setTimerServiceConfig((TimerServiceConfigComplete)tdcSend);
                espec.getSendTimerServiceSettings().setIntervallRateUnit(unitSend);
                espec.getSendTimerServiceSettings().setIntervallRateValue(rateSend);
                TimerServiceSettingsComplete sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(espec.getSendTimerServiceSettings()).getValue();
                espec.setSendTimerServiceSettings(sendTS);
                espec.getReceiveDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                espec.getReceiveDataExchangeSettings().setDataExchangePort(espec.getSendDataExchangeSettings().getDataExchangePort());
                espec.getReceiveDataExchangeSettings().setDataExchangeURL(espec.getSendDataExchangeSettings().getDataExchangeURL());
                espec.getReceiveDataExchangeSettings().setLoginUser(espec.getSendDataExchangeSettings().getLoginUser());
                espec.getReceiveDataExchangeSettings().setLoginPwd(espec.getSendDataExchangeSettings().getLoginPwd());
                TimeUnitE unitReceive = (TimeUnitE)ESpecsInsert.this.receiveRateUnit.getSelectedItem();
                Double rateReceive = (Double)((NumberTextField)ESpecsInsert.this.receiveRate.getElement()).getNode().getValue();
                TimeDurationComplete tdcReceive = null;
                if (espec.getReceiveTimerServiceSettings() == null) {
                    TimerServiceSettingsComplete tss = new TimerServiceSettingsComplete();
                    espec.setReceiveTimerServiceSettings(tss);
                }
                tdcReceive = new TimeDurationComplete(unitReceive, rateReceive);
                espec.getReceiveTimerServiceSettings().setTimerServiceConfig((TimerServiceConfigComplete)tdcReceive);
                espec.getReceiveTimerServiceSettings().setIntervallRateUnit(unitReceive);
                espec.getReceiveTimerServiceSettings().setIntervallRateValue(rateReceive);
                TimerServiceSettingsComplete receiveTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(espec.getReceiveTimerServiceSettings()).getValue();
                espec.setReceiveTimerServiceSettings(receiveTS);
                espec = (ESpecsSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)espec).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ESPECS_AUTO_RECEIVE_DATA, espec.getAutoReceiveData().booleanValue(), receiveTS, -1L);
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.ESPECS_AUTO_SEND_DATA, espec.getAutoSendData().booleanValue(), sendTS, -1L);
                ESpecsInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)espec, false, false);
                ESpecsInsert.this.lastUpdates.setNode(ESpecsInsert.this.settings);
                ESpecsInsert.this.history.setNode(ESpecsInsert.this.eSpecsData);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ESpecsInsert.this.hideAnimation();
                        ESpecsInsert.this.module.ended();
                        ESpecsInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ESpecsInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(final boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ESpecsConfig config = (ESpecsConfig)ESpecsInsert.this.node.getValue();
                config.setFormat(ReportingOutputFormatE.CSV);
                config.setIncludeHeaders(Boolean.valueOf(false));
                Node n = new Node();
                Map file = null;
                file = read ? ((ESpecsServiceManager)ServiceManagerRegistry.getService(ESpecsServiceManager.class)).readESpecsData(config).getMap() : ((ESpecsServiceManager)ServiceManagerRegistry.getService(ESpecsServiceManager.class)).sendESpecsData(config).getMap();
                n.setValue((Object)read, 0L);
                ESpecsSettingsComplete esc = (ESpecsSettingsComplete)((ESpecsServiceManager)ServiceManagerRegistry.getService(ESpecsServiceManager.class)).getEspecsSettings().getValue();
                ESpecsInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                ESpecsInsert.this.eSpecsData = (Node)new ViewNode("data");
                ESpecsInsert.this.lastUpdates.setNode(ESpecsInsert.this.settings);
                ESpecsInsert.this.history.setNode(ESpecsInsert.this.eSpecsData);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        ESpecsInsert.this.hideAnimation();
                        ESpecsInsert.this.module.ended();
                        ESpecsInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_IMPORTED, ESpecsInsert.this.receiveButton);
                        } else {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, ESpecsInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_CREATE_ESPECS_EXPORT, (Component)ESpecsInsert.this.sendButton);
                        ESpecsInsert.this.hideAnimation();
                        ESpecsInsert.this.setEnabled(true);
                        ESpecsInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ESpecsInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            ESpecsInsert.this.useEspecsSynch.setLocation(border, border + ESpecsInsert.this.configPanel.getTitleHeight());
            ESpecsInsert.this.useEspecsSynch.setSize(ESpecsInsert.this.useEspecsSynch.getPreferredSize());
            ESpecsInsert.this.autoSendActive.setLocation(border, ESpecsInsert.this.useEspecsSynch.getY() + ESpecsInsert.this.useEspecsSynch.getHeight());
            ESpecsInsert.this.autoSendActive.setSize(ESpecsInsert.this.autoSendActive.getPreferredSize());
            ESpecsInsert.this.autoReceiveActive.setLocation((parent.getWidth() + border) / 2, ESpecsInsert.this.autoSendActive.getY());
            ESpecsInsert.this.autoReceiveActive.setSize(ESpecsInsert.this.autoReceiveActive.getPreferredSize());
            ESpecsInsert.this.companyID.setLocation(border, ESpecsInsert.this.autoReceiveActive.getY() + ESpecsInsert.this.autoReceiveActive.getHeight() + border);
            ESpecsInsert.this.companyID.setSize(220, (int)ESpecsInsert.this.companyID.getPreferredSize().getHeight());
            ESpecsInsert.this.userName.setLocation(border, ESpecsInsert.this.companyID.getY() + ESpecsInsert.this.companyID.getHeight() + border);
            ESpecsInsert.this.userName.setSize(220, (int)ESpecsInsert.this.userName.getPreferredSize().getHeight());
            ESpecsInsert.this.password.setLocation(ESpecsInsert.this.userName.getX() + ESpecsInsert.this.userName.getWidth() + border, ESpecsInsert.this.userName.getY());
            ESpecsInsert.this.password.setSize(220, (int)ESpecsInsert.this.password.getPreferredSize().getHeight());
            ESpecsInsert.this.ftpURL.setLocation(border, ESpecsInsert.this.userName.getY() + ESpecsInsert.this.userName.getHeight());
            ESpecsInsert.this.ftpURL.setSize(220, (int)ESpecsInsert.this.ftpURL.getPreferredSize().getHeight());
            ESpecsInsert.this.port.setLocation(ESpecsInsert.this.ftpURL.getX() + ESpecsInsert.this.ftpURL.getWidth() + border, ESpecsInsert.this.ftpURL.getY());
            ESpecsInsert.this.port.setSize(80, (int)ESpecsInsert.this.port.getPreferredSize().getHeight());
            ESpecsInsert.this.sendURL.setLocation(border, ESpecsInsert.this.ftpURL.getY() + ESpecsInsert.this.ftpURL.getHeight());
            ESpecsInsert.this.sendURL.setSize(220, (int)ESpecsInsert.this.sendURL.getPreferredSize().getHeight());
            ESpecsInsert.this.receiveURL.setLocation(ESpecsInsert.this.password.getX(), ESpecsInsert.this.sendURL.getY());
            ESpecsInsert.this.receiveURL.setSize(220, (int)ESpecsInsert.this.receiveURL.getPreferredSize().getHeight());
            ESpecsInsert.this.moveFilesIntoBackup.setLocation(border, ESpecsInsert.this.receiveURL.getY() + ESpecsInsert.this.receiveURL.getHeight() + border);
            ESpecsInsert.this.moveFilesIntoBackup.setSize(260, (int)ESpecsInsert.this.moveFilesIntoBackup.getPreferredSize().getHeight());
            ESpecsInsert.this.sendRate.setLocation(border, ESpecsInsert.this.moveFilesIntoBackup.getY() + ESpecsInsert.this.moveFilesIntoBackup.getHeight() + border);
            ESpecsInsert.this.sendRate.setSize(100, (int)ESpecsInsert.this.sendRate.getPreferredSize().getHeight());
            ESpecsInsert.this.sendRateUnit.setLocation(ESpecsInsert.this.sendRate.getX() + ESpecsInsert.this.sendRate.getWidth() + 5, (int)((double)(ESpecsInsert.this.sendRate.getY() + ESpecsInsert.this.sendRate.getHeight()) - ESpecsInsert.this.sendRateUnit.getPreferredSize().getHeight()));
            ESpecsInsert.this.sendRateUnit.setSize(75, (int)ESpecsInsert.this.sendRateUnit.getPreferredSize().getHeight());
            ESpecsInsert.this.receiveRate.setLocation(ESpecsInsert.this.moveFilesIntoBackup.getX(), ESpecsInsert.this.moveFilesIntoBackup.getY() + ESpecsInsert.this.moveFilesIntoBackup.getHeight() + border);
            ESpecsInsert.this.receiveRate.setSize(100, (int)ESpecsInsert.this.receiveRate.getPreferredSize().getHeight());
            ESpecsInsert.this.receiveRateUnit.setLocation(ESpecsInsert.this.receiveRate.getX() + ESpecsInsert.this.receiveRate.getWidth() + 5, (int)((double)(ESpecsInsert.this.receiveRate.getY() + ESpecsInsert.this.receiveRate.getHeight()) - ESpecsInsert.this.receiveRateUnit.getPreferredSize().getHeight()));
            ESpecsInsert.this.receiveRateUnit.setSize(75, (int)ESpecsInsert.this.receiveRateUnit.getPreferredSize().getHeight());
            ESpecsInsert.this.lastUpdates.setLocation(border, ESpecsInsert.this.receiveRateUnit.getY() + ESpecsInsert.this.receiveRateUnit.getHeight());
            ESpecsInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)ESpecsInsert.this.lastUpdates.getPreferredSize().getHeight());
            ESpecsInsert.this.resetLastReceiveDate.setLocation(border, ESpecsInsert.this.lastUpdates.getY() + ESpecsInsert.this.lastUpdates.getHeight() + 5);
            ESpecsInsert.this.resetLastReceiveDate.setSize(ESpecsInsert.this.resetLastReceiveDate.getPreferredSize());
            ESpecsInsert.this.articleCategories.setLocation(1, ESpecsInsert.this.resetLastReceiveDate.getY() + ESpecsInsert.this.resetLastReceiveDate.getHeight() + border);
            ESpecsInsert.this.articleCategories.setSize(parent.getWidth() - 2, (int)ESpecsInsert.this.articleCategories.getPreferredSize().getHeight());
            ESpecsInsert.this.sep1.setLocation(1, ESpecsInsert.this.articleCategories.getY() + ESpecsInsert.this.articleCategories.getHeight() + 1);
            ESpecsInsert.this.sep1.setSize(parent.getWidth() - 2, (int)ESpecsInsert.this.sep1.getPreferredSize().getHeight());
            ESpecsInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - ESpecsInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + ESpecsInsert.this.saveButton.getPreferredSize().getHeight())));
            ESpecsInsert.this.saveButton.setSize(ESpecsInsert.this.saveButton.getPreferredSize());
            ESpecsInsert.this.usersToInform.setLocation(border, ESpecsInsert.this.sep1.getY() + ESpecsInsert.this.sep1.getHeight() + border);
            ESpecsInsert.this.usersToInform.setSize(parent.getWidth() - 2 * ESpecsInsert.this.usersToInform.getX(), parent.getHeight() - ESpecsInsert.this.usersToInform.getY());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ESpecsInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            ESpecsInsert.this.history.setLocation(0, ESpecsInsert.this.sendPanel.getTitleHeight());
            ESpecsInsert.this.history.setSize(parent.getWidth(), ESpecsInsert.this.sendPanel.getHeight() - (border + ESpecsInsert.this.sendPanel.getTitleHeight() + 100));
            ESpecsInsert.this.receiveButton.setLocation((int)((double)parent.getWidth() - ESpecsInsert.this.receiveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (2.0 * ESpecsInsert.this.receiveButton.getPreferredSize().getHeight() + (double)(2 * border))));
            ESpecsInsert.this.receiveButton.setSize(ESpecsInsert.this.receiveButton.getPreferredSize());
            ESpecsInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - ESpecsInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (ESpecsInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            ESpecsInsert.this.sendButton.setSize(ESpecsInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (ESpecsInsert.this.animation != null) {
                ESpecsInsert.this.animation.setLocation((int)((double)parent.getWidth() - ESpecsInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ESpecsInsert.this.animation.getPreferredSize().getHeight()) / 2);
                ESpecsInsert.this.animation.setSize(ESpecsInsert.this.animation.getPreferredSize());
            }
            if (ESpecsInsert.this.isInserted) {
                ESpecsInsert.this.configPanel.setLocation(border, border);
                ESpecsInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                ESpecsInsert.this.sendPanel.setLocation(ESpecsInsert.this.configPanel.getX() + ESpecsInsert.this.configPanel.getWidth() + border, border);
                ESpecsInsert.this.sendPanel.setSize(ESpecsInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

