/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.exchange.HalalCertificationStateExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.InternalConsumptionCalculationSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.internalconsumption.InternalConsumptionCalculationSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.report.especs.ESpecsConfig;
import ch.icit.pegasus.server.core.dtos.supply.halal.ArticleHalalStateSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InternalConsumptionCalculationExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useAutoCheck;
    private HorizontalSeparator sep1;
    private TablePanelAddSaveButton checkButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    private Node<InternalConsumptionCalculationSettingsComplete> settings;

    public InternalConsumptionCalculationExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
        ESpecsConfig e = new ESpecsConfig();
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useAutoCheck = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(InternalConsumptionCalculationSettingsComplete_.active)), "Auto Calculate Internal Consumption Transactions", TitledItem.TitledItemOrientation.EAST);
        this.useAutoCheck.getElement().addButtonListener(this);
        this.sep1 = new HorizontalSeparator();
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.checkButton = new TablePanelAddSaveButton();
        this.checkButton.setText(Words.CHECK_ALL);
        this.checkButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useAutoCheck);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.sep1);
        this.sendPanel.add(this.checkButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                InternalConsumptionCalculationSettingsComplete esc = null;
                try {
                    esc = (InternalConsumptionCalculationSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getInternalConsumptionCalculationSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    InternalConsumptionCalculationSettingsComplete s = new InternalConsumptionCalculationSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getTimerServiceSettings() == null) {
                    esc.setTimerServiceSettings(InternalConsumptionCalculationExchangeInsert.this.createTimerServiceTime());
                }
                InternalConsumptionCalculationExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return InternalConsumptionCalculationExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceTime() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(15.0)));
        s.setIntervallRateUnit(TimeUnitE.MINUTE);
        s.setIntervallRateValue(Double.valueOf(15.0));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useAutoCheck.setEnabled(isEnabled);
            boolean b = isEnabled && this.useAutoCheck.getElement().isChecked();
            this.checkButton.setEnabled(b);
            this.sep1.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.saveButton.kill();
            this.sep1.kill();
            this.useAutoCheck.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.checkButton = null;
        this.saveButton = null;
        this.sep1 = null;
        this.useAutoCheck = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return Words.INTERNAL_CONSUMPTION;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.checkButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.checkButton) {
                this.ensureAnimation(Words.EXCHANGE);
                this.processFiles(true);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateHalalConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateHalalConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                InternalConsumptionCalculationExchangeInsert.this.settings.commit(ArticleHalalStateSettingsComplete.class);
                InternalConsumptionCalculationSettingsComplete settingsValue = (InternalConsumptionCalculationSettingsComplete)InternalConsumptionCalculationExchangeInsert.this.settings.getValue();
                if (settingsValue.getTimerServiceSettings() == null || settingsValue.getTimerServiceSettings().getTimerServiceConfig() == null) {
                    settingsValue.setTimerServiceSettings(InternalConsumptionCalculationExchangeInsert.this.createTimerServiceTime());
                }
                TimerServiceSettingsComplete checkerTs = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(settingsValue.getTimerServiceSettings()).getValue();
                settingsValue = (InternalConsumptionCalculationSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)settingsValue).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.INTERNAL_CONSUMPTION_CALCULATION, settingsValue.getActive().booleanValue(), checkerTs, -1L);
                InternalConsumptionCalculationExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)settingsValue, false, false);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InternalConsumptionCalculationExchangeInsert.this.hideAnimation();
                        InternalConsumptionCalculationExchangeInsert.this.module.ended();
                        InternalConsumptionCalculationExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)InternalConsumptionCalculationExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((HalalCertificationStateExchangeServiceManager)ServiceManagerRegistry.getService(HalalCertificationStateExchangeServiceManager.class)).checkArticleHalalState();
                ViewNode n = new ViewNode("");
                n.setValue((Object)true, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InternalConsumptionCalculationExchangeInsert.this.hideAnimation();
                        InternalConsumptionCalculationExchangeInsert.this.module.ended();
                        InternalConsumptionCalculationExchangeInsert.this.setEnabled(true);
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, InternalConsumptionCalculationExchangeInsert.this.checkButton);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, Words.UNABLE_TO_PROCESS, (Component)InternalConsumptionCalculationExchangeInsert.this.checkButton);
                        InternalConsumptionCalculationExchangeInsert.this.hideAnimation();
                        InternalConsumptionCalculationExchangeInsert.this.setEnabled(true);
                        InternalConsumptionCalculationExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            InternalConsumptionCalculationExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            InternalConsumptionCalculationExchangeInsert.this.useAutoCheck.setLocation(border, border + InternalConsumptionCalculationExchangeInsert.this.configPanel.getTitleHeight());
            InternalConsumptionCalculationExchangeInsert.this.useAutoCheck.setSize(InternalConsumptionCalculationExchangeInsert.this.useAutoCheck.getPreferredSize());
            InternalConsumptionCalculationExchangeInsert.this.sep1.setLocation(1, InternalConsumptionCalculationExchangeInsert.this.useAutoCheck.getY() + InternalConsumptionCalculationExchangeInsert.this.useAutoCheck.getHeight() + 1);
            InternalConsumptionCalculationExchangeInsert.this.sep1.setSize(parent.getWidth() - 2, (int)InternalConsumptionCalculationExchangeInsert.this.sep1.getPreferredSize().getHeight());
            InternalConsumptionCalculationExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - InternalConsumptionCalculationExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + InternalConsumptionCalculationExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            InternalConsumptionCalculationExchangeInsert.this.saveButton.setSize(InternalConsumptionCalculationExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            InternalConsumptionCalculationExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            InternalConsumptionCalculationExchangeInsert.this.checkButton.setLocation((int)((double)parent.getWidth() - InternalConsumptionCalculationExchangeInsert.this.checkButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (2.0 * InternalConsumptionCalculationExchangeInsert.this.checkButton.getPreferredSize().getHeight() + (double)(2 * border))));
            InternalConsumptionCalculationExchangeInsert.this.checkButton.setSize(InternalConsumptionCalculationExchangeInsert.this.checkButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (InternalConsumptionCalculationExchangeInsert.this.animation != null) {
                InternalConsumptionCalculationExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - InternalConsumptionCalculationExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - InternalConsumptionCalculationExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                InternalConsumptionCalculationExchangeInsert.this.animation.setSize(InternalConsumptionCalculationExchangeInsert.this.animation.getPreferredSize());
            }
            if (InternalConsumptionCalculationExchangeInsert.this.isInserted) {
                InternalConsumptionCalculationExchangeInsert.this.configPanel.setLocation(border, border);
                InternalConsumptionCalculationExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                InternalConsumptionCalculationExchangeInsert.this.sendPanel.setLocation(InternalConsumptionCalculationExchangeInsert.this.configPanel.getX() + InternalConsumptionCalculationExchangeInsert.this.configPanel.getWidth() + border, border);
                InternalConsumptionCalculationExchangeInsert.this.sendPanel.setSize(InternalConsumptionCalculationExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

