/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.edelweiss;

import ch.icit.pegasus.client.converter.TrackedCommissionExchangeSettingsLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TrackedArticleCommissionExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TrackedArticleCommissionExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthE;
import ch.icit.pegasus.server.core.dtos.util.DayOfMonthTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class TrackedArticleCommissionExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useTrackedCommissionExchange;
    private TitledItem<TextField> notificationAddresses;
    private TitledItem<TextField> errorNotificationAddress;
    private TitledItem<TextField> notificationSenderAddress;
    private TextLabel lastUpdates;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    protected Node<TrackedArticleCommissionExchangeSettingsComplete> settings;
    protected TrackedArticleCommissionExchangeSettingsComplete rimsisc;

    public TrackedArticleCommissionExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useTrackedCommissionExchange = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(TrackedArticleCommissionExchangeSettingsComplete_.useTrackedArticleCommission)), "Use Tracked Commission Exchange", TitledItem.TitledItemOrientation.EAST);
        this.useTrackedCommissionExchange.getElement().addButtonListener(this);
        this.notificationAddresses = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(TrackedArticleCommissionExchangeSettingsComplete_.notificationAddresses)), "Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.errorNotificationAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(TrackedArticleCommissionExchangeSettingsComplete_.errorNotificationAddress)), "Error Notification Address", TitledItem.TitledItemOrientation.NORTH);
        this.notificationSenderAddress = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(TrackedArticleCommissionExchangeSettingsComplete_.notificationSenderAddress)), "Notification Sender Address", TitledItem.TitledItemOrientation.NORTH);
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(TrackedCommissionExchangeSettingsLastUpdateConverter.class));
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useTrackedCommissionExchange);
        this.configPanel.add(this.notificationAddresses);
        this.configPanel.add(this.errorNotificationAddress);
        this.configPanel.add(this.notificationSenderAddress);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                UnitToolkit.loadUnits();
                try {
                    TrackedArticleCommissionExchangeInsert.this.rimsisc = (TrackedArticleCommissionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrackedArticleCommissionSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (TrackedArticleCommissionExchangeInsert.this.rimsisc == null) {
                    TrackedArticleCommissionExchangeSettingsComplete s = new TrackedArticleCommissionExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    TrackedArticleCommissionExchangeInsert.this.rimsisc = s;
                }
                TrackedArticleCommissionExchangeInsert.this.rimsisc.setTimerServiceSettings(TrackedArticleCommissionExchangeInsert.this.createDailyTimerService());
                TrackedArticleCommissionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)TrackedArticleCommissionExchangeInsert.this.rimsisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return TrackedArticleCommissionExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new DayOfMonthTimeComplete(DayOfMonthE.LAST));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useTrackedCommissionExchange.setEnabled(isEnabled);
            boolean b = isEnabled && this.useTrackedCommissionExchange.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.notificationAddresses.setEnabled(b);
            this.errorNotificationAddress.setEnabled(b);
            this.notificationSenderAddress.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.notificationAddresses.kill();
            this.errorNotificationAddress.kill();
            this.notificationSenderAddress.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.useTrackedCommissionExchange.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.sendButton = null;
        this.lastUpdates = null;
        this.notificationAddresses = null;
        this.errorNotificationAddress = null;
        this.notificationSenderAddress = null;
        this.saveButton = null;
        this.useTrackedCommissionExchange = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Tracked Commission Prices";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation("Check for tracked commission price changes");
                this.processFiles();
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateRetailinMotionConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateRetailinMotionConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        settings.commitThis(SystemSettingsComplete.class);
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                TrackedArticleCommissionExchangeInsert.this.settings.commit(TrackedArticleCommissionExchangeSettingsComplete.class);
                TrackedArticleCommissionExchangeSettingsComplete rimsisc = (TrackedArticleCommissionExchangeSettingsComplete)TrackedArticleCommissionExchangeInsert.this.settings.getValue();
                if (Boolean.TRUE.equals(rimsisc.getUseTrackedArticleCommission())) {
                    rimsisc.setTimerServiceSettings(TrackedArticleCommissionExchangeInsert.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(rimsisc.getTimerServiceSettings()).getValue();
                    rimsisc.setTimerServiceSettings(ts);
                    rimsisc = (TrackedArticleCommissionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.TRACKED_COMMISSION_EXCHANGE, true, ts, -1L);
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsisc, false, false);
                    TrackedArticleCommissionExchangeInsert.this.lastUpdates.setNode(settings);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.TRACKED_COMMISSION_EXCHANGE);
                    rimsisc = (TrackedArticleCommissionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)rimsisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)rimsisc, false, false);
                    TrackedArticleCommissionExchangeInsert.this.lastUpdates.setNode(settings);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        TrackedArticleCommissionExchangeInsert.this.hideAnimation();
                        TrackedArticleCommissionExchangeInsert.this.module.ended();
                        TrackedArticleCommissionExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)TrackedArticleCommissionExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                ((EdelweissServiceManager)ServiceManagerRegistry.getService(EdelweissServiceManager.class)).sendCommissionTrackingFile();
                n.setValue((Object)true, 0L);
                TrackedArticleCommissionExchangeInsert.this.rimsisc = (TrackedArticleCommissionExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getTrackedArticleCommissionSettings().getValue();
                TrackedArticleCommissionExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)TrackedArticleCommissionExchangeInsert.this.rimsisc, false, false);
                TrackedArticleCommissionExchangeInsert.this.lastUpdates.setNode((Node)TrackedArticleCommissionExchangeInsert.this.settings);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        boolean read = (Boolean)node.getValue();
                        TrackedArticleCommissionExchangeInsert.this.hideAnimation();
                        TrackedArticleCommissionExchangeInsert.this.module.ended();
                        TrackedArticleCommissionExchangeInsert.this.setEnabled(true);
                        if (read) {
                            InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_PROCESSED, TrackedArticleCommissionExchangeInsert.this.sendButton);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Unable to send Report", (Component)TrackedArticleCommissionExchangeInsert.this.sendButton);
                        TrackedArticleCommissionExchangeInsert.this.hideAnimation();
                        TrackedArticleCommissionExchangeInsert.this.setEnabled(true);
                        TrackedArticleCommissionExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            TrackedArticleCommissionExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            TrackedArticleCommissionExchangeInsert.this.useTrackedCommissionExchange.setLocation(border, border + TrackedArticleCommissionExchangeInsert.this.configPanel.getTitleHeight());
            TrackedArticleCommissionExchangeInsert.this.useTrackedCommissionExchange.setSize(TrackedArticleCommissionExchangeInsert.this.useTrackedCommissionExchange.getPreferredSize());
            TrackedArticleCommissionExchangeInsert.this.notificationAddresses.setLocation(border, TrackedArticleCommissionExchangeInsert.this.useTrackedCommissionExchange.getY() + TrackedArticleCommissionExchangeInsert.this.useTrackedCommissionExchange.getHeight() + border);
            TrackedArticleCommissionExchangeInsert.this.notificationAddresses.setSize(300, (int)TrackedArticleCommissionExchangeInsert.this.notificationAddresses.getPreferredSize().getHeight());
            TrackedArticleCommissionExchangeInsert.this.errorNotificationAddress.setLocation(border, TrackedArticleCommissionExchangeInsert.this.notificationAddresses.getY() + TrackedArticleCommissionExchangeInsert.this.notificationAddresses.getHeight());
            TrackedArticleCommissionExchangeInsert.this.errorNotificationAddress.setSize(300, (int)TrackedArticleCommissionExchangeInsert.this.errorNotificationAddress.getPreferredSize().getHeight());
            TrackedArticleCommissionExchangeInsert.this.notificationSenderAddress.setLocation(border, TrackedArticleCommissionExchangeInsert.this.errorNotificationAddress.getY() + TrackedArticleCommissionExchangeInsert.this.errorNotificationAddress.getHeight() + border);
            TrackedArticleCommissionExchangeInsert.this.notificationSenderAddress.setSize(300, (int)TrackedArticleCommissionExchangeInsert.this.notificationSenderAddress.getPreferredSize().getHeight());
            TrackedArticleCommissionExchangeInsert.this.lastUpdates.setLocation(border, TrackedArticleCommissionExchangeInsert.this.notificationSenderAddress.getY() + TrackedArticleCommissionExchangeInsert.this.notificationSenderAddress.getHeight());
            TrackedArticleCommissionExchangeInsert.this.lastUpdates.setSize(TrackedArticleCommissionExchangeInsert.this.lastUpdates.getPreferredSize());
            TrackedArticleCommissionExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - TrackedArticleCommissionExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + TrackedArticleCommissionExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            TrackedArticleCommissionExchangeInsert.this.saveButton.setSize(TrackedArticleCommissionExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            TrackedArticleCommissionExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            TrackedArticleCommissionExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - TrackedArticleCommissionExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (TrackedArticleCommissionExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            TrackedArticleCommissionExchangeInsert.this.sendButton.setSize(TrackedArticleCommissionExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (TrackedArticleCommissionExchangeInsert.this.animation != null) {
                TrackedArticleCommissionExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - TrackedArticleCommissionExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - TrackedArticleCommissionExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                TrackedArticleCommissionExchangeInsert.this.animation.setSize(TrackedArticleCommissionExchangeInsert.this.animation.getPreferredSize());
            }
            if (TrackedArticleCommissionExchangeInsert.this.isInserted) {
                TrackedArticleCommissionExchangeInsert.this.configPanel.setLocation(border, border);
                TrackedArticleCommissionExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                TrackedArticleCommissionExchangeInsert.this.sendPanel.setLocation(TrackedArticleCommissionExchangeInsert.this.configPanel.getX() + TrackedArticleCommissionExchangeInsert.this.configPanel.getWidth() + border, border);
                TrackedArticleCommissionExchangeInsert.this.sendPanel.setSize(TrackedArticleCommissionExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

