/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class RemarkDetailsPanel
extends DefaultDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextArea> textArea;
    private TitledItem<RDTextArea> invoiceRemark;
    private TitledItem<RDTextArea> checkerRemark;
    private TitledItem<RDCheckBox> showForDispatch;
    private TitledItem<RDCheckBox> showForChecker;
    private Node<FlightComplete> root;
    private FlightEditableChecker checker = new FlightEditableChecker();

    public RemarkDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true);
        this.setTitleText(Words.REMARK);
        this.textArea = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.CREW_REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.invoiceRemark = new TitledItem<RDTextArea>(new RDTextArea(provider), Words.INVOICE_REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.checkerRemark = new TitledItem<RDTextArea>(new RDTextArea(provider), "Internal Remark", TitledItem.TitledItemOrientation.NORTH);
        this.showForChecker = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Show for Checker", TitledItem.TitledItemOrientation.EAST);
        this.showForDispatch = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Show for Dispatch", TitledItem.TitledItemOrientation.EAST);
        this.checkerRemark.getElement().setMaxStringLength(Integer.MAX_VALUE);
        this.invoiceRemark.getElement().setMaxStringLength(Integer.MAX_VALUE);
        this.textArea.getElement().setMaxStringLength(Integer.MAX_VALUE);
        this.textArea.setIgnorePrefHeight(true);
        this.invoiceRemark.setIgnorePrefHeight(true);
        this.checkerRemark.setIgnorePrefHeight(true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.textArea);
        this.addToView(this.invoiceRemark);
        this.add(this.checkerRemark);
        this.add(this.showForChecker);
        this.add(this.showForDispatch);
    }

    @Override
    public void setNode(Node<?> node) {
        this.root = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.textArea.getElement().setNode(node.getChildNamed(FlightComplete_.crewRemark));
        this.invoiceRemark.getElement().setNode(node.getChildNamed(FlightComplete_.invoiceRemark));
        this.checkerRemark.getElement().setNode(node.getChildNamed(FlightComplete_.internalComment));
        this.showForDispatch.getElement().setNode(node.getChildNamed(FlightComplete_.showDispatchMessage));
        this.showForChecker.getElement().setNode(node.getChildNamed(FlightComplete_.showCheckerMessage));
        super.setNode(node);
        try {
            String message;
            if (Boolean.TRUE.equals(node.getChildNamed(FlightComplete_.showDispatchMessage).getValue()) && !StringUtil.isBlank((String)(message = (String)node.getChildNamed(FlightComplete_.internalComment).getValue()))) {
                InnerPopupFactory.showSimpleMessage("Internal Comment", this.formatToHTML(message), this.checkerRemark);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String formatToHTML(String text) {
        return text.replaceAll("\\n", "<br/>");
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.textArea.getElement() != null && this.textArea.getElement().getNode() != null && this.textArea.getElement().getNode().getValue() != null) {
            return !((String)this.textArea.getElement().getNode().getValue()).isEmpty();
        }
        if (this.invoiceRemark.getElement() != null && this.invoiceRemark.getElement().getNode() != null && this.invoiceRemark.getElement().getNode().getValue() != null) {
            return !((String)this.invoiceRemark.getElement().getNode().getValue()).isEmpty();
        }
        if (this.checkerRemark.getElement() != null && this.checkerRemark.getElement().getNode() != null && this.checkerRemark.getElement().getNode().getValue() != null) {
            return !((String)this.checkerRemark.getElement().getNode().getValue()).isEmpty();
        }
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enabled = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(enabled);
        this.textArea.setEnabled(enabled);
        this.invoiceRemark.setEnabled(enabled);
        this.checkerRemark.setEnabled(enabled);
        this.showForChecker.setEnabled(enabled);
        this.showForDispatch.setEnabled(enabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.textArea.kill();
        this.textArea = null;
        this.invoiceRemark.kill();
        this.invoiceRemark = null;
        this.checkerRemark.kill();
        this.showForDispatch.kill();
        this.showForChecker.kill();
        this.checkerRemark = null;
        this.showForChecker = null;
        this.showForDispatch = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.showForChecker);
        CheckedListAdder.addToList(focusList, this.showForDispatch);
        CheckedListAdder.addToList(focusList, this.checkerRemark);
        CheckedListAdder.addToList(focusList, this.textArea);
        CheckedListAdder.addToList(focusList, this.invoiceRemark);
        return focusList;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = parent.getWidth() - 4 * RemarkDetailsPanel.this.horizontalBorder;
            w2tl /= 3;
            RemarkDetailsPanel.this.showForChecker.setLocation(RemarkDetailsPanel.this.horizontalBorder, RemarkDetailsPanel.this.getTitleHeight() + RemarkDetailsPanel.this.verticalBorder);
            RemarkDetailsPanel.this.showForChecker.setSize(RemarkDetailsPanel.this.showForChecker.getPreferredSize());
            RemarkDetailsPanel.this.showForDispatch.setLocation(RemarkDetailsPanel.this.showForChecker.getX(), RemarkDetailsPanel.this.showForChecker.getY() + RemarkDetailsPanel.this.showForChecker.getHeight());
            RemarkDetailsPanel.this.showForDispatch.setSize(RemarkDetailsPanel.this.showForDispatch.getPreferredSize());
            RemarkDetailsPanel.this.checkerRemark.setLocation(RemarkDetailsPanel.this.horizontalBorder, RemarkDetailsPanel.this.showForDispatch.getY() + RemarkDetailsPanel.this.showForDispatch.getHeight() + RemarkDetailsPanel.this.inner_verticalBorder);
            RemarkDetailsPanel.this.checkerRemark.setSize(w2tl, parent.getHeight() - (RemarkDetailsPanel.this.verticalBorder + RemarkDetailsPanel.this.checkerRemark.getY()));
            RemarkDetailsPanel.this.textArea.setLocation(RemarkDetailsPanel.this.checkerRemark.getX() + RemarkDetailsPanel.this.checkerRemark.getWidth() + RemarkDetailsPanel.this.horizontalBorder, RemarkDetailsPanel.this.verticalBorder);
            RemarkDetailsPanel.this.textArea.setSize(w2tl, parent.getHeight() - 2 * RemarkDetailsPanel.this.verticalBorder);
            RemarkDetailsPanel.this.invoiceRemark.setLocation(RemarkDetailsPanel.this.textArea.getX() + RemarkDetailsPanel.this.textArea.getWidth() + RemarkDetailsPanel.this.horizontalBorder, RemarkDetailsPanel.this.verticalBorder);
            RemarkDetailsPanel.this.invoiceRemark.setSize(w2tl, parent.getHeight() - 2 * RemarkDetailsPanel.this.verticalBorder);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 150);
        }
    }
}

