/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightHandlingCostTable;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.StowinglistHandlingCostTable;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.modules.flightschedule.details.utils.HandlingCostTable;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlingCostDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private static final Logger log = LoggerFactory.getLogger(HandlingCostDetailsPanel.class);
    private static final long serialVersionUID = 1L;
    private HandlingCostTable table;
    private Node<?> node;
    private boolean isFlight;
    private FlightEditableChecker checker = new FlightEditableChecker();

    public HandlingCostDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean isFlightSchedule, boolean fromStowingList) {
        super(editor, provider, true, true, !isFlightSchedule);
        this.isFlight = !isFlightSchedule;
        this.setTitleText(Words.HANDLING_COSTS);
        if (isFlightSchedule) {
            this.table = new HandlingCostTable(provider, false, false, null){

                public Node getCustomerNode() {
                    return HandlingCostDetailsPanel.this.node.getChildNamed(HandlingCostComplete_.customer);
                }

                @Override
                public DtoField[] getAttributeName() {
                    return new DtoField[]{FlightScheduleComplete_.handlingCosts};
                }
            };
        } else if (fromStowingList) {
            this.setTitleText(Words.HANDLING_COST_STW);
            this.table = new StowinglistHandlingCostTable(provider, false){

                @Override
                public Node getCustomerNode() {
                    return HandlingCostDetailsPanel.this.node.getChildNamed(StowingListTemplateComplete_.customer);
                }
            };
            this.table.setEditable(false);
        } else {
            this.table = new FlightHandlingCostTable(provider, false){

                @Override
                public Node getCustomerNode() {
                    return HandlingCostDetailsPanel.this.node.getChildNamed(FlightLight_.customer);
                }
            };
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public boolean hasExpandableContent() {
        if (this.isFlight) {
            if (this.table != null) {
                return !this.table.getTable().getRows().isEmpty();
            }
            return false;
        }
        return super.hasExpandableContent();
    }

    @Override
    public void setNode(Node<?> node) {
        this.node = node;
        this.table.setNode(node);
        super.setNode(node);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean b = isEnabled;
        boolean isDraft = true;
        if (this.node != null && !this.isFlight) {
            try {
                isDraft = this.node.getChildNamed(FlightScheduleComplete_.state).getValue() != ModificationStateE.ACCEPTED;
            }
            catch (Exception e) {
                log.error("Error while setEnable", (Throwable)e);
            }
        }
        if (this.isFlight) {
            b = this.checker.canEditFlight(this.node, this.provider, isEnabled);
        }
        b = b && isDraft;
        super.setEnabled(b);
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
            if (isEnabled) {
                this.table.setEditable(b);
            }
        }
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getTable().getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        validationObjects.addAll(this.table.validateTable(true));
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            HandlingCostDetailsPanel.this.table.setLocation(0, 0);
            HandlingCostDetailsPanel.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }
    }
}

