/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details;

import ch.icit.pegasus.client.converter.DiscountTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.VariantBasedStateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.DiscountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DiscountDetailsPanel
extends VariantBasedStateDependantTableDetailsPanel<HandlingCostVariantComplete, HandlingCostComplete> {
    private static final long serialVersionUID = 1L;
    private boolean isDiscountsDeletable;
    private boolean isDiscountsWritable;

    public DiscountDetailsPanel(RowEditor<HandlingCostComplete> editor, RDProvider provider) {
        super(editor, provider, true);
        this.setTitleText(Words.DISCOUNT);
        this.isDiscountsDeletable = provider.isDeletable(HandlingCostVariantComplete_.discounts);
        this.isDiscountsWritable = provider.isWritable(HandlingCostVariantComplete_.discounts);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DISCOUNT, null, null, null, "", 30, 30, 30));
        int dw2 = this.table.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", dw2, dw2, dw2));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(HandlingCostVariantComplete_.discounts);
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        DiscountTypeComplete p = this.getFreeTaxRate();
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)p, true, true);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        this.table.enableAddButton(this.hasFreeTaxRates());
        this.editor.revalidate();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        DiscountTableRowImpl rowPanel = new DiscountTableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return HandlingCostVariantComplete_.state;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    private boolean hasFreeTaxRates() {
        Node n = NodeToolkit.getAffixList(DiscountTypeComplete.class);
        return n.getChildCount() != this.table.getRowCount();
    }

    private DiscountTypeComplete getFreeTaxRate() {
        Node n = NodeToolkit.getAffixList(DiscountTypeComplete.class);
        Iterator it = n.getChilds();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            Iterator<Table2RowPanel> it2 = this.table.getRows().iterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Node nnn = it2.next().getModel().getNode();
                if (!((DiscountTypeComplete)nn.getValue()).equals(nnn.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (DiscountTypeComplete)nn.getValue();
        }
        return null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(HandlingCostVariantComplete_.discounts));
    }

    private class DiscountTableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private ComboBox discountType;
        private DeleteButton deleteButton;

        public DiscountTableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new InnerLayout());
            this.discountType = new ComboBox(m.getNode(), NodeToolkit.getAffixList(DiscountTypeComplete.class), ConverterRegistry.getConverter(DiscountTypeConverter.class));
            if (DiscountDetailsPanel.this.isDiscountsDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.addButtonListener(this);
                this.deleteButton.setProgress(1.0f);
                this.add(this.deleteButton);
            }
            this.discountType.setProgress(1.0f);
            this.add(this.discountType);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.discountType.getStringValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.discountType.setEnabled(isEnabled && DiscountDetailsPanel.this.isDiscountsWritable);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            focusList.addAll(this.discountType.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.discountType.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.discountType.kill();
            this.discountType = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = DiscountTableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                DiscountTableRowImpl.this.discountType.setLocation(currentX + DiscountTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - DiscountTableRowImpl.this.discountType.getPreferredSize().getHeight()) / 2.0));
                DiscountTableRowImpl.this.discountType.setSize(w - 2 * DiscountTableRowImpl.this.getCellPadding(), (int)DiscountTableRowImpl.this.discountType.getPreferredSize().getHeight());
                currentX += w;
                w = DiscountTableRowImpl.this.model.getParentModel().getColumnWidth(1);
                if (DiscountTableRowImpl.this.deleteButton != null) {
                    DiscountTableRowImpl.this.deleteButton.setLocation(currentX + DiscountTableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - DiscountTableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    DiscountTableRowImpl.this.deleteButton.setSize(DiscountTableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, DiscountTableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

