/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.importer;

import ch.icit.pegasus.client.gui.table.commiter.ClientFileTransferListener;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.PrintPopupInsert;
import ch.icit.pegasus.client.io.FileTransferState;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.importer.DataImportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.LoggingServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.utils.ImportType;
import ch.icit.pegasus.server.core.exception.InternalServerException;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LoadingInsert
extends PrintPopupInsert
implements ClientFileTransferListener {
    private static final long serialVersionUID = 1L;
    private File currentFile;
    private ImportType currentType;

    public LoadingInsert(ImportType t, File data) {
        super(true);
        this.currentType = t;
        this.currentFile = data;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.enterPressed(PopupAction.OK_FOREGROUND);
    }

    @Override
    protected int layoutInheritedComponents(Component parent) {
        if (this.animation != null) {
            this.animation.setLocation((int)((double)parent.getWidth() - this.animation.getPreferredSize().getWidth()) / 2, (int)(((double)parent.getHeight() - this.animation.getPreferredSize().getHeight()) / 2.0));
            this.animation.setSize(this.animation.getPreferredSize());
        }
        if (this.msg != null) {
            int ax = 0;
            int aw = 0;
            if (this.msg.getPreferredSize().getWidth() > (double)parent.getWidth()) {
                ax = 5;
                aw = parent.getWidth() - 10;
            } else {
                ax = (int)((double)parent.getWidth() - this.msg.getPreferredSize().getWidth()) / 2;
                aw = (int)this.msg.getPreferredSize().getWidth();
            }
            int ay = 0;
            int ah = 0;
            if (this.msg.getPreferredSize().getHeight() > (double)parent.getHeight()) {
                ay = 5;
                ah = parent.getHeight() - 10;
            } else {
                ay = (int)(((double)parent.getHeight() - this.msg.getPreferredSize().getHeight()) / 2.0);
                ah = (int)this.msg.getPreferredSize().getHeight();
            }
            this.msg.setLocation(5, 5);
            this.msg.setSize(parent.getWidth() - 10, parent.getHeight() - 10);
        }
        return 0;
    }

    @Override
    protected void startPrinting() {
        this.printed = true;
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.removeInheritedComponents();
        this.ensureAnimation("Import " + this.currentType);
        final FileCommitter c = new FileCommitter(this.currentFile, FileCategoryE.TEMP);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                c.commit(LoadingInsert.this);
                PegasusFileComplete f = c.getRemoteRef();
                FileCommitter cc = c;
                String ret = null;
                switch (LoadingInsert.this.currentType) {
                    case SUPPLIER_VENDOR_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierVendorType(f);
                        break;
                    }
                    case STOWING_LIST_INTERNAL_COMMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListInternalComment(f);
                        break;
                    }
                    case STOWING_LIST_GALLEY_NAMES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListGalleyNames(f);
                        break;
                    }
                    case STOWING_LIST_NAMES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListNames(f);
                        break;
                    }
                    case STOWING_LIST_HANDLING_COST: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListHandlingCosts(f);
                        break;
                    }
                    case CHARGE_DOCUMENTS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importChargeDocuments(f);
                        break;
                    }
                    case DEPARTMENT_MAIL_ADDRESS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importDepartmentMailAddresses(f);
                        break;
                    }
                    case SUPPLIER_DELIVERY_WINDOW: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierDeliveryWindow(f);
                        break;
                    }
                    case ARTICLE_DELETE_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleDeleteState(f);
                        break;
                    }
                    case ARTICLE_COMMODITY_NUMBER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCommodityNumber(f);
                        break;
                    }
                    case PRODUCT_BAR_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductBarCode(f);
                        break;
                    }
                    case PRODUCT_PACK_SIZE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductPackSize(f);
                        break;
                    }
                    case PRODUCT_PRICE_FACTORS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductPriceFactor(f);
                        break;
                    }
                    case PRODUCT_CREATE_FROM_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCreateFromArticle(f);
                        break;
                    }
                    case PRODUCT_DELIVERY_UNIT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductDeliveryUnit(f);
                        break;
                    }
                    case ARTICLE_GRAMMAGE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleGrammage(f);
                        break;
                    }
                    case ARTICLE_AUTO_CHECKOUT_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleAutocheckoutState(f);
                        break;
                    }
                    case ARTICLE_ALCOHOL_LEVEL: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleAlcoholLevel(f);
                        break;
                    }
                    case ARTICLE_INVENTORY_TRANSITION_COMMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importInventoryTransitionComment(f);
                        break;
                    }
                    case ARTICLE_WASTE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleWaste(f);
                        break;
                    }
                    case ARTICLE_GMC_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleGMCCode(f);
                        break;
                    }
                    case ARTICLE_REQUEST_ALLERGEN_UPDATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importAllergenUpdateRequest(f);
                        break;
                    }
                    case PRODUCT_GROUP_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupRename(f);
                        break;
                    }
                    case PRODUCT_GROUP_PRODUCTION_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupProductionName(f);
                        break;
                    }
                    case PRODUCT_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductType(f);
                        break;
                    }
                    case PRODUCT_COMPONENT_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductComponentType(f);
                        break;
                    }
                    case SAGE_ACCOUNT_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSageAccountType(f);
                        break;
                    }
                    case STORE_BARCODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStoreBarcode(f);
                        break;
                    }
                    case PRODUCT_KONTER_PROBE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductTakeKonterProbe(f);
                        break;
                    }
                    case STORE_POSITION_BARCODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStorePositionBarcode(f);
                        break;
                    }
                    case STOWING_LIST_FLIGHT_LEVEL: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListFlightLevel(f);
                        break;
                    }
                    case STOWING_LIST_LABEL_LAYOUT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListLabelLayout(f);
                        break;
                    }
                    case RECIPE_USE_DEFAULT_DEPARTMENT_FOR_CCP2: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeUseDefaultDepartmentForCCP2(f);
                        break;
                    }
                    case RECIPE_USE_RESERVE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeUseReserve(f);
                        break;
                    }
                    case RECIPE_ALWAYS_ON_OPRP05: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeAlwaysOnOPRP05(f);
                        break;
                    }
                    case MIGROS_STORE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importMigrosStore(f);
                        break;
                    }
                    case RECIPE_EXCLUDE_FROM_KONTER_PROBE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeExcludeFromKonterProbe(f);
                        break;
                    }
                    case ARTICLE_CUSTOMS_DEADLINE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCustomsDeadline(f);
                        break;
                    }
                    case PRODUCT_DISCOUNTS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductDiscounts(f);
                        break;
                    }
                    case PRODUCT_TAXES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductTaxes(f);
                        break;
                    }
                    case PRODUCT_NOMINATED: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductNominated(f);
                        break;
                    }
                    case FLIGHT_HAUL_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightHaulType(f);
                        break;
                    }
                    case FLIGHT_SCHEDULE_HAUL_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightScheduleHaulType(f);
                        break;
                    }
                    case FLIGHT_CATEGORY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightCategory(f);
                        break;
                    }
                    case FLIGHT_SCHEDULE_CATEGORY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightScheduleCategory(f);
                        break;
                    }
                    case STOWING_LIST_DELETE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListDelete(f);
                        break;
                    }
                    case STOWING_LIST_DEPARTMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListDepartment(f);
                        break;
                    }
                    case STOWING_LIST_DIRECTION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListDirection(f);
                        break;
                    }
                    case STOWING_LIST_ADD_VARIANT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListAddVariant(f);
                        break;
                    }
                    case STOWING_LIST_LABEL_COLOR: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListLabelColor(f);
                        break;
                    }
                    case STOWING_LIST_PRODUCT_REPLACE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListProductReplace(f);
                        break;
                    }
                    case STOWING_LIST_SCAN_LABEL: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStowingListScanLabel(f);
                        break;
                    }
                    case PRODUCT_BOUND_DIRECTION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductBoundDirection(f);
                        break;
                    }
                    case PRODUCT_CABIN_CLASS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCabinClass(f);
                        break;
                    }
                    case PRODUCT_CYCLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCycle(f);
                        break;
                    }
                    case PRODUCT_HAUL_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductHaulType(f);
                        break;
                    }
                    case PRODUCT_HINT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductHint(f);
                        break;
                    }
                    case PRODUCT_SERVICE_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductServiceType(f);
                        break;
                    }
                    case PRODUCT_ADD_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductArticleAdd(f);
                        break;
                    }
                    case PRODUCT_ADD_RECIPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductRecipeAdd(f);
                        break;
                    }
                    case PRODUCT_MEAL_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductMealType(f);
                        break;
                    }
                    case PRODUCT_SPML_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductSPMLType(f);
                        break;
                    }
                    case PRODUCT_MERGE_GROUPS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductMergeGroup(f);
                        break;
                    }
                    case PRODUCT_CATEGORY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCategory(f);
                        break;
                    }
                    case PRODUCT_AIS_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductAISName(f);
                        break;
                    }
                    case PRODUCT_COMMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductComment(f);
                        break;
                    }
                    case PRODUCT_CUSTOMER_NO: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCustomerNumber(f);
                        break;
                    }
                    case PRODUCT_LABEL_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductLabelName(f);
                        break;
                    }
                    case PRODUCT_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductName(f);
                        break;
                    }
                    case PRODUCT_AUTO_CHECKOUT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductAutoCheckoutState(f);
                        break;
                    }
                    case PRODUCT_BONDED_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductBondedState(f);
                        break;
                    }
                    case PRODUCT_CUSTOMER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCustomer(f);
                        break;
                    }
                    case PRODUCT_RC_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductReturnsCountState(f);
                        break;
                    }
                    case PRODUCT_SHOW_ON_KITCHEN_OPS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductShowOnKitchen(f);
                        break;
                    }
                    case PRODUCT_SOB_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductSobState(f);
                        break;
                    }
                    case PRODUCT_PERIOD_CUT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductPeriodCut(f);
                        break;
                    }
                    case PRODUCT_CHANGE_FROM_SIMPLE_TO_COMPLEX: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductChangeFromSimpleToComplexProduct(f);
                        break;
                    }
                    case ARTICLE_DEPARTMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleDepartment(f);
                        break;
                    }
                    case RECIPE_DEPARTMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeDepartment(f);
                        break;
                    }
                    case RECIPE_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeName(f);
                        break;
                    }
                    case PRODUCT_SOB_PRICE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductSobPrice(f);
                        break;
                    }
                    case PRODUCT_DEPARTMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductDepartment(f);
                        break;
                    }
                    case PRODUCT_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductState(f);
                        break;
                    }
                    case ARTICLE_PRODUCTION_DEPTH: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleProductionDepth(f);
                        break;
                    }
                    case ARTICLE_CATEGORY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCategory(f);
                        break;
                    }
                    case ARTICLE_RETAIL_IN_MOTION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleRetailInMotion(f);
                        break;
                    }
                    case ARTICLE_NOMINATED: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleNominatedState(f);
                        break;
                    }
                    case PRODUCT_COPY_PRODUCTIVE_TO_TENDER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCopyProductiveToTender(f);
                        break;
                    }
                    case PRODUCT_GROUP_MANMINUTES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupManMinutes(f);
                        break;
                    }
                    case PRODUCT_MANMINUTES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductManMinutes(f);
                        break;
                    }
                    case PRODUCT_SAP_NUMBER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductSapNumber(f);
                        break;
                    }
                    case ARTICLE_SAP_NUMBER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleSapNumber(f);
                        break;
                    }
                    case ARTICLE_CUSTOMS_TARIFF: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCustomsNumber(f);
                        break;
                    }
                    case ARTICLE_NOTIFY_PURCHASE_PRICE_CHANGE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleNotifyPurchasePriceChange(f);
                        break;
                    }
                    case PRODUCT_CREATE_RETAILINMOTION_TRANSACTIONS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductRetailInMotionTransactions(f);
                        break;
                    }
                    case RECIPE_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeState(f);
                        break;
                    }
                    case RECIPE_EAN_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeEanCode(f);
                        break;
                    }
                    case PRODUCT_EAN_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductEanCode(f);
                        break;
                    }
                    case ARTICLE_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleState(f);
                        break;
                    }
                    case PRODUCT_GROUP_COMPONENT_DEPARTMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupComponentDepartment(f);
                        break;
                    }
                    case PRODUCT_COPY_TENDER_TO_PRODUCTIVE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCopyTenderToProductive(f);
                        break;
                    }
                    case PRODUCT_COPY_TO_NEW_CUSTOMER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCopyNewCustomer(f);
                        break;
                    }
                    case FLIGHT_SCHEDULE_SHORT_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightScheduleShortCode(f);
                        break;
                    }
                    case PRODUCT_VARIANT_COMMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductInternalComment(f);
                        break;
                    }
                    case PRODUCT_DELETE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductDelete(f);
                        break;
                    }
                    case ARTICLE_REQUISITION_ORDER_UNIT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleRequisitionOrderUnit(f);
                        break;
                    }
                    case ARTICLE_UNIT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleUnit(f);
                        break;
                    }
                    case ARTICLE_TYPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleType(f);
                        break;
                    }
                    case ARTICLE_CREATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCreate(f);
                        break;
                    }
                    case ARTICLE_INVOICE_COMMISSION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCommission(f);
                        break;
                    }
                    case ARTICLE_SUPPLIER_CONDITION_DELIVERY_TIME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleSupplierConditionDeliveryTime(f);
                        break;
                    }
                    case ARTICLE_INCLUDE_FOR_INVOICE_COMMISSION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleIncludeCommissionInvoice(f);
                        break;
                    }
                    case ARTICLE_STD_PRICE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleStdPrice(f);
                        break;
                    }
                    case ARTICLE_BONDED_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleBondedState(f);
                        break;
                    }
                    case ARTICLE_KONTER_PROBE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleKonterProbe(f);
                        break;
                    }
                    case ARTICLE_EXCLUDE_FROM_CALCULATION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleExcludeFromCalculation(f);
                        break;
                    }
                    case ARTICLE_X_RAY_NEEDED: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleXRayNeeded(f);
                        break;
                    }
                    case ARTICLE_EAN_CODE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleEAN(f);
                        break;
                    }
                    case ARTICLE_NAMES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleNames(f);
                        break;
                    }
                    case RECIPE_MAN_MINUTE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeManMinute(f);
                        break;
                    }
                    case PRODUCT_GROUP_COMPONENT_MAN_MINUTES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupComponentManMinutes(f);
                        break;
                    }
                    case FLIGHT_SCHEDULE_TRANSIT_RELEVANT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightScheduleTransitRelevant(f);
                        break;
                    }
                    case ARTICLE_SUPPLIER_CONDITION_ARTICLE_NUMBER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleSupplierConditionArticleNumber(f);
                        break;
                    }
                    case ARTICLE_HALAL: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleHalalFlag(f);
                        break;
                    }
                    case ARTICLE_NO_EXPIRY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleNoExpiry(f);
                        break;
                    }
                    case ARTICLE_PURCHASE_CHARGE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleNoPurchaseCharge(f);
                        break;
                    }
                    case RECIPE_PREPARATION_GROUP: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipePreparationGroup(f);
                        break;
                    }
                    case CATEGORY_CUSTOMS_TARIFF: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCategoryCustomsTariff(f);
                        break;
                    }
                    case CATEGORY_WASTES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCategoryWastes(f);
                        break;
                    }
                    case CATEGORY_TENDER_WASTES: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleCategoryTenderWastes(f);
                        break;
                    }
                    case ARTICLE_COMMENTS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleComments(f);
                        break;
                    }
                    case ARTICLE_CHILLED: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleChill(f);
                        break;
                    }
                    case ARTICLE_FROZEN: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleFrozen(f);
                        break;
                    }
                    case ARTICLE_STORE_CONDITION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleStores(f);
                        break;
                    }
                    case AIRPORT_COUNTRY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importAirportCountry(f);
                        break;
                    }
                    case ARTICLE_ORIGIN_COUNTRY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleOriginCountry(f);
                        break;
                    }
                    case RECIPE_PRODUCT_GROUP: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeProductGroup(f);
                        break;
                    }
                    case ARTICLE_IN_USE_AND_DELETED_STATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleInUseAndDeletedState(f);
                        break;
                    }
                    case PRODUCT_COMPONENT_COMMENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductComponentComment(f);
                        break;
                    }
                    case ARTICLE_CHARGE_CONVERSION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importChargeConversion(f);
                        break;
                    }
                    case ARTICLE_CONVERSION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleConversion(f);
                        break;
                    }
                    case PRODUCT_PRICE_FOR_CUSTOMER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductPriceForCustomer(f);
                        break;
                    }
                    case SUPPLIER_KNOWN_SUPPLIER_FLAG: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierKnownSupplierFlag(f);
                        break;
                    }
                    case AIRPORT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importAirport(f);
                        break;
                    }
                    case CUSTOMER_GLOBAL_LOCATION_NUMBER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importCustomerGlobalLocationNumber(f);
                        break;
                    }
                    case CUSTOMER_PICK_N_PAY_FLAG: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importCustomerPickNPayFlag(f);
                        break;
                    }
                    case PRODUCT_CLEAN_AND_CREATE_PRODUCT_GROUP_COMPONENT: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductGroupAndComponent(f);
                        break;
                    }
                    case PRODUCT_CREATE_TENDER: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importCreateProductTender(f);
                        break;
                    }
                    case PRODUCT_LOCATION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductLocation(f);
                        break;
                    }
                    case ARTICLE_CHARGE_PRICE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleChargePrice(f);
                        break;
                    }
                    case RECIPE_SERVICE_FLAG: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeServiceFlag(f);
                        break;
                    }
                    case PRODUCT_COMMISSION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCommission(f);
                        break;
                    }
                    case PRODUCT_DEFAULT_LABEL_COLOR: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductDefaultLabelColor(f);
                        break;
                    }
                    case HANDLING_COST_DELETE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importHandlingCostDelete(f);
                        break;
                    }
                    case SUPPLIER_CUSTOMS_RELEVANCE_FLAG: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierCustomsRelevantFlag(f);
                        break;
                    }
                    case FLIGHT_SCHEDULE_KITCHEN_READY_TIME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importFlightScheduleKitchenReadyTime(f);
                        break;
                    }
                    case ARTICLE_MIN_AND_OPTIMAL_STOCK: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleMinAndOptimalImport(f);
                        break;
                    }
                    case ARTICLE_RETURNS_RATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleReturnsRate(f);
                        break;
                    }
                    case ARTICLE_HAS_EXPIRY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleHasExpiryDate(f);
                        break;
                    }
                    case ARTICLE_SYNC_NO_PRO: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleSyncWithNoPro(f);
                        break;
                    }
                    case ARTICLE_CONTRACT_QUANTITY: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleContractQuantity(f);
                        break;
                    }
                    case ARTICLE_REPORT_PURCHASE_PDF: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleReportPurchasePDF(f);
                        break;
                    }
                    case PRODUCT_FLIGHT_CHECKER_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductFlightCheckerName(f);
                        break;
                    }
                    case PRODUCT_CREATE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductCreate(f);
                        break;
                    }
                    case PRODUCT_CLEAR_CATERING_POINTS: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductClearCateringPoints(f);
                        break;
                    }
                    case PRODUCT_USE_MASTER_DATA_FOR_GROUP_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductUseMasterDataForGroupNames(f);
                        break;
                    }
                    case PRODUCT_REPLACE_ARTICLE_BY_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductReplaceArticleByArticle(f);
                        break;
                    }
                    case PRODUCT_REPLACE_ARTICLE_BY_RECIPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductReplaceArticleByRecipe(f);
                        break;
                    }
                    case PRODUCT_REPLACE_RECIPE_BY_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductReplaceRecipeByArticle(f);
                        break;
                    }
                    case PRODUCT_REPLACE_RECIPE_BY_RECIPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importProductReplaceRecipeByRecipe(f);
                        break;
                    }
                    case RECIPE_REPLACE_ARTICLE_BY_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeReplaceArticleByArticle(f);
                        break;
                    }
                    case RECIPE_REPLACE_ARTICLE_BY_RECIPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeReplaceArticleByRecipe(f);
                        break;
                    }
                    case RECIPE_REPLACE_RECIPE_BY_ARTICLE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeReplaceRecipeByArticle(f);
                        break;
                    }
                    case RECIPE_REPLACE_RECIPE_BY_RECIPE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importRecipeReplaceRecipeByRecipe(f);
                        break;
                    }
                    case SUPPLIER_NAME: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierName(f);
                        break;
                    }
                    case SUPPLIER_INVOICE_REFERENCE: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importSupplierInvoiceReference(f);
                        break;
                    }
                    case STORE_CONFIGURATION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importStoreConfiguration(f);
                        break;
                    }
                    case ARTICLE_HALAL_CERTIFICATION: {
                        ret = ((DataImportServiceManager)ServiceManagerRegistry.getService(DataImportServiceManager.class)).importArticleHalalCertifications(f);
                        break;
                    }
                    default: {
                        String mailtext = "Import '" + LoadingInsert.this.currentType.toString() + "' not supported!";
                        ((LoggingServiceManager)ServiceManagerRegistry.getService(LoggingServiceManager.class)).sendBugMail(mailtext, mailtext, mailtext, null, null);
                        throw new InternalServerException(mailtext);
                    }
                }
                ViewNode n = new ViewNode("");
                n.setValue((Object)ret, 0L);
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        LoadingInsert.this.errorMSG = Words.SUCCESSFULLY_IMPORTED;
                        if (node.getValue() != null) {
                            LoadingInsert.this.errorMSG = LoadingInsert.this.errorMSG + "<br/> " + node.getValue();
                            LoadingInsert.this.isError = true;
                        }
                        LoadingInsert.this.removeAnimation(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        LoadingInsert.this.isError = true;
                        if (exception.getCause() != null && exception.getCause().getMessage() != null && !exception.getCause().getMessage().isEmpty()) {
                            LoadingInsert.this.errorMSG = exception.getCause().getMessage();
                        } else if (exception.getMessage() != null) {
                            LoadingInsert.this.errorMSG = Words.UNABLE_TO_IMPORT + LoadingInsert.this.currentType + "<ul>" + exception.getMessage() + "</ul>";
                        } else {
                            LoadingInsert.this.errorMSG = Words.UNABLE_TO_IMPORT + LoadingInsert.this.currentType;
                        }
                        LoadingInsert.this.removeAnimation(true);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void removeInheritedComponents() {
    }

    @Override
    public boolean tryToGrabFocus() {
        return false;
    }

    public ArrayList<Component> getFocusComponents() {
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void statusChanged(File file, FileTransferState state) {
        this.animation.stateChanged(Words.UPLOAD + state.getRemaining() + " / " + state.getSize());
    }

    @Override
    public void exceptionOccurred(Exception exception) {
        InnerPopupFactory.showErrorDialog(ScreenValidationObject.createMessageString((List)ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "File upload failed")})), (Component)this);
    }

    @Override
    public void fileUploaded(File file, PegasusFileComplete ref) {
    }

    @Override
    public void fileDownloaded(File file) {
    }

    static /* synthetic */ String access$200(LoadingInsert x0) {
        return x0.errorMSG;
    }
}

