/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateTimeChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PRPDetailsPanel
extends StateDependantDetailsPanel<IncidentLogLight> {
    private TitledItem<RDSearchTextField2<PurchaseOrderComplete>> prpOrder;
    private TitledItem<RDDateTimeChooser> prpReceiveDate;
    private TitledItem<RDSearchTextField2<BasicArticleLight>> prpArticle;
    private TitledItem<RDTextField> prpConversion;
    private TitledItem<RDTextField> prpLotNo;
    private TitledItem<RDDateChooser> prpExpiryDate;
    private TitledItem<RDTextField> prpQuantity;
    private TitledItem<RDCheckBox> prpDeliveryRejected;
    private TitledItem<RDCheckBox> prpReplacement;
    private TitledItem<RDCheckBox> prpRepeating;

    public PRPDetailsPanel(RowEditor<IncidentLogLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PRP_3);
        this.prpOrder = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.PURCHASE_ORDER), "Purchase Order", TitledItem.TitledItemOrientation.NORTH);
        this.prpReceiveDate = new TitledItem<RDDateTimeChooser>(new RDDateTimeChooser(provider), "Receiving Date", TitledItem.TitledItemOrientation.NORTH);
        this.prpArticle = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.ARTICLE), "Article", TitledItem.TitledItemOrientation.NORTH);
        this.prpConversion = new TitledItem<RDTextField>(new RDTextField(provider), "Conversion", TitledItem.TitledItemOrientation.NORTH);
        this.prpLotNo = new TitledItem<RDTextField>(new RDTextField(provider), "Lot Number", TitledItem.TitledItemOrientation.NORTH);
        this.prpExpiryDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), "Expiry Date", TitledItem.TitledItemOrientation.NORTH);
        this.prpQuantity = new TitledItem<RDTextField>(new RDTextField(provider), "Quantity", TitledItem.TitledItemOrientation.NORTH);
        this.prpDeliveryRejected = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Delivery Rejected", TitledItem.TitledItemOrientation.EAST);
        this.prpReplacement = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Replacement", TitledItem.TitledItemOrientation.EAST);
        this.prpRepeating = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Repeating", TitledItem.TitledItemOrientation.EAST);
        this.prpOrder.getElement().addSearchTextFieldListener((source, n) -> {
            PurchaseOrderLight purchase = (PurchaseOrderLight)n.getValue();
            if (purchase != null) {
                Timestamp firstReceived = purchase.getFirstReceived();
                if (firstReceived == null) {
                    firstReceived = new Timestamp(purchase.getDeliveryDate().getTime());
                }
                this.prpReceiveDate.getElement().getNode().setValue((Object)new Timestamp(firstReceived.getTime()), 0L);
            }
            this.setEnabled(this.isEnabled());
        });
        this.prpReceiveDate.getElement().addDateChooserListener((source, timestamp) -> this.updateSearchConfig());
        this.prpArticle.getElement().addSearchTextFieldListener((source, n) -> this.updateArticle(true));
        this.setCustomLayouter(new Layout());
        this.addToView(this.prpOrder);
        this.addToView(this.prpReceiveDate);
        this.addToView(this.prpArticle);
        this.addToView(this.prpConversion);
        this.addToView(this.prpLotNo);
        this.addToView(this.prpExpiryDate);
        this.addToView(this.prpQuantity);
        this.addToView(this.prpDeliveryRejected);
        this.addToView(this.prpReplacement);
        this.addToView(this.prpRepeating);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        IncidentTypeE incidentTypeE = (IncidentTypeE)this.node.getChildNamed(IncidentLogComplete_.type).getValue();
        if (incidentTypeE == IncidentTypeE.SUPPLIER && this.node.getChildNamed(IncidentLogComplete_.prpArticle).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "PRP-3: Select Article"));
            this.prpArticle.getElement().setInvalid();
        }
        return validationObjects;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.prpOrder.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpOrder));
        this.prpReceiveDate.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpReceiveDate));
        this.prpArticle.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpArticle));
        this.prpConversion.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpConversion));
        this.prpLotNo.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpLotNo));
        this.prpExpiryDate.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpExpiryDate));
        this.prpQuantity.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpQuantityString));
        this.prpDeliveryRejected.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpDeliveryRejected));
        this.prpReplacement.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpReplacement));
        this.prpRepeating.getElement().setNode(node.getChildNamed(IncidentLogComplete_.prpRepeating));
        this.updateSearchConfig();
        this.updateArticle(false);
    }

    private void updateSearchConfig() {
        Timestamp receiveDate = (Timestamp)this.editor.getModel().getNode().getChildNamed(IncidentLogComplete_.prpReceiveDate).getValue();
        SearchTextField2 searchComp = (SearchTextField2)this.prpOrder.getElement().getEditor();
        if (searchComp != null) {
            Object[] additional = new Object[]{null, receiveDate};
            searchComp.setAdditionalSearchField(additional);
        }
    }

    private void updateArticle(boolean newSelected) {
        if (newSelected) {
            BasicArticleLight article = (BasicArticleLight)this.editor.getModel().getNode().getChildNamed(IncidentLogComplete_.prpArticle).getValue();
            PurchaseOrderLight order = (PurchaseOrderLight)this.editor.getModel().getNode().getChildNamed(IncidentLogComplete_.prpOrder).getValue();
            String conversion = "";
            if (article != null && order != null) {
                conversion = PRPDetailsPanel.formatArticleConversion(article, new Timestamp(order.getOrderDate().getTime()));
            }
            this.editor.getModel().getNode().getChildNamed(IncidentLogComplete_.prpConversion).setValue((Object)conversion, 0L);
        }
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean editable = false;
        IncidentStateE currentState = (IncidentStateE)this.getEditor().getModel().getNode().getChildNamed(IncidentLogComplete_.state).getValue();
        if (currentState == IncidentStateE.CLOSED) {
            if (isSupervisor) {
                editable = true;
            }
        } else {
            editable = true;
        }
        boolean e = isEnabled && editable;
        super.setEnabled(e);
        boolean purchaseSet = false;
        boolean articleSet = false;
        if (this.node != null) {
            boolean bl = purchaseSet = this.node.getChildNamed(IncidentLogComplete_.prpOrder).getValue() != null;
        }
        if (purchaseSet) {
            articleSet = this.node.getChildNamed(IncidentLogComplete_.prpArticle).getValue() != null;
        }
        this.prpOrder.setEnabled(e);
        this.prpReceiveDate.setEnabled(e);
        this.prpArticle.setEnabled(e);
        this.prpConversion.setEnabled(e && articleSet);
        this.prpLotNo.setEnabled(e && articleSet);
        this.prpExpiryDate.setEnabled(e && articleSet);
        this.prpQuantity.setEnabled(e && articleSet);
        this.prpDeliveryRejected.setEnabled(e);
        this.prpReplacement.setEnabled(e);
        this.prpRepeating.setEnabled(e);
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.prpOrder);
        CheckedListAdder.addToList(focusList, this.prpReceiveDate);
        CheckedListAdder.addToList(focusList, this.prpArticle);
        CheckedListAdder.addToList(focusList, this.prpConversion);
        CheckedListAdder.addToList(focusList, this.prpLotNo);
        CheckedListAdder.addToList(focusList, this.prpExpiryDate);
        CheckedListAdder.addToList(focusList, this.prpQuantity);
        CheckedListAdder.addToList(focusList, this.prpDeliveryRejected);
        CheckedListAdder.addToList(focusList, this.prpReplacement);
        CheckedListAdder.addToList(focusList, this.prpRepeating);
        return focusList;
    }

    private static String formatArticleConversion(BasicArticleLight a, Timestamp dueDate) {
        String retString = "";
        double amount = 1.0;
        if (a == null) {
            return "Article are null!";
        }
        if (dueDate == null) {
            return "No due date set";
        }
        List conversion = a.getPackingQuantitiesVariant(dueDate).getConversion();
        Collections.sort(conversion);
        for (PackagingQuantityComplete q : conversion) {
            QuantityComplete currentAmount = new QuantityComplete(Double.valueOf(amount *= (double)q.getAmount().intValue()), q.getUnit());
            String fr = UnitConversionToolkit.formatDouble((double)currentAmount.getAmount(), (String)"#.##");
            retString = retString + fr + " " + currentAmount.getUnit().getShortName() + " = ";
        }
        if (retString.length() > 3) {
            retString = retString.substring(0, retString.length() - 3);
        }
        return retString;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PRPDetailsPanel.this.verticalBorder;
            h = (int)((double)h + (PRPDetailsPanel.this.prpOrder.getPreferredSize().getHeight() + (double)PRPDetailsPanel.this.verticalBorder));
            h = (int)((double)h + (PRPDetailsPanel.this.prpConversion.getPreferredSize().getHeight() + (double)PRPDetailsPanel.this.verticalBorder));
            h = (int)((double)h + (PRPDetailsPanel.this.prpDeliveryRejected.getPreferredSize().getHeight() + (double)PRPDetailsPanel.this.verticalBorder));
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            PRPDetailsPanel.this.prpOrder.setLocation(PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpOrder.setSize(200, (int)PRPDetailsPanel.this.prpOrder.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpReceiveDate.setLocation(PRPDetailsPanel.this.prpOrder.getX() + PRPDetailsPanel.this.prpOrder.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpReceiveDate.setSize(PRPDetailsPanel.this.prpReceiveDate.getPreferredSize());
            PRPDetailsPanel.this.prpArticle.setLocation(PRPDetailsPanel.this.prpReceiveDate.getX() + PRPDetailsPanel.this.prpReceiveDate.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpArticle.setSize(200, (int)PRPDetailsPanel.this.prpArticle.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpConversion.setLocation(PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpOrder.getY() + PRPDetailsPanel.this.prpOrder.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpConversion.setSize(200, (int)PRPDetailsPanel.this.prpConversion.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpLotNo.setLocation(PRPDetailsPanel.this.prpConversion.getX() + PRPDetailsPanel.this.prpConversion.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpOrder.getY() + PRPDetailsPanel.this.prpOrder.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpLotNo.setSize(200, (int)PRPDetailsPanel.this.prpLotNo.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpExpiryDate.setLocation(PRPDetailsPanel.this.prpLotNo.getX() + PRPDetailsPanel.this.prpLotNo.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpOrder.getY() + PRPDetailsPanel.this.prpOrder.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpExpiryDate.setSize(PRPDetailsPanel.this.prpExpiryDate.getPreferredSize());
            PRPDetailsPanel.this.prpQuantity.setLocation(PRPDetailsPanel.this.prpExpiryDate.getX() + PRPDetailsPanel.this.prpExpiryDate.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpOrder.getY() + PRPDetailsPanel.this.prpOrder.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpQuantity.setSize(150, (int)PRPDetailsPanel.this.prpQuantity.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpDeliveryRejected.setLocation(PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpConversion.getY() + PRPDetailsPanel.this.prpConversion.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpDeliveryRejected.setSize(200, (int)PRPDetailsPanel.this.prpDeliveryRejected.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpReplacement.setLocation(PRPDetailsPanel.this.prpDeliveryRejected.getX() + PRPDetailsPanel.this.prpDeliveryRejected.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpConversion.getY() + PRPDetailsPanel.this.prpConversion.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpReplacement.setSize(200, (int)PRPDetailsPanel.this.prpReplacement.getPreferredSize().getHeight());
            PRPDetailsPanel.this.prpRepeating.setLocation(PRPDetailsPanel.this.prpReplacement.getX() + PRPDetailsPanel.this.prpReplacement.getWidth() + PRPDetailsPanel.this.horizontalBorder, PRPDetailsPanel.this.prpConversion.getY() + PRPDetailsPanel.this.prpConversion.getHeight() + PRPDetailsPanel.this.verticalBorder);
            PRPDetailsPanel.this.prpRepeating.setSize(200, (int)PRPDetailsPanel.this.prpRepeating.getPreferredSize().getHeight());
        }
    }
}

