/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRemarkComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.List;

public class InventoryArticleCountedAmountChangingPopup
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private final Node<ArticleChargeLight> articleCharge;
    private final Node<StoreQuantityComplete> oldAmountNode;
    private final Node<StoreQuantityComplete> newAmountNode;
    private TitledItem<QuantityRenderer> oldAmount;
    private TitledItem<InputComboBox2> newAmount;
    private TitledItem<CheckBox> changeStock;
    private StockTransactionRemarkButton remarkButton;
    private Node articleNode;
    private LoadingAnimation animation;
    private StoreLight store;
    private boolean isAnimating = false;

    public InventoryArticleCountedAmountChangingPopup(Node<ArticleChargeLight> articleCharge, Node<StoreQuantityComplete> newAmount, Node<StoreQuantityComplete> oldAmount, Node<Boolean> changeStock, Node remarkNode, Node<BasicArticleLight> artNode, StoreLight store) {
        this.articleCharge = articleCharge;
        this.store = store;
        this.articleNode = artNode;
        this.oldAmountNode = oldAmount;
        this.newAmountNode = newAmount;
        this.oldAmount = new TitledItem<QuantityRenderer>(new QuantityRenderer(oldAmount), Words.OLD_COUNTED_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        this.newAmount = new TitledItem<InputComboBox2>(new InputComboBox2(newAmount.getChildNamed(StoreQuantityComplete_.amount), newAmount.getChildNamed(StoreQuantityComplete_.unit), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.NEW_COUNTED_AMOUNT, TitledItem.TitledItemOrientation.NORTH);
        changeStock.setValue((Object)true, 0L);
        this.changeStock = new TitledItem<CheckBox>(new CheckBox(changeStock), Words.CHANGE_ACTUAL_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.remarkButton = new StockTransactionRemarkButton<InventoryRemarkComplete>(remarkNode, InventoryRemarkComplete.class);
        this.setLayout(new Layout());
        this.add(this.oldAmount);
        this.add(this.newAmount);
        this.add(this.changeStock);
        this.add(this.remarkButton);
        if (artNode.getValue(BasicArticleComplete.class) != null) {
            this.remoteObjectLoaded(this.articleNode);
        } else {
            new BasicArticleLoader((BasicArticleReference)((BasicArticleLight)this.articleNode.getValue(BasicArticleLight.class)), this, this.articleNode, this);
            this.ensureAnimation();
        }
    }

    private void ensureAnimation() {
        this.isAnimating = true;
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.LOAD_ARTICLE);
            this.add(this.animation);
            this.animation.fadeIn();
            this.animation.start();
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.oldAmount.setEnabled(isEnabled);
        this.newAmount.setEnabled(isEnabled);
        this.changeStock.setEnabled(false);
        this.remarkButton.setEnabled(isEnabled);
    }

    private void killAnimation() {
        this.isAnimating = false;
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = this.newAmount.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.remarkButton);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[1];
        this.newAmount.getElement().getValueNode().commit();
        this.newAmount.getElement().getUnitNode().commit();
        o[0] = this.newAmount.getElement().getValueNode();
        return o;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.oldAmount.kill();
        this.newAmount.kill();
        this.changeStock.kill();
        this.remarkButton.kill();
        this.oldAmount = null;
        this.newAmount = null;
        this.changeStock = null;
        this.remarkButton = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.killAnimation();
        BasicArticleComplete artC = (BasicArticleComplete)this.articleNode.getValue(BasicArticleComplete.class);
        ArticleChargeLight charge = (ArticleChargeLight)this.articleCharge.getValue(ArticleChargeLight.class);
        if (this.newAmount != null && this.newAmount.getElement() != null) {
            UserComplete currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            List units = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)charge.getCreationDate(), (TransactionType)TransactionType.INVENTORY, (UserComplete)currentUser, (StoreLight)this.store, (StoreLight)this.store, (SystemSettingsComplete)settings);
            this.newAmount.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(units));
            if (units.isEmpty()) {
                this.newAmount.getElement().clearSelectedUnit();
            } else if (units.contains(((StoreQuantityComplete)this.newAmountNode.getValue()).getUnit())) {
                this.newAmount.getElement().setSelectedUnit(((StoreQuantityComplete)this.newAmountNode.getValue()).getUnit());
            } else {
                this.newAmount.getElement().setSelectedUnit((UnitComplete)units.get(0));
            }
        }
        this.setEnabled(this.isEnabled());
        this.invalidate();
        this.validate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (InventoryArticleCountedAmountChangingPopup.this.isAnimating) {
                InventoryArticleCountedAmountChangingPopup.this.animation.setLocation((int)((double)parent.getWidth() - InventoryArticleCountedAmountChangingPopup.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - InventoryArticleCountedAmountChangingPopup.this.animation.getPreferredSize().getHeight()) / 2);
                InventoryArticleCountedAmountChangingPopup.this.animation.setSize(InventoryArticleCountedAmountChangingPopup.this.animation.getPreferredSize());
            } else {
                InventoryArticleCountedAmountChangingPopup.this.oldAmount.setLocation(0, 0);
                InventoryArticleCountedAmountChangingPopup.this.oldAmount.setSize((int)InventoryArticleCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getWidth(), (int)InventoryArticleCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight());
                InventoryArticleCountedAmountChangingPopup.this.newAmount.setLocation(0, InventoryArticleCountedAmountChangingPopup.this.oldAmount.getY() + InventoryArticleCountedAmountChangingPopup.this.oldAmount.getHeight() + 10);
                InventoryArticleCountedAmountChangingPopup.this.newAmount.setSize((int)InventoryArticleCountedAmountChangingPopup.this.newAmount.getPreferredSize().getWidth(), (int)InventoryArticleCountedAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
                InventoryArticleCountedAmountChangingPopup.this.remarkButton.setLocation(InventoryArticleCountedAmountChangingPopup.this.newAmount.getX() + InventoryArticleCountedAmountChangingPopup.this.newAmount.getWidth() + 5, (int)((double)(InventoryArticleCountedAmountChangingPopup.this.newAmount.getY() + InventoryArticleCountedAmountChangingPopup.this.newAmount.getHeight()) - InventoryArticleCountedAmountChangingPopup.this.remarkButton.getPreferredSize().getHeight() - 4.0));
                InventoryArticleCountedAmountChangingPopup.this.remarkButton.setSize(InventoryArticleCountedAmountChangingPopup.this.remarkButton.getPreferredSize());
                InventoryArticleCountedAmountChangingPopup.this.changeStock.setLocation(0, InventoryArticleCountedAmountChangingPopup.this.newAmount.getY() + InventoryArticleCountedAmountChangingPopup.this.newAmount.getHeight() + 10);
                InventoryArticleCountedAmountChangingPopup.this.changeStock.setSize(InventoryArticleCountedAmountChangingPopup.this.changeStock.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = (int)InventoryArticleCountedAmountChangingPopup.this.oldAmount.getPreferredSize().getHeight();
            h += 10;
            h = (int)((double)h + InventoryArticleCountedAmountChangingPopup.this.newAmount.getPreferredSize().getHeight());
            h += 10;
            h = (int)((double)h + InventoryArticleCountedAmountChangingPopup.this.changeStock.getPreferredSize().getHeight());
            return new Dimension(0, h += 10);
        }
    }
}

