/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details.utils;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryStoreComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StockReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;

public class PrintAllWorksheetsPopup
extends DefaultScrollablePrintPopup2<InventoryLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<InventoryLight> currentInventory;
    private Node<StockReportConfiguration> configNode;
    private TitledItem<ComboBox> bondedState;
    private TitledItem<CheckBox> includeCustomer;
    private TitledItem<ComboBox> sortBy;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearchField;
    private TitledItem<CheckBox> includeAmountColumn;
    private TitledItem<CheckBox> includeZeroStock;
    private TitledItem<CheckBox> includeConversion;
    private TitledItem<CheckBox> saveToDisk;
    private File selectedTarget;

    public PrintAllWorksheetsPopup(Node<InventoryLight> node) {
        super(false, true, ReportTypeE.INVENTORY_WORKSHEETS);
        this.currentInventory = node;
        StockReportConfiguration config = new StockReportConfiguration();
        config.setFormat(ReportingOutputFormatE.PDF);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.includeCustomer = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_CUSTOMER_DATA, TitledItem.TitledItemOrientation.EAST);
        this.customerSearchField = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.includeAmountColumn = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_AMOUNT_COLUMN, TitledItem.TitledItemOrientation.EAST);
        this.includeZeroStock = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ZERO_STOCK_ITEMS, TitledItem.TitledItemOrientation.EAST);
        this.includeConversion = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ARTICLE_CONVERSION, TitledItem.TitledItemOrientation.EAST);
        this.saveToDisk = new TitledItem<CheckBox>(new CheckBox(), Words.SAVE_TO_DISK, TitledItem.TitledItemOrientation.EAST);
        this.bondedState = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.bondedState.getElement().addItem(BondedStateE.ALL);
        this.bondedState.getElement().addItem(BondedStateE.NOT_BONDED);
        this.bondedState.getElement().addItem(BondedStateE.ONLY_BONDED);
        this.sortBy = new TitledItem<ComboBox>(new ComboBox(), Words.SORT_BY, TitledItem.TitledItemOrientation.NORTH);
        this.sortBy.getElement().addItem(Words.CUSTOMER_ARTICLE_NUMBER);
        this.sortBy.getElement().addItem(Words.ARTICLE_NUMBER);
        this.sortBy.getElement().addItem(Words.ARTICLE_NAME);
        this.getViewContainer().add(this.includeConversion);
        this.getViewContainer().add(this.includeZeroStock);
        this.getViewContainer().add(this.includeAmountColumn);
        this.getViewContainer().add(this.customerSearchField);
        this.getViewContainer().add(this.includeCustomer);
        this.getViewContainer().add(this.bondedState);
        this.getViewContainer().add(this.sortBy);
        this.getViewContainer().add(this.saveToDisk);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if ((isOK == PopupAction.PREVIEW || isOK == PopupAction.OK_FOREGROUND) && this.saveToDisk.getElement().isChecked()) {
            this.selectedTarget = FileChooserUtil.saveFileToFolder();
            if (this.selectedTarget != null) {
                if (!this.selectedTarget.isDirectory()) {
                    this.selectedTarget = this.selectedTarget.getParentFile();
                }
            } else {
                return;
            }
        }
        super.enterPressed(isOK);
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInventory.getChildNamed(InventoryLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInventory.getChildNamed(InventoryLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.bondedState != null) {
            this.bondedState.kill();
        }
        if (this.sortBy != null) {
            this.sortBy.kill();
        }
        if (this.includeCustomer != null) {
            this.includeCustomer.kill();
        }
        this.includeCustomer = null;
        if (this.customerSearchField != null) {
            this.customerSearchField.kill();
        }
        this.customerSearchField = null;
        if (this.includeAmountColumn != null) {
            this.includeAmountColumn.kill();
        }
        this.includeAmountColumn = null;
        if (this.includeConversion != null) {
            this.includeConversion.kill();
        }
        this.includeConversion = null;
        if (this.includeZeroStock != null) {
            this.includeZeroStock.kill();
        }
        if (this.saveToDisk != null) {
            this.saveToDisk.kill();
        }
        this.saveToDisk = null;
        this.includeZeroStock = null;
        this.sortBy = null;
        this.bondedState = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.bondedState.setVisible(true);
        this.sortBy.setVisible(true);
        this.includeCustomer.setVisible(true);
        this.customerSearchField.setVisible(true);
        this.includeAmountColumn.setVisible(true);
        this.includeZeroStock.setVisible(true);
        this.includeConversion.setVisible(true);
        this.saveToDisk.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.bondedState.setVisible(false);
        this.sortBy.setVisible(false);
        this.includeCustomer.setVisible(false);
        this.customerSearchField.setVisible(false);
        this.includeAmountColumn.setVisible(false);
        this.includeZeroStock.setVisible(false);
        this.includeConversion.setVisible(false);
        this.saveToDisk.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintAllWorksheetsPopup.this.getSelectedReport();
                PrintAllWorksheetsPopup.this.configNode.commit();
                InventoryComplete invComp = PrintAllWorksheetsPopup.this.currentInventory.getValue(InventoryComplete.class) != null ? (InventoryComplete)PrintAllWorksheetsPopup.this.currentInventory.getValue(InventoryComplete.class) : (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(new InventoryReference(((InventoryLight)PrintAllWorksheetsPopup.this.currentInventory.getValue()).getId())).getValue();
                StockReportConfiguration config = (StockReportConfiguration)PrintAllWorksheetsPopup.this.configNode.getValue();
                config.setTitle2(Words.INVENTORY_WORK_SHEET);
                config.setPrintAllStores(Boolean.valueOf(true));
                config.setStylesheet(file);
                config.setSortByCustomerNumber(Boolean.valueOf(((ComboBox)PrintAllWorksheetsPopup.this.sortBy.getElement()).getSelectedItem().equals(Words.CUSTOMER_ARTICLE_NUMBER)));
                config.setSortByArticleNumber(Boolean.valueOf(((ComboBox)PrintAllWorksheetsPopup.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NUMBER)));
                config.setSortByArticleName(Boolean.valueOf(((ComboBox)PrintAllWorksheetsPopup.this.sortBy.getElement()).getSelectedItem().equals(Words.ARTICLE_NAME)));
                config.setCustomer((CustomerReference)((SearchTextField2)PrintAllWorksheetsPopup.this.customerSearchField.getElement()).getNode().getValue());
                config.setIncludeCustomerData(Boolean.valueOf(((CheckBox)PrintAllWorksheetsPopup.this.includeCustomer.getElement()).isChecked()));
                config.setIncludeAmount(Boolean.valueOf(((CheckBox)PrintAllWorksheetsPopup.this.includeAmountColumn.getElement()).isChecked()));
                config.setIncludeZeroStockItems(Boolean.valueOf(((CheckBox)PrintAllWorksheetsPopup.this.includeZeroStock.getElement()).isChecked()));
                config.setIncludeArticleConversion(Boolean.valueOf(((CheckBox)PrintAllWorksheetsPopup.this.includeConversion.getElement()).isChecked()));
                config.setBonded((BondedStateE)((ComboBox)PrintAllWorksheetsPopup.this.bondedState.getElement()).getSelectedItem());
                boolean xlsExport = false;
                if (PrintAllWorksheetsPopup.this.asXLS != null && ((RadioButton)PrintAllWorksheetsPopup.this.asXLS.getElement()).isChecked()) {
                    xlsExport = true;
                }
                if (xlsExport) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                if (((CheckBox)PrintAllWorksheetsPopup.this.saveToDisk.getElement()).isChecked()) {
                    for (InventoryStoreComplete store : invComp.getStores()) {
                        config.getIncludedStores().clear();
                        StoreLight storeLight = (StoreLight)store.getStore();
                        String fileName = storeLight.getName() + "." + (xlsExport ? "xlsx" : "pdf");
                        config.getIncludedStores().add(new StoreReference(store.getStore().getId()));
                        PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createInventoryWorkSheet(config).getValue();
                        PrintPopupToolkit.downloadFileToFolder(t, PrintAllWorksheetsPopup.this.selectedTarget, fileName);
                    }
                } else {
                    for (InventoryStoreComplete store : invComp.getStores()) {
                        config.getIncludedStores().add(new StoreReference(store.getStore().getId()));
                    }
                    PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createInventoryWorkSheet(config).getValue();
                    PrintAllWorksheetsPopup.this.processFile(t);
                }
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintAllWorksheetsPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return this.currentInventory;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintAllWorksheetsPopup.this.layoutInheritedComponents(parent);
            if (PrintAllWorksheetsPopup.this.bondedState != null) {
                PrintAllWorksheetsPopup.this.bondedState.setLocation(PrintAllWorksheetsPopup.this.border, y + PrintAllWorksheetsPopup.this.border);
                PrintAllWorksheetsPopup.this.bondedState.setSize(120, (int)PrintAllWorksheetsPopup.this.bondedState.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.bondedState.getY() + PrintAllWorksheetsPopup.this.bondedState.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeCustomer != null) {
                PrintAllWorksheetsPopup.this.includeCustomer.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.includeCustomer.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.includeCustomer.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.includeCustomer.getY() + PrintAllWorksheetsPopup.this.includeCustomer.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.sortBy != null) {
                PrintAllWorksheetsPopup.this.sortBy.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.sortBy.setSize(120, (int)PrintAllWorksheetsPopup.this.sortBy.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.sortBy.getY() + PrintAllWorksheetsPopup.this.sortBy.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.customerSearchField != null) {
                PrintAllWorksheetsPopup.this.customerSearchField.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.customerSearchField.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.customerSearchField.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.customerSearchField.getY() + PrintAllWorksheetsPopup.this.customerSearchField.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeAmountColumn != null) {
                PrintAllWorksheetsPopup.this.includeAmountColumn.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.includeAmountColumn.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.includeAmountColumn.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.includeAmountColumn.getY() + PrintAllWorksheetsPopup.this.includeAmountColumn.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeZeroStock != null) {
                PrintAllWorksheetsPopup.this.includeZeroStock.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.includeZeroStock.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.includeZeroStock.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.includeZeroStock.getY() + PrintAllWorksheetsPopup.this.includeZeroStock.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeConversion != null) {
                PrintAllWorksheetsPopup.this.includeConversion.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.includeConversion.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.includeConversion.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.includeConversion.getY() + PrintAllWorksheetsPopup.this.includeConversion.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.saveToDisk != null) {
                PrintAllWorksheetsPopup.this.saveToDisk.setLocation(PrintAllWorksheetsPopup.this.border, y);
                PrintAllWorksheetsPopup.this.saveToDisk.setSize(parent.getWidth() - 2 * PrintAllWorksheetsPopup.this.border, (int)PrintAllWorksheetsPopup.this.saveToDisk.getPreferredSize().getHeight());
                y = PrintAllWorksheetsPopup.this.saveToDisk.getY() + PrintAllWorksheetsPopup.this.saveToDisk.getHeight() + PrintAllWorksheetsPopup.this.border;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintAllWorksheetsPopup.this.getInheritedComponentsHeight();
            h += PrintAllWorksheetsPopup.this.border;
            if (PrintAllWorksheetsPopup.this.animation != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(PrintAllWorksheetsPopup.this.border * 2) + PrintAllWorksheetsPopup.this.animation.getPreferredSize().getWidth()), h += PrintAllWorksheetsPopup.this.border);
            }
            if (PrintAllWorksheetsPopup.this.bondedState != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.bondedState.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeCustomer != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.includeCustomer.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.sortBy != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.sortBy.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.customerSearchField != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.customerSearchField.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeAmountColumn != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.includeAmountColumn.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeZeroStock != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.includeZeroStock.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.includeConversion != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.includeConversion.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            if (PrintAllWorksheetsPopup.this.saveToDisk != null) {
                h = (int)((double)h + PrintAllWorksheetsPopup.this.saveToDisk.getPreferredSize().getHeight());
                h += PrintAllWorksheetsPopup.this.border;
            }
            return new Dimension(0, h);
        }
    }
}

