/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.creator.details.utils;

import ch.icit.pegasus.client.converter.InvoiceHintConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.InvoiceHintComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InvoiceConfigPopup
extends PopUpInsert {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TitledItem<DateChooser> invoiceDate;
    private VerticalSeparator sep1;
    private TitledItem<DateChooser> invoiceStartDate;
    private ArrowConnectorIcon connector;
    private TitledItem<DateChooser> invoiceEndDate;
    private TitledItem<ComboBox> hint;
    private TitledItem<TextField> invoiceDescription;
    private TitledItem<ScrollableTextArea> paymentRemark;
    private TitledItem<MultiLocationComboBox> location;
    private TitledItem<CheckBox> excludeVAT;
    private SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
    private SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();

    public InvoiceConfigPopup(Node<InvoiceComplete> currentInvoice) {
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.invoiceDate = new TitledItem<DateChooser>(new DateChooser(currentInvoice.getChildNamed(InvoiceLight_.invoiceDate)), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.sep1 = new VerticalSeparator();
        this.invoiceStartDate = new TitledItem<DateChooser>(new DateChooser(currentInvoice.getChildNamed(new DtoField[]{InvoiceLight_.period, PeriodComplete_.startDate})), Words.PERIOD_START, TitledItem.TitledItemOrientation.NORTH);
        this.invoiceEndDate = new TitledItem<DateChooser>(new DateChooser(currentInvoice.getChildNamed(new DtoField[]{InvoiceLight_.period, PeriodComplete_.endDate})), Words.PERIOD_END, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isSolarCompany) {
            this.hint = new TitledItem<ComboBox>(new ComboBox(currentInvoice.getChildNamed(InvoiceComplete_.hint), NodeToolkit.getAffixList(InvoiceHintComplete.class), ConverterRegistry.getConverter(InvoiceHintConverter.class), true), Words.HINT, TitledItem.TitledItemOrientation.NORTH);
            this.excludeVAT = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)currentInvoice.getChildNamed(InvoiceComplete_.excludeVAT)), Words.EXCLUDE_VAT, TitledItem.TitledItemOrientation.EAST);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.location = new TitledItem<MultiLocationComboBox>(new MultiLocationComboBox(currentInvoice.getChildNamed(InvoiceLight_.eligibleLocations)), Words.LOCATION, TitledItem.TitledItemOrientation.NORTH);
            }
        }
        this.invoiceDescription = new TitledItem<TextField>(new TextField(currentInvoice.getChildNamed(InvoiceLight_.description)), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        this.paymentRemark = new TitledItem<ScrollableTextArea>(new ScrollableTextArea((Node<String>)currentInvoice.getChildNamed(InvoiceLight_.paymentRemark)), Words.PAYMENT_REMARK, TitledItem.TitledItemOrientation.NORTH);
        this.paymentRemark.setIgnorePrefHeight(true);
        this.connector = new ArrowConnectorIcon(3);
        this.setLayout(new Layout());
        this.add(this.invoiceDate);
        this.add(this.sep1);
        this.add(this.invoiceDescription);
        this.add(this.invoiceStartDate);
        this.add(this.connector);
        this.add(this.invoiceEndDate);
        this.add(this.paymentRemark);
        if (!this.isSolarCompany) {
            this.add(this.hint);
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.add(this.location);
            }
            this.add(this.excludeVAT);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.invoiceDate.kill();
        this.sep1.kill();
        this.invoiceEndDate.kill();
        this.invoiceDescription.kill();
        this.connector.kill();
        this.invoiceStartDate.kill();
        this.paymentRemark.kill();
        if (!this.isSolarCompany) {
            if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
                this.location.kill();
            }
            this.excludeVAT.kill();
            this.hint.kill();
        }
        this.hint = null;
        this.invoiceDate = null;
        this.sep1 = null;
        this.invoiceStartDate = null;
        this.connector = null;
        this.invoiceEndDate = null;
        this.invoiceDescription = null;
        this.paymentRemark = null;
        this.location = null;
        this.excludeVAT = null;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.invoiceDate);
        CheckedListAdder.addToList(focusComponents, this.invoiceStartDate);
        CheckedListAdder.addToList(focusComponents, this.invoiceEndDate);
        CheckedListAdder.addToList(focusComponents, this.location);
        CheckedListAdder.addToList(focusComponents, this.hint);
        CheckedListAdder.addToList(focusComponents, this.invoiceDescription);
        CheckedListAdder.addToList(focusComponents, this.paymentRemark);
        CheckedListAdder.addToList(focusComponents, this.excludeVAT);
        return focusComponents;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean validateContent() {
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && !this.isSolarCompany && this.location.getElement().getNode().getChildCount() != 1) {
            this.location.getElement().setInvalid();
            return false;
        }
        return true;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            h = (int)((double)h + InvoiceConfigPopup.this.invoiceDate.getPreferredSize().getHeight());
            h += border;
            if (!InvoiceConfigPopup.this.isSolarCompany) {
                if (Boolean.TRUE.equals(InvoiceConfigPopup.this.viewSettings.getShowLocation())) {
                    h = (int)((double)h + InvoiceConfigPopup.this.location.getPreferredSize().getHeight());
                    h += border;
                }
                h = (int)((double)h + InvoiceConfigPopup.this.hint.getPreferredSize().getHeight());
                h += border;
            }
            h = (int)((double)h + InvoiceConfigPopup.this.invoiceDescription.getPreferredSize().getHeight());
            h += border;
            if (!InvoiceConfigPopup.this.isSolarCompany) {
                h = (int)((double)h + InvoiceConfigPopup.this.excludeVAT.getPreferredSize().getHeight());
                h += border;
            }
            h += 150;
            return new Dimension(0, h += border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            InvoiceConfigPopup.this.invoiceDate.setLocation(border, border);
            InvoiceConfigPopup.this.invoiceDate.setSize(InvoiceConfigPopup.this.invoiceDate.getPreferredSize());
            InvoiceConfigPopup.this.sep1.setLocation(InvoiceConfigPopup.this.invoiceDate.getX() + InvoiceConfigPopup.this.invoiceDate.getWidth() + border, border);
            InvoiceConfigPopup.this.sep1.setSize((int)InvoiceConfigPopup.this.sep1.getPreferredSize().getWidth(), InvoiceConfigPopup.this.invoiceDate.getHeight());
            InvoiceConfigPopup.this.invoiceStartDate.setLocation(InvoiceConfigPopup.this.sep1.getX() + InvoiceConfigPopup.this.sep1.getWidth() + border, border);
            InvoiceConfigPopup.this.invoiceStartDate.setSize(InvoiceConfigPopup.this.invoiceStartDate.getPreferredSize());
            InvoiceConfigPopup.this.connector.setLocation(InvoiceConfigPopup.this.invoiceStartDate.getX() + InvoiceConfigPopup.this.invoiceStartDate.getWidth() + 3, (int)((double)(border + InvoiceConfigPopup.this.invoiceStartDate.getHeight()) - InvoiceConfigPopup.this.connector.getPreferredSize().getHeight()));
            InvoiceConfigPopup.this.connector.setSize(InvoiceConfigPopup.this.connector.getPreferredSize());
            InvoiceConfigPopup.this.invoiceEndDate.setLocation(InvoiceConfigPopup.this.connector.getX() + InvoiceConfigPopup.this.connector.getWidth() + 3, border);
            InvoiceConfigPopup.this.invoiceEndDate.setSize(InvoiceConfigPopup.this.invoiceEndDate.getPreferredSize());
            int cy = InvoiceConfigPopup.this.invoiceEndDate.getY() + InvoiceConfigPopup.this.invoiceEndDate.getHeight();
            if (!InvoiceConfigPopup.this.isSolarCompany) {
                if (Boolean.TRUE.equals(InvoiceConfigPopup.this.viewSettings.getShowLocation())) {
                    InvoiceConfigPopup.this.location.setLocation(border, cy + border);
                    InvoiceConfigPopup.this.location.setSize(parent.getWidth() - 2 * border, (int)InvoiceConfigPopup.this.location.getPreferredSize().getHeight());
                    cy = InvoiceConfigPopup.this.location.getY() + InvoiceConfigPopup.this.location.getHeight();
                }
                InvoiceConfigPopup.this.excludeVAT.setLocation(border, cy + border);
                InvoiceConfigPopup.this.excludeVAT.setSize(InvoiceConfigPopup.this.excludeVAT.getPreferredSize());
                InvoiceConfigPopup.this.hint.setLocation(border, InvoiceConfigPopup.this.excludeVAT.getY() + InvoiceConfigPopup.this.excludeVAT.getHeight() + border);
                InvoiceConfigPopup.this.hint.setSize(parent.getWidth() - 2 * border, (int)InvoiceConfigPopup.this.hint.getPreferredSize().getHeight());
                cy = InvoiceConfigPopup.this.hint.getY() + InvoiceConfigPopup.this.hint.getHeight();
            }
            InvoiceConfigPopup.this.invoiceDescription.setLocation(border, cy + border);
            InvoiceConfigPopup.this.invoiceDescription.setSize(parent.getWidth() - 2 * border, (int)InvoiceConfigPopup.this.invoiceDescription.getPreferredSize().getHeight());
            InvoiceConfigPopup.this.paymentRemark.setLocation(border, InvoiceConfigPopup.this.invoiceDescription.getY() + InvoiceConfigPopup.this.invoiceDescription.getHeight() + border);
            InvoiceConfigPopup.this.paymentRemark.setSize(parent.getWidth() - 2 * border, parent.getHeight() - (InvoiceConfigPopup.this.paymentRemark.getY() + border));
        }
    }
}

