/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.manager;

import ch.icit.pegasus.client.converter.AirportConverter;
import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.InvoiceHintConverter;
import ch.icit.pegasus.client.converter.InvoiceTypeEConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.invoice.manager.InvoiceModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.invoice.manager.details.CommentDetailsPanel;
import ch.icit.pegasus.client.gui.modules.invoice.manager.details.HistoryPanel;
import ch.icit.pegasus.client.gui.modules.invoice.manager.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.InvoiceSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleTypeE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InvoiceAccess;
import ch.icit.pegasus.server.core.dtos.search.InvoiceSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class InvoiceModule
extends ScreenTableView<InvoiceLight, InvoiceSearchConfiguration.INVOICE_SORT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String SEARCH_ID = "flight";
    private static final String PERIOD_ID = "dateChooser";
    private static final String CUSTOMER_ID = "customer";
    private static final String STATE_ID = "state";
    private static final String INVOICE_TYPE_ID = "invoiceTypeID";
    private static final String DELIVERY_AIRPORT = "deliveryAirport";
    private String filterCriteria1;
    private PeriodComplete filterCriteria2;
    private CustomerLight filterCriteria3;
    private InvoiceStateE filterCriteria4;
    private TitledPeriodEditor periodChooser;
    private ComboBox periodTypeChooser;
    private InvoiceTypeE filterCriteria5;
    private AirportComplete deliveryAirport;

    public InvoiceModule() {
        super(InvoiceLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodChooser.kill();
        this.periodChooser = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return InvoiceAccess.MODULE_INVOICE;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.PERIOD + "<>" + true);
        c.addProperty(PERIOD_ID, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(SEARCH_ID, Words.HINT_NUMBER, "");
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        ComboBox stateCombo = ComboBoxFactory.getInvoiceStateComboBox(true);
        this.filterChain.addSelectionComboBox(stateCombo, 100, STATE_ID, Words.STATE, Words.ALL);
        if (!Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType()) && !CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
            ComboBox b2 = ComboBoxFactory.getInvoiceTypeComboBox(true);
            this.filterChain.addSelectionComboBox(b2, 100, INVOICE_TYPE_ID, Words.TYPE, Words.ALL);
        } else {
            this.filterChain.setResetButtonWidth(120);
        }
        this.filterChain.addCustomerSearchField(CUSTOMER_ID);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodTypeChooser = ComboBoxFactory.getPeriodTypeComboBox();
        this.periodChooser = this.filterChain.addPeriodSelection(PERIOD_ID, p.getStartDate(), p.getEndDate(), Words.PERIOD, false);
        this.periodChooser.setCheckBoxEnabled();
        this.periodChooser.setCommitOnFocusLost(true);
        this.periodChooser.setComboBoxWidth(100);
        this.periodChooser.setComboBox(this.periodTypeChooser);
        if (CompanyUtil.isSCK((SystemSettingsComplete)settings)) {
            this.filterChain.addAirportSearchField(DELIVERY_AIRPORT);
        }
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<InvoiceLight, InvoiceSearchConfiguration.INVOICE_SORT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.periodChooser.setCheckBoxChecked(false);
            this.deliveryAirport = null;
        } else if (name == SEARCH_ID) {
            this.filterCriteria1 = (String)value;
        } else if (name == PERIOD_ID) {
            TitledPeriodEditor periodEditor = (TitledPeriodEditor)value;
            PeriodComplete p = new PeriodComplete();
            p.setStartDate(periodEditor.getStartDate());
            p.setEndDate(periodEditor.getEndDate());
            this.filterCriteria2 = p;
        } else if (name == CUSTOMER_ID) {
            this.filterCriteria3 = value instanceof CustomerLight ? (CustomerLight)value : (value instanceof Node ? (CustomerLight)((Node)value).getValue() : null);
        } else if (name == STATE_ID) {
            this.filterCriteria4 = value instanceof InvoiceStateE ? (InvoiceStateE)value : null;
        } else if (name == INVOICE_TYPE_ID) {
            this.filterCriteria5 = value instanceof InvoiceTypeE ? (InvoiceTypeE)value : null;
        } else if (name == DELIVERY_AIRPORT) {
            this.deliveryAirport = value instanceof AirportComplete ? (AirportComplete)value : (value instanceof Node ? (AirportComplete)((Node)value).getValue() : null);
        }
        boolean usePeriod = !this.periodTypeChooser.getSelectedItem().equals(Words.BY_DATE);
        InvoiceSearchConfiguration f = new InvoiceSearchConfiguration();
        f.setCustomer(this.filterCriteria3);
        f.setPeriod(this.filterCriteria2);
        f.setState(this.filterCriteria4);
        f.setSearchByDate(Boolean.valueOf(!usePeriod));
        f.setInvoiceType(this.filterCriteria5);
        f.setDeliveryAirport(this.deliveryAirport);
        if (this.filterCriteria1 != null) {
            try {
                int i = Integer.valueOf(this.filterCriteria1);
                f.setNumber(Integer.valueOf(i));
            }
            catch (NumberFormatException e) {
                f.setDescription(this.filterCriteria1);
            }
        }
        f.setNumResults(this.numberOfShownResults);
        if (this.currentColumnAttribute != null) {
            f.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            f.setSortDirection(SortDirection.ASCENDING);
        } else {
            f.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            f.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            f.setPageNumber(0);
        }
        if (f.getPageNumber() < 0) {
            f.setPageNumber(0);
        }
        return f;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<InvoiceLight> model) {
        if (screen.getType() == SubModuleTypeE.EXPORT) {
            InvoiceLight dto = model.getDTO(InvoiceLight.class);
            return dto == null || dto.getState() != InvoiceStateE.CREDIT_NOTE;
        }
        if (screen.getInvokingName().equals(InvoiceAccess.PRINT_INVOICE.getIdentifier())) {
            return true;
        }
        if (screen.getInvokingName().equals(InvoiceAccess.INFO_HISTORIC_INVOICE_DOWNLOAD.getIdentifier())) {
            if (model.getDTO(InvoiceLight.class).getState() == InvoiceStateE.CREDIT_NOTE && model.getDTO(InvoiceLight.class).getFinalData() == null) {
                return false;
            }
            return model.getDTO(InvoiceLight.class).getState() == InvoiceStateE.CLOSED || model.getDTO(InvoiceLight.class).getState() == InvoiceStateE.CANCELLED || model.getDTO(InvoiceLight.class).getState() == InvoiceStateE.CREDIT_NOTE;
        }
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<InvoiceLight> model) {
        if (model.getNode() != null && model.getNode().getValue() != null) {
            return model.getDTO(InvoiceLight.class).getState() != InvoiceStateE.CLOSED && model.getDTO(InvoiceLight.class).getNumber() == null;
        }
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<InvoiceLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<InvoiceLight> rowEditor = new MessageProvidedRowEditor<InvoiceLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<InvoiceLight>)rowEditor, p);
            CommentDetailsPanel d2 = new CommentDetailsPanel((RowEditor<InvoiceLight>)rowEditor, p);
            HistoryPanel reportHistory = null;
            HistoryPanel exportHistory = null;
            if (!rowEditor.getModel().isAddRow()) {
                reportHistory = new HistoryPanel(rowEditor, p){

                    @Override
                    public boolean canPreview() {
                        return true;
                    }

                    @Override
                    public DtoField getAttribute() {
                        return InvoiceComplete_.invoiceReports;
                    }

                    @Override
                    public String getTitleSuffix() {
                        return " " + Words.REPORTS;
                    }
                };
                exportHistory = new HistoryPanel(rowEditor, p){

                    @Override
                    public boolean canPreview() {
                        return false;
                    }

                    @Override
                    public DtoField getAttribute() {
                        return InvoiceComplete_.invoiceExports;
                    }

                    @Override
                    public String getTitleSuffix() {
                        return " " + Words.EXPORTS;
                    }
                };
            }
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
            c2.add((Component)d2, new TableLayoutConstraint(0, 0, 1.0, 0.2));
            if (!rowEditor.getModel().isAddRow()) {
                c2.add((Component)reportHistory, new TableLayoutConstraint(0, 1, 1.0, 0.4));
                c2.add((Component)exportHistory, new TableLayoutConstraint(0, 2, 1.0, 0.4));
            }
            c1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            c1.add((Component)c2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            if (!rowEditor.getModel().isAddRow()) {
                rowEditor.addToFocusQueue(reportHistory);
                rowEditor.addToFocusQueue(exportHistory);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    public SearchAlgorithm<InvoiceLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(InvoiceSearchAlgorithm.class);
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new InvoiceModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isSolarCompany = Boolean.TRUE.equals(settings.getCompany().getSolarCompanyType());
        if (Boolean.TRUE.equals(settings.getUseTrackingNoForInvoice())) {
            columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)StringConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.NUMBER, InvoiceLight_.customerInvoiceNumber, TableColumnInfo.numberColumnWithExpandWidth + 35, TableColumnInfo.numberColumnWithExpandWidth + 35, TableColumnInfo.numberColumnWithExpandWidth + 35));
        } else {
            columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.NUMBER, InvoiceLight_.number, TableColumnInfo.numberColumnWithExpandWidth + 35, TableColumnInfo.numberColumnWithExpandWidth + 35, TableColumnInfo.numberColumnWithExpandWidth + 35));
        }
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.STATE, InvoiceLight_.state, TableColumnInfo.state5, TableColumnInfo.state5, TableColumnInfo.state5));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.CUSTOMER, InvoiceLight_.customer, 80, 80, 80));
        if (CompanyUtil.isSCK((SystemSettingsComplete)settings)) {
            columns.add(new TableColumnInfo(Words.AIRPORT, "", AirportConverter.class, null, InvoiceLight_.deliveryAirport, 60, 60, 60));
        }
        columns.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.PERIOD, InvoiceLight_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.DATE, "", (Class)DateConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.DATE, InvoiceLight_.invoiceDate, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth, TableColumnInfo.dateColumnWidth));
        if (!isSolarCompany && !CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
            columns.add(new TableColumnInfo(Words.TYPE, "", (Class)InvoiceTypeEConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.TYPE, InvoiceLight_.invoiceType, 100, 100, 100));
            columns.add(new TableColumnInfo(Words.HINT, "", (Class)InvoiceHintConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.HINT, InvoiceLight_.hint, 50, Integer.MAX_VALUE, 50));
            columns.add(new TableColumnInfo(Words.PAYMENT_REMARK, "", (Class)StringConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.PAYMENT_REMARK, InvoiceLight_.paymentRemark, 50, Integer.MAX_VALUE, 50));
        }
        if (CompanyUtil.isNoPro((SystemSettingsComplete)settings)) {
            columns.add(new TableColumnInfo(Words.PAID, "", (Class)BooleanConverter.class, null, InvoiceLight_.paid, 50));
        }
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", (Class)StringConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.DESCRIPTION, InvoiceLight_.description, 50, Integer.MAX_VALUE, 50));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateConverter.class, (Enum<?>)InvoiceSearchConfiguration.INVOICE_SORT_COLUMN.CREATION_DATE, InvoiceLight_.creationDate, TableColumnInfo.dateTimeColumnWidth));
        return columns;
    }
}

