/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.productcatalog;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.AircraftTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceTypeComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;

public class ProductCatalogModuleDataHandler
extends DefaultDataHandler<ProductCatalogLight, ProductCatalogComplete> {
    public ProductCatalogModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<ProductCatalogLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ProductCatalogComplete.class);
                ProductCatalogComplete cat = (ProductCatalogComplete)node.getValue(ProductCatalogComplete.class);
                if (cat.getState() == null) {
                    cat.setState(ModificationStateE.DRAFT);
                }
                ProductCatalogComplete nCat = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateProductCatalog((ProductCatalogLight)cat).getValue();
                node.removeExistingValues();
                node.setValue((Object)nCat, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<ProductCatalogComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ProductCatalogComplete.class);
                ProductCatalogComplete cat = (ProductCatalogComplete)node.getValue(ProductCatalogComplete.class);
                if (cat.getState() == null) {
                    cat.setState(ModificationStateE.DRAFT);
                }
                if (cat.getEligibleLocations().isEmpty()) {
                    cat.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ProductCatalogComplete nCat = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createProductCatalog(cat).getValue();
                node.removeExistingValues();
                node.setValue((Object)nCat, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogModuleDataHandler.this.setCurrentLoadMaximum(10);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AircraftTypeComplete.class);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CateringServiceTypeComplete.class);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBoundDirections();
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllProductCatalogTypes();
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ProductCatalogModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProductCatalogModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, "Refresh Product Catalog");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProductCatalogLight cat = (ProductCatalogLight)node.getValue(ProductCatalogLight.class);
                ProductCatalogComplete nCat = (ProductCatalogComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductCatalog(new ProductCatalogReference(cat.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)nCat, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Node<ProductCatalogComplete> resetData(Node<ProductCatalogComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<ProductCatalogComplete> createEmptyNode() {
        ProductCatalogComplete cat = new ProductCatalogComplete();
        cat.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)cat, true, false);
    }

    @Override
    public Class<ProductCatalogComplete> getCommittingClass() {
        return ProductCatalogComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ProductCatalogLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

