/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.profitandloss;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.profitandloss.ProfitAndLossServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossComplete;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossLight;
import ch.icit.pegasus.server.core.dtos.profitandloss.ProfitAndLossReference;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ProfitAndLossModuleDataHandler
extends DefaultDataHandler<ProfitAndLossLight, ProfitAndLossComplete> {
    public ProfitAndLossModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return Words.CHECK_CUSTOMER_CODE;
    }

    @Override
    public void updateData(final Node<ProfitAndLossLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                ProfitAndLossComplete oldDTO = (ProfitAndLossComplete)node.getValue();
                ProfitAndLossComplete dto = (ProfitAndLossComplete)((ProfitAndLossServiceManager)ServiceManagerRegistry.getService(ProfitAndLossServiceManager.class)).updateProfitAndLoss(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<ProfitAndLossComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit();
                ProfitAndLossComplete oldDTO = (ProfitAndLossComplete)node.getValue();
                if (oldDTO.getEligibleLocations().isEmpty()) {
                    oldDTO.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                ProfitAndLossComplete dto = (ProfitAndLossComplete)((ProfitAndLossServiceManager)ServiceManagerRegistry.getService(ProfitAndLossServiceManager.class)).createProfitAndLoss(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProfitAndLossModuleDataHandler.this.setCurrentLoadMaximum(2);
                ProfitAndLossModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ProfitAndLossModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ProfitAndLossModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ProfitAndLossComplete> resetData(Node<ProfitAndLossComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<ProfitAndLossComplete> createEmptyNode() {
        ProfitAndLossComplete newOne = new ProfitAndLossComplete();
        newOne.setClientOId(Long.valueOf(ADTO.getNextId()));
        newOne.setPlState(ModificationStateE.DRAFT);
        newOne.setPlPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        newOne.setFlightPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        LocationComplete loc = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
        newOne.getEligibleLocations().add(loc);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)newOne, false, false);
        INodeCreator.getDefaultImpl().initUpdate(n);
        return n;
    }

    @Override
    public Class<FlightImportComplete> getCommittingClass() {
        return FlightImportComplete.class;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ProfitAndLossLight fil = (ProfitAndLossLight)node.getValue(ProfitAndLossLight.class);
                ProfitAndLossComplete c = (ProfitAndLossComplete)((ProfitAndLossServiceManager)ServiceManagerRegistry.getService(ProfitAndLossServiceManager.class)).getProfitAndLoss((ProfitAndLossReference)fil).getValue();
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void doRemoteValidation(Node<ProfitAndLossLight> node, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }
}

