/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextArea;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class OrderFooterDetailsPanel
extends DefaultDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private RDTextArea orderText;

    public OrderFooterDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.ORDER_FOOTER_TEXT);
        this.setCustomLayouter(new Layout());
        this.orderText = new RDTextArea(provider);
        this.addToView(this.orderText);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.orderText.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        OrderStateE e = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean canEdit = e.equals((Object)OrderStateE.PLACED);
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        boolean isApproved = o != null && o.equals((Object)OrderReviewStateE.APPROVED);
        this.orderText.setEnabled(isEnabled && canEdit && !isApproved);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.orderText.kill();
        this.orderText = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.orderText);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.orderText.setNode(node.getChildNamed(PurchaseOrderComplete_.footer));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 80);
        }

        @Override
        public void layoutContainer(Container parent) {
            OrderFooterDetailsPanel.this.orderText.setLocation(OrderFooterDetailsPanel.this.horizontalBorder, OrderFooterDetailsPanel.this.verticalBorder);
            OrderFooterDetailsPanel.this.orderText.setSize(parent.getWidth() - 2 * OrderFooterDetailsPanel.this.horizontalBorder, parent.getHeight() - 2 * OrderFooterDetailsPanel.this.verticalBorder);
        }
    }
}

