/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details.OrderPositionsDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SolarConfigurationDetailsPanel
extends DefaultDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> deliveryWindow;
    private TitledItem<RDDateChooser> deliveryDate;
    private TitledItem<RDDateChooser> orderDate;
    private TitledItem<RDComboBox> deliveryAddress;
    private TitledItem<RDComboBox> customer;
    private TitledItem<TextButton> reactivateAmountChange;
    private final OrderPositionsDetailsPanel panel;

    public SolarConfigurationDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider, OrderPositionsDetailsPanel panel) {
        super(editor, provider);
        this.panel = panel;
        this.setTitleText(Words.CONFIGURATION);
        this.deliveryAddress = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAddress.getElement().refreshPossibleValues(NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses));
        this.deliveryDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.SCHEDULED_DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow.getElement().refreshPossibleValues(NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class));
        this.reactivateAmountChange = new TitledItem<TextButton>(new TextButton(Words.ENABLE), Words.ENABLE_QUANTITY_CHANGE, TitledItem.TitledItemOrientation.EAST);
        this.customer = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customer.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ExternalCostCenterComplete.class));
        this.orderDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.ORDER_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.reactivateAmountChange.getElement().addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.deliveryAddress);
        this.addToView(this.deliveryDate);
        this.addToView(this.deliveryWindow);
        this.addToView(this.reactivateAmountChange);
        this.addToView(this.orderDate);
        this.addToView(this.customer);
    }

    private boolean showTaxZone() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.deliveryWindow);
        CheckedListAdder.addToList(focusList, this.reactivateAmountChange);
        CheckedListAdder.addToList(focusList, this.orderDate);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.reactivateAmountChange.getElement()) {
            this.panel.enableAmountChange();
            this.panel.setEnabled(this.panel.isEnabled());
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        OrderStateE e = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean canEdit = e.equals((Object)OrderStateE.PLACED);
        boolean canEditClosedOrder = this.provider.isWritable(PurchaseOrderAccess.EDIT_CLOSED_ORDER);
        if (!canEdit && canEditClosedOrder) {
            canEdit = true;
        }
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        OrderStateE s = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean isApproved = o != null && o.equals((Object)OrderReviewStateE.APPROVED);
        if (isApproved && canEditClosedOrder) {
            isApproved = false;
        }
        this.deliveryAddress.setEnabled(isEnabled && canEdit && !isApproved);
        this.deliveryDate.setEnabled(isEnabled && canEdit && !isApproved);
        this.deliveryWindow.setEnabled(isEnabled && canEdit && !isApproved);
        this.orderDate.setEnabled(isEnabled && canEdit && !isApproved);
        this.customer.setEnabled(isEnabled && canEdit && !isApproved);
        boolean canChangeAmountAnyway = this.provider.isWritable(PurchaseOrderAccess.CHANGE_AMOUNT_ANYWAY);
        this.reactivateAmountChange.setEnabled(isEnabled && canChangeAmountAnyway && e != OrderStateE.CANCELLED);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryAddress.kill();
        this.deliveryDate.kill();
        this.deliveryWindow.kill();
        this.reactivateAmountChange.kill();
        this.orderDate.kill();
        this.customer.kill();
        this.deliveryAddress = null;
        this.deliveryDate = null;
        this.deliveryWindow = null;
        this.reactivateAmountChange = null;
        this.orderDate = null;
        this.customer = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.deliveryAddress.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.deliveryAddress));
        this.deliveryDate.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.deliveryDate));
        this.deliveryWindow.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow));
        this.orderDate.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.orderDate));
        this.customer.getElement().setNode(node.getChildNamed(PurchaseOrderLight_.customer));
    }

    @Override
    public void requestFocusInWindowNow() {
        this.deliveryDate.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SolarConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.orderDate.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            h += SolarConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SolarConfigurationDetailsPanel.this.reactivateAmountChange.getPreferredSize().getHeight());
            return new Dimension(0, h += SolarConfigurationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 3 * SolarConfigurationDetailsPanel.this.horizontalBorder) / 2;
            SolarConfigurationDetailsPanel.this.deliveryDate.setLocation(SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.verticalBorder);
            SolarConfigurationDetailsPanel.this.deliveryDate.setSize(SolarConfigurationDetailsPanel.this.deliveryDate.getPreferredSize());
            SolarConfigurationDetailsPanel.this.orderDate.setLocation(SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.deliveryDate.getY() + SolarConfigurationDetailsPanel.this.deliveryDate.getHeight() + SolarConfigurationDetailsPanel.this.inner_verticalBorder);
            SolarConfigurationDetailsPanel.this.orderDate.setSize(SolarConfigurationDetailsPanel.this.orderDate.getPreferredSize());
            SolarConfigurationDetailsPanel.this.customer.setLocation(SolarConfigurationDetailsPanel.this.deliveryDate.getX() + SolarConfigurationDetailsPanel.this.deliveryDate.getWidth() + SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.verticalBorder);
            SolarConfigurationDetailsPanel.this.customer.setSize(w2tl, (int)SolarConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.deliveryWindow.setLocation(SolarConfigurationDetailsPanel.this.deliveryDate.getX() + SolarConfigurationDetailsPanel.this.deliveryDate.getWidth() + SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.customer.getY() + SolarConfigurationDetailsPanel.this.customer.getHeight() + SolarConfigurationDetailsPanel.this.inner_verticalBorder);
            SolarConfigurationDetailsPanel.this.deliveryWindow.setSize(w2tl, (int)SolarConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.deliveryAddress.setLocation(SolarConfigurationDetailsPanel.this.deliveryWindow.getX(), SolarConfigurationDetailsPanel.this.deliveryWindow.getY() + SolarConfigurationDetailsPanel.this.deliveryWindow.getHeight() + SolarConfigurationDetailsPanel.this.inner_verticalBorder);
            SolarConfigurationDetailsPanel.this.deliveryAddress.setSize(w2tl, (int)SolarConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            SolarConfigurationDetailsPanel.this.reactivateAmountChange.setLocation(SolarConfigurationDetailsPanel.this.horizontalBorder, SolarConfigurationDetailsPanel.this.deliveryAddress.getY() + SolarConfigurationDetailsPanel.this.deliveryAddress.getHeight() + SolarConfigurationDetailsPanel.this.verticalBorder);
            SolarConfigurationDetailsPanel.this.reactivateAmountChange.setSize(parent.getWidth() - 2 * SolarConfigurationDetailsPanel.this.horizontalBorder, (int)SolarConfigurationDetailsPanel.this.reactivateAmountChange.getPreferredSize().getHeight());
        }
    }
}

