/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.TransportCostTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.TransportCostTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.TransportCostComplete;
import ch.icit.pegasus.server.core.dtos.ordering.TransportCostComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TransportTypesDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private boolean isDeletable;

    public TransportTypesDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider, true);
        this.isDeletable = provider.isDeletable(PurchaseOrderComplete_.transportCosts);
        this.setTitleText(Words.TRANSPORT_COSTS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int ad = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.TRANSPORT_TYPE, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo(Words.COSTS, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", ad, ad, ad));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setOverrideName(PurchaseOrderComplete_.transportCosts);
        table.setProvider(this.provider);
        table.setDontUseScrollBar(15);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        TransportCostComplete nd = new TransportCostComplete();
        nd.setClientOId(Long.valueOf(ADTO.getNextId()));
        nd.setTransportCostType(this.getFreeType());
        nd.setCosts(new PriceComplete(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCurrency(), Double.valueOf(0.0)));
        Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)nd, true, false);
        this.table.getModel().getNode().addChild(nn, System.currentTimeMillis());
        this.editor.revalidate();
        this.table.getModel().recreateFocusCycle();
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        return new TableRowImpl(model);
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.transportCosts));
        OrderStateE e = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean isClosed = e.equals((Object)OrderStateE.CLOSED);
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        boolean isApproved = o.equals((Object)OrderReviewStateE.APPROVED);
        this.table.ensureAddButton(Words.TABLE_ADD, !isClosed && !isApproved);
    }

    private TransportCostTypeComplete getFreeType() {
        Iterator it = NodeToolkit.getAffixList(TransportCostTypeComplete.class).getChilds();
        if (it.hasNext()) {
            return (TransportCostTypeComplete)((Node)it.next()).getValue(TransportCostTypeComplete.class);
        }
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean b = false;
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                if (pp.validateRow()) continue;
                b = true;
            }
            if (b) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.TRANSPORT_COST_TYPE_MUST_BE_SET));
            }
        }
        return validationObjects;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDComboBox type_edit;
        private TextField costs_edit;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.type_edit = new RDComboBox(TransportTypesDetailsPanel.this.provider, ConverterRegistry.getConverter(TransportCostTypeConverter.class));
            this.type_edit.refreshPossibleValues(NodeToolkit.getAffixList(TransportCostTypeComplete.class));
            this.type_edit.setNode(m.getNode().getChildNamed(TransportCostComplete_.transportCostType));
            this.costs_edit = new NumberTextField(TextFieldType.DOUBLE);
            this.costs_edit.setNode(m.getNode().getChildNamed(new DtoField[]{TransportCostComplete_.costs, PriceComplete_.price}));
            this.setLayout(new InnerLayout());
            if (TransportTypesDetailsPanel.this.isDeletable) {
                this.deleteButton = new DeleteButton();
                this.deleteButton.setProgress(1.0f);
                this.deleteButton.addButtonListener(this);
                this.add(this.deleteButton);
            }
            this.type_edit.setProgress(1.0f);
            this.costs_edit.setProgress(1.0f);
            this.add(this.type_edit);
            this.add(this.costs_edit);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.type_edit.getStringValue();
                }
                case 1: {
                    return this.costs_edit.getStringValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.type_edit != null) {
                this.type_edit.setEnabled(isEnabled);
            }
            if (this.costs_edit != null) {
                this.costs_edit.setEnabled(isEnabled);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type_edit.kill();
            this.type_edit = null;
            this.costs_edit.kill();
            this.costs_edit = null;
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.deleteButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.type_edit);
            CheckedListAdder.addToList(focusList, this.costs_edit);
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.type_edit.requestFocusInWindowNow();
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
        }

        public boolean validateRow() {
            if (this.costs_edit.getText() == null) {
                this.costs_edit.setInvalid();
                return false;
            }
            return true;
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.type_edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type_edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type_edit.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type_edit.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.costs_edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costs_edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costs_edit.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costs_edit.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                if (TableRowImpl.this.deleteButton != null) {
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }
}

