/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils;

import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrderConfigPopup;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.OrdersColumnTitleConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manualcreator.details.utils.PurchasePreviewToPurchaseFieldAccessor;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2HeaderPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.OrderToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight_;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class OrderBreadCrumbGroupTable
extends BreadCrumbGroupTable {
    private static final long serialVersionUID = 1L;
    private boolean previewMode;
    private PurchasePreviewToPurchaseFieldAccessor fieldAccessor;
    private boolean orderFixed;

    public OrderBreadCrumbGroupTable(IDataHandler dataHandler, BreadCrumbPanel master, String buttonText, boolean previewMode, boolean orderFixed) {
        super(dataHandler, master, buttonText, null);
        this.fieldAccessor = new PurchasePreviewToPurchaseFieldAccessor(previewMode);
        this.previewMode = previewMode;
        this.orderFixed = orderFixed;
    }

    @Override
    public Table2RowPanel getGroupTableRow(Table2RowModel model, boolean isHeader) {
        if (isHeader) {
            return new Table2HeaderPanel(model, 7);
        }
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public void addButtonPressed() {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> a = new ArrayList<TableColumnInfo>();
        a.add(new TableColumnInfo(Words.SUPPLIER, null, null, null, "", 40, 40, 40));
        if (this.isTaxZoneAllowed()) {
            a.add(new TableColumnInfo(Words.TAX_ZONE, null, null, null, "", 60, 60, 60));
        }
        int tw = this.getTable().getCellPadding() * 2 + EditButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        a.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)a.get(0)).setxExpand(1.0);
        if (this.isTaxZoneAllowed()) {
            ((TableColumnInfo)a.get(1)).setxExpand(0.0);
            ((TableColumnInfo)a.get(2)).setxExpand(0.0);
        } else {
            ((TableColumnInfo)a.get(1)).setxExpand(0.0);
        }
        return a;
    }

    private boolean isTaxZoneAllowed() {
        return Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public Comparator<?> getGroupComparator() {
        return null;
    }

    public Converter<Object, String> getTitleConverter() {
        return ConverterRegistry.getConverter(OrdersColumnTitleConverter.class);
    }

    @Override
    public int getSortingIndex() {
        return 0;
    }

    public List<ScreenValidationObject> validateComponents() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel p : this.getTable().getRows()) {
            TableRowImpl m = (TableRowImpl)p;
            List<ScreenValidationObject> validationObjects = m.validateRow();
            rets.addAll(validationObjects);
        }
        return rets;
    }

    public List<ScreenValidationObject> validateOrderIntervalAndDeliveryTime() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        for (Table2RowPanel p : this.getTable().getRows()) {
            TableRowImpl m = (TableRowImpl)p;
            rets.addAll(m.validateOrderIntervalAndDeliveryTime());
        }
        return rets;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    InnerPopUpListener2 {
        private static final long serialVersionUID = 1L;
        private TextLabel supplierSearch;
        private TextLabel taxZone;
        private EditButton edit;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            this.supplierSearch = new TextLabel(m.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField()), ConverterRegistry.getConverter(SupplierConverter.class));
            if (OrderBreadCrumbGroupTable.this.isTaxZoneAllowed()) {
                this.taxZone = new TextLabel(m.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getTaxZoneField()), ConverterRegistry.getConverter(TaxZoneConverter.class));
            }
            this.edit = new EditButton();
            this.setLayout(new Layout());
            this.edit.addButtonListener(this);
            this.add(this.supplierSearch);
            if (this.taxZone != null) {
                this.add(this.taxZone);
            }
            this.add(this.edit);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.supplierSearch.kill();
            if (this.taxZone != null) {
                this.taxZone.kill();
            }
            this.edit.kill();
            this.supplierSearch = null;
            this.taxZone = null;
            this.edit = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.edit.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField(), SupplierLight_.number}).getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.supplierSearch.setEnabled(isEnabled && !OrderBreadCrumbGroupTable.this.orderFixed);
            if (this.taxZone != null) {
                this.taxZone.setEnabled(isEnabled && !OrderBreadCrumbGroupTable.this.orderFixed);
            }
            this.edit.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.edit) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(source, true, true, Words.ORDER_DETAILS);
                popUp.setView(new OrderConfigPopup(this.model.getNode(), OrderBreadCrumbGroupTable.this.fieldAccessor, !OrderBreadCrumbGroupTable.this.orderFixed, OrderBreadCrumbGroupTable.this.previewMode));
                if (OrderBreadCrumbGroupTable.this.previewMode) {
                    this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierConfirmed()).setValue((Object)true, 0L);
                }
                popUp.showPopUp(x, y, -1, -1, this, source);
            }
        }

        @Override
        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
            this.supplierSearch.setValid();
        }

        public List<ScreenValidationObject> validateRow() {
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            boolean supplierConfig = true;
            if (OrderBreadCrumbGroupTable.this.previewMode) {
                supplierConfig = Boolean.TRUE.equals(this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierConfirmed()).getValue());
            } else {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                boolean mixedOrdersAllowed = Boolean.TRUE.equals(settings.getAllowMixedOrdersWithCustomerOwnedArticles());
                if (!mixedOrdersAllowed) {
                    SupplierLight supplier;
                    String articlesToRemove;
                    Boolean customerOwnedOnly = (Boolean)this.model.getNode().getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue();
                    boolean foundOwnedArticle = false;
                    boolean foundNotOwnedArticle = false;
                    HashSet<Object> ownedArticles = new HashSet<Object>();
                    HashSet<Object> notOwnedArticles = new HashSet<Object>();
                    Iterator it = this.model.getNode().getChildNamed(PurchaseOrderComplete_.orderPositions).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node position = (Node)it.next();
                        BasicArticleLight article = (BasicArticleLight)position.getChildNamed(PurchaseOrderPositionComplete_.article).getValue();
                        if (Boolean.TRUE.equals(article.getCustomerIsOwner())) {
                            foundOwnedArticle = true;
                            ownedArticles.add(article);
                            continue;
                        }
                        foundNotOwnedArticle = true;
                        notOwnedArticles.add(article);
                    }
                    if (Boolean.TRUE.equals(customerOwnedOnly) && foundNotOwnedArticle) {
                        articlesToRemove = "";
                        for (BasicArticleLight basicArticleLight : notOwnedArticles) {
                            articlesToRemove = articlesToRemove + basicArticleLight.getNumber() + ",";
                        }
                        articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                        supplier = (SupplierLight)this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField()).getValue();
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Order to " + supplier.getName() + " can only contains 'customer owned' articles, please remove article " + articlesToRemove));
                    } else if (Boolean.FALSE.equals(customerOwnedOnly) && foundOwnedArticle) {
                        articlesToRemove = "";
                        for (BasicArticleLight basicArticleLight : ownedArticles) {
                            articlesToRemove = articlesToRemove + basicArticleLight.getNumber() + ",";
                        }
                        articlesToRemove = articlesToRemove.substring(0, articlesToRemove.length() - 1);
                        supplier = (SupplierLight)this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField()).getValue();
                        validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Order to " + supplier.getName() + " can only contains 'not customer owned' articles, please remove article " + articlesToRemove));
                    }
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getDeliveryDateField()).getValue() == null) {
                    supplierConfig = false;
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getOrderDateField()).getValue() == null) {
                    supplierConfig = false;
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getOrderDeliveryWindowField()).getValue() == null) {
                    supplierConfig = false;
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getDeliveryTermField()).getValue() == null) {
                    supplierConfig = false;
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getDeliveryAddressField()).getValue() == null) {
                    supplierConfig = false;
                }
                if (this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getEligibleLocationField()).getChildCount() != 1) {
                    supplierConfig = false;
                }
            }
            if (!supplierConfig) {
                this.supplierSearch.setInvalid();
                SupplierLight supplier = (SupplierLight)this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField()).getValue();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Review Supplier " + supplier.getName() + ". Press 'Edit Button' to config."));
            }
            return validationObjects;
        }

        public List<ScreenValidationObject> validateOrderIntervalAndDeliveryTime() {
            int locs;
            ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
            Date deliveryDate = (Date)this.getModel().getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getDeliveryDateField()).getValue();
            SupplierLight supplier = (SupplierLight)this.getModel().getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getSupplierField()).getValue();
            if (deliveryDate == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Delivery Date is not set"));
            }
            if (supplier == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Supplier is not set"));
            }
            if ((locs = this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getEligibleLocationField()).getChildCount()) == 0) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Location is not set"));
            } else if (locs > 1) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure only one Location is set"));
            }
            Iterator it = this.model.getNode().getChildNamed(OrderBreadCrumbGroupTable.this.fieldAccessor.getPositionField()).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                rets.addAll(this.processOrderPosition(n, deliveryDate, supplier, false, null));
            }
            return rets;
        }

        private List<ScreenValidationObject> processOrderPosition(Node position, Date deliveryDate, SupplierLight supplier, Boolean useTaxZone, TaxZoneComplete taxZone) {
            ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
            Long l = TransactionToolkit.getLongValue(position.getChildNamed(new String[]{"quantity-amount"}));
            if (l == 0L) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Quantity of Article " + ((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), null, new Object[0]) + " is 0, article will be removed from Order"));
            } else {
                BasicArticleComplete art;
                SupplierConditionComplete sc;
                Date d2;
                Timestamp validity = new Timestamp(System.currentTimeMillis());
                Date d = OrderToolkit.getMinDeliveryDate((BasicArticleComplete)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), (SupplierReference)supplier, useTaxZone, taxZone, validity);
                if (deliveryDate == null) {
                    deliveryDate = new Date(System.currentTimeMillis());
                }
                if ((d2 = OrderToolkit.shiftDeliveryDate2MidNight(deliveryDate)).getTime() < d.getTime()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Delivery time for Article " + ((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), null, new Object[0]) + " is bigger than selected delivery date."));
                }
                if ((sc = ArticleToolkit.getSupplierCondition(art = (BasicArticleComplete)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), (SupplierReference)supplier, useTaxZone, taxZone, validity)) == null || !sc.getCanBeOrdered().booleanValue()) {
                    rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + art.getNumber() + " - " + art.getName() + " can't be ordered from Supplier " + supplier.getName()));
                }
                if (sc == null) {
                    return rets;
                }
                double minOAmount = sc.getMinOrderAmount();
                Boolean minOrderAmountIsMandatory = sc.getMinOrderAmountIsMandatory();
                if (minOAmount > 0.0) {
                    BasicArticleComplete artC = (BasicArticleComplete)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                    if (artC == null) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article in Order is not set"));
                    } else {
                        UnitComplete unit;
                        if (artC.getMainStoreUnit() == null) {
                            Converter c = ConverterRegistry.getConverter(BasicArticleConverter.class);
                            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Article " + c.convert((Object)artC, null, new Object[0]) + " has no main unit defined"));
                        }
                        double a = l.doubleValue();
                        UnitComplete u = (UnitComplete)position.getChildNamed(new String[]{"quantity-unit"}).getValue();
                        int dd = (int)UnitConversionToolkit.convertUnit((UnitComplete)u, (UnitComplete)(unit = sc.getMinOrderAmountUnit() != null ? sc.getMinOrderAmountUnit() : sc.getOrderUnit()), (double)a, (BasicArticleLight)artC, (Timestamp)new Timestamp(System.currentTimeMillis()));
                        if ((double)dd % minOAmount != 0.0) {
                            ScreenValidationObject.ValidationStateE type = Boolean.TRUE.equals(minOrderAmountIsMandatory) ? ScreenValidationObject.ValidationStateE.FATAL : ScreenValidationObject.ValidationStateE.WARNING;
                            rets.add(new ScreenValidationObject(type, "Quantity of Article " + ((BasicArticleConverter)ConverterRegistry.getConverter(BasicArticleConverter.class)).convert((BasicArticleLight)position.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), null, new Object[0]) + " is not in the Order Interval given by Supplier"));
                        }
                    }
                }
            }
            return rets;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.supplierSearch.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplierSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.supplierSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplierSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                if (TableRowImpl.this.taxZone != null) {
                    TableRowImpl.this.taxZone.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxZone.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.taxZone.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxZone.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                }
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.edit.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.edit.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.edit.setSize(TableRowImpl.this.edit.getPreferredSize());
            }
        }
    }
}

