/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseproposal.details;

import ch.icit.pegasus.client.converter.MatDispoSupplierAndStoreTemplateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.gui.utils.tables.SupplierTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.MatDispoSupplierAndStoreTemplateComplete;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class StoresAndSupplierDetailsPanel
extends DefaultDetailsPanel<PurchaseProposalLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> template;
    private TextButton loadTemplate;
    private TextButton clear;
    private SupplierTable supplierTable;
    private StoreSearchTable storeSearchTable;

    public StoresAndSupplierDetailsPanel(RowEditor<PurchaseProposalLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText("Stores and Suppliers");
        this.template = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(MatDispoSupplierAndStoreTemplateConverter.class), true, true), "Template", TitledItem.TitledItemOrientation.NORTH);
        this.loadTemplate = new TextButton("Load");
        this.loadTemplate.addButtonListener((source, x, y) -> this.loadTemplate());
        this.clear = new TextButton("Clear");
        this.clear.addButtonListener((source, x, y) -> this.clearTemplate());
        this.supplierTable = new SupplierTable();
        this.storeSearchTable = new StoreSearchTable();
        this.supplierTable.setNode((Node<List<SupplierLight>>)new ListNode());
        this.storeSearchTable.setNode((Node<List<StoreLight>>)new ListNode());
        this.setCustomLayouter(new Layout());
        this.addToView(this.template);
        this.addToView(this.loadTemplate);
        this.addToView(this.clear);
        this.addToView(this.supplierTable);
        this.addToView(this.storeSearchTable);
    }

    private void clearTemplate() {
        this.supplierTable.getNode().removeAllChilds();
        this.storeSearchTable.getNode().removeAllChilds();
    }

    private void loadTemplate() {
        this.supplierTable.getNode().removeAllChilds();
        this.storeSearchTable.getNode().removeAllChilds();
        MatDispoSupplierAndStoreTemplateComplete sst = (MatDispoSupplierAndStoreTemplateComplete)this.template.getElement().getNode().getValue();
        if (sst != null) {
            for (StoreLight store : sst.getStores()) {
                this.storeSearchTable.getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)store, false, true), 0L);
            }
            for (SupplierLight supplier : sst.getSuppliers()) {
                this.supplierTable.getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)supplier, false, true), 0L);
            }
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.template.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.template.getElement().refreshPossibleValues(NodeToolkit.getAffixList(MatDispoSupplierAndStoreTemplateComplete.class));
        this.storeSearchTable.setNode((Node<List<StoreLight>>)node.getChildNamed(PurchaseProposalComplete_.stores));
        this.supplierTable.setNode((Node<List<SupplierLight>>)node.getChildNamed(PurchaseProposalComplete_.suppliers));
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.template);
        CheckedListAdder.addToList(focusList, this.loadTemplate);
        CheckedListAdder.addToList(focusList, this.clear);
        CheckedListAdder.addToList(focusList, this.storeSearchTable);
        CheckedListAdder.addToList(focusList, this.supplierTable);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.template.setEnabled(isEnabled);
        this.loadTemplate.setEnabled(isEnabled);
        this.clear.setEnabled(isEnabled);
        this.storeSearchTable.setEnabled(isEnabled);
        this.supplierTable.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.template.kill();
        this.template = null;
        this.loadTemplate.kill();
        this.loadTemplate = null;
        this.clear.kill();
        this.clear = null;
        this.storeSearchTable.kill();
        this.storeSearchTable = null;
        this.supplierTable.kill();
        this.supplierTable = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StoresAndSupplierDetailsPanel.this.template.setLocation(StoresAndSupplierDetailsPanel.this.horizontalBorder, StoresAndSupplierDetailsPanel.this.verticalBorder);
            StoresAndSupplierDetailsPanel.this.template.setSize(200, (int)StoresAndSupplierDetailsPanel.this.template.getPreferredSize().getHeight());
            StoresAndSupplierDetailsPanel.this.loadTemplate.setLocation(StoresAndSupplierDetailsPanel.this.template.getX() + StoresAndSupplierDetailsPanel.this.template.getWidth() + StoresAndSupplierDetailsPanel.this.inner_horizontalBorder, (int)((double)(StoresAndSupplierDetailsPanel.this.template.getY() + StoresAndSupplierDetailsPanel.this.template.getHeight()) - StoresAndSupplierDetailsPanel.this.loadTemplate.getPreferredSize().getHeight()));
            StoresAndSupplierDetailsPanel.this.loadTemplate.setSize(StoresAndSupplierDetailsPanel.this.loadTemplate.getPreferredSize());
            StoresAndSupplierDetailsPanel.this.clear.setLocation(StoresAndSupplierDetailsPanel.this.loadTemplate.getX() + StoresAndSupplierDetailsPanel.this.loadTemplate.getWidth() + StoresAndSupplierDetailsPanel.this.inner_horizontalBorder, StoresAndSupplierDetailsPanel.this.loadTemplate.getY());
            StoresAndSupplierDetailsPanel.this.clear.setSize(StoresAndSupplierDetailsPanel.this.clear.getPreferredSize());
            StoresAndSupplierDetailsPanel.this.supplierTable.setLocation(StoresAndSupplierDetailsPanel.this.horizontalBorder, StoresAndSupplierDetailsPanel.this.template.getY() + StoresAndSupplierDetailsPanel.this.template.getHeight() + StoresAndSupplierDetailsPanel.this.verticalBorder);
            StoresAndSupplierDetailsPanel.this.supplierTable.setSize((parent.getWidth() - 4 * StoresAndSupplierDetailsPanel.this.horizontalBorder) / 2, 400);
            StoresAndSupplierDetailsPanel.this.storeSearchTable.setLocation(StoresAndSupplierDetailsPanel.this.supplierTable.getX() + StoresAndSupplierDetailsPanel.this.supplierTable.getWidth() + 2 * StoresAndSupplierDetailsPanel.this.horizontalBorder, StoresAndSupplierDetailsPanel.this.supplierTable.getY());
            StoresAndSupplierDetailsPanel.this.storeSearchTable.setSize((parent.getWidth() - 4 * StoresAndSupplierDetailsPanel.this.horizontalBorder) / 2, 400);
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = StoresAndSupplierDetailsPanel.this.verticalBorder;
            h = (int)((double)h + StoresAndSupplierDetailsPanel.this.template.getPreferredSize().getHeight());
            h += StoresAndSupplierDetailsPanel.this.verticalBorder;
            h += 400;
            return new Dimension(0, h += StoresAndSupplierDetailsPanel.this.verticalBorder);
        }
    }
}

