/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.radar.view.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public class RadarAirlineIcon
extends Button {
    private static final long serialVersionUID = 1L;
    private BufferedImage image;
    private boolean isNoImage = false;
    private boolean isOutbound = false;
    private Node<FlightLight> node;
    private int roundness = 0;
    private Color lineColor;

    public RadarAirlineIcon(boolean isOutbound) {
        this.isOutbound = isOutbound;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.image != null) {
            g2.drawImage(this.image, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
        }
        g2.setColor(this.lineColor);
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, this.roundness, this.roundness);
        if (this.isNoImage && this.node != null && this.node.getValue() != null) {
            String name = ((FlightLight)this.node.getValue()).getCustomer().getCode();
            g2.setColor(Color.black);
            g2.setFont(new Font("Verdana", 1, 8));
            int w = g2.getFontMetrics().stringWidth(name);
            g2.drawString(name, (this.getWidth() - w) / 2, (this.getHeight() + g2.getFont().getSize()) / 2);
        }
        this.paintChildren(g2);
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    private void loadNoImage() {
        this.image = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("radar_noimg"));
        this.isNoImage = true;
    }

    public void setImageFile(File value, Node<FlightLight> flight) {
        this.node = flight;
        if (value == null) {
            this.loadNoImage();
            return;
        }
        try {
            this.image = ImageIO.read(value);
            this.isNoImage = false;
        }
        catch (IOException e) {
            this.loadNoImage();
            e.printStackTrace();
        }
        this.repaint(32L);
    }
}

