/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reorderlevel.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight;
import ch.icit.pegasus.server.core.dtos.ordering.reorderlevel.ReorderLevelLight_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ReorderLevelLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledPeriodEditor validity;
    private TitledPeriodEditor flightPeriod;
    private TitledItem<RDMultiLocationComboBox> location;

    public SpecificationDetailsPanel(RowEditor<ReorderLevelLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.validity = new TitledPeriodEditor(null, null, true, provider);
        this.validity.setTitleText("Validity Start", "Validity End");
        this.validity.getStartDateChooser().setOverrideName(ReorderLevelLight_.validity);
        this.validity.getEndDateChooser().setOverrideName(ReorderLevelLight_.validity);
        this.validity.getEndDateChooser().setCheckBoxEnabled();
        this.flightPeriod = new TitledPeriodEditor(null, null, true, provider);
        this.flightPeriod.setTitleText("Flight Start", "Flight End");
        this.flightPeriod.getStartDateChooser().setOverrideName(ReorderLevelLight_.flightPeriod);
        this.flightPeriod.getEndDateChooser().setOverrideName(ReorderLevelLight_.flightPeriod);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.validity);
        this.addToView(this.flightPeriod);
        if (this.location != null) {
            this.addToView(this.location);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(ReorderLevelLight_.number));
        this.name.getElement().setNode(node.getChildNamed(ReorderLevelLight_.name));
        this.validity.setNode((Node<PeriodComplete>)node.getChildNamed(ReorderLevelLight_.validity));
        this.flightPeriod.setNode((Node<PeriodComplete>)node.getChildNamed(ReorderLevelLight_.flightPeriod));
        if (this.location != null) {
            this.location.getElement().setNode(node.getChildNamed(ReorderLevelLight_.eligibleLocations));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.validity);
        CheckedListAdder.addToList(focusList, this.flightPeriod);
        CheckedListAdder.addToList(focusList, this.location);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String n = (String)this.editor.getModel().getNode().getChildNamed(SafetyStockLight_.name).getValue();
        if (n == null || n.isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.flightPeriod.setEnabled(isEnabled);
        this.validity.setEnabled(isEnabled);
        if (this.location != null) {
            this.location.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.name.kill();
        this.name = null;
        this.validity.kill();
        this.validity = null;
        this.flightPeriod.kill();
        this.flightPeriod = null;
        if (this.location != null) {
            this.location.kill();
        }
        this.location = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(80, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.name.getX()), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.validity.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.validity.setSize(SpecificationDetailsPanel.this.validity.getPreferredSize());
            SpecificationDetailsPanel.this.flightPeriod.setLocation(SpecificationDetailsPanel.this.validity.getX() + SpecificationDetailsPanel.this.validity.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.validity.getY());
            SpecificationDetailsPanel.this.flightPeriod.setSize(SpecificationDetailsPanel.this.flightPeriod.getPreferredSize());
            if (SpecificationDetailsPanel.this.location != null) {
                SpecificationDetailsPanel.this.location.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.validity.getY() + SpecificationDetailsPanel.this.validity.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.location.setSize(SpecificationDetailsPanel.this.location.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.validity.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (SpecificationDetailsPanel.this.location != null) {
                h = (int)((double)h + SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }
    }
}

