/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manager;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.CostCenterListConverter;
import ch.icit.pegasus.client.converter.DateAndTimeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.RequisitionOrderModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.CreateOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.addrow.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.DeliveryGroupDetailsPanel;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manager.details.OrderPositionsDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.DetailsEditorParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.RequisitionOrderSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RequisitionOrderAccess;
import ch.icit.pegasus.server.core.dtos.search.RequisitionOrderSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class RequisitionOrderModule
extends ScreenTableView<RequisitionOrderLight, RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NUMBER = "Number";
    private static final String FILTER_STATE_TYPE = "StateType";
    private static final String FILTER_STATE = "State";
    private static final String FILTER_INVERT = "Invert";
    private static final String FILTER_RECEIVE_DEPARTMENT = "Required for Department";
    private static final String FILTER_DELIVER_DEPARTMENT = "Deliver Department";
    private static final String FILTER_ORDERED_DEPARTMENT = "Ordered for Department";
    private static final String FILTER_REDIRECT = "redirect";
    private static final String FILTER_HALAL = "halal";
    private static final String FILTER_DATE = "Date";
    private String filterCriteria1;
    private OrderStateE filterCriteria2;
    private OrderStateE filterCriteria2_2;
    private Boolean filterCriteria3;
    private CostCenterComplete filterCriteria4;
    private Boolean filterStateType;
    private CostCenterComplete filterCriteria5;
    private CostCenterComplete filterCriteria6;
    private Boolean redirect;
    private TitledPeriodEditor filterCriteria9;
    private Boolean halalFilter;
    private ComboBox receiveDepartment;
    private ComboBox deliverDepartment;
    private ComboBox orderedDepartment;

    public RequisitionOrderModule() {
        super(RequisitionOrderLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.receiveDepartment.kill();
        this.receiveDepartment = null;
        this.deliverDepartment.kill();
        this.deliverDepartment = null;
        this.orderedDepartment.kill();
        this.orderedDepartment = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return RequisitionOrderAccess.MODULE_REQUISITION;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.NUMBER + "<>" + false);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NUMBER, Words.NUMBER, "");
        ComboBox types = new ComboBox();
        types.addItem(Words.ALL);
        types.addItem(Words.DELIVER_STATE);
        types.addItem(Words.RECEIVE_STATE);
        this.filterChain.addSelectionComboBox(types, 100, FILTER_STATE_TYPE, Words.TYPE, Words.ALL);
        ComboBox b = ComboBoxFactory.getOrderStateComboBox(true);
        b.setSelectedItem(OrderStateE.CLOSED);
        this.filterChain.addSelectionComboBox(b, FILTER_STATE, Words.STATE, Words.ALL);
        this.receiveDepartment = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.receiveDepartment, 180, FILTER_RECEIVE_DEPARTMENT, Words.REQUIRED_BY_DEPARTMENT, Words.ALL);
        this.deliverDepartment = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.deliverDepartment, 180, FILTER_DELIVER_DEPARTMENT, Words.DELIVER_DEPARTMENT, Words.ALL);
        this.orderedDepartment = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.orderedDepartment, 180, FILTER_ORDERED_DEPARTMENT, Words.ORDERED_FOR_DEPARTMENT, Words.ALL);
        ComboBox redirectCombo = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(redirectCombo, 150, FILTER_REDIRECT, Words.FROM_PURCHASE, Words.ALL);
        ComboBox d = new ComboBox();
        d.addItem(PeriodMode.ALL);
        d.addItem(PeriodMode.LAST_RECEIVED);
        d.addItem(PeriodMode.PLACED);
        d.addItem(PeriodMode.SCHEDULED);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodEditor = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), "", true);
        periodEditor.setCheckBoxEnabled();
        periodEditor.setCheckBoxChecked(false);
        periodEditor.setCommitOnFocusLost(true);
        periodEditor.setComboBox(d);
        periodEditor.setComboBoxWidth(125);
        ComboBox h = ComboBoxFactory.getHalal(true);
        this.filterChain.addSelectionComboBox(h, FILTER_HALAL, "Halal", Words.ALL);
        this.filterChain.addResetButton();
        this.isAsc = false;
        this.filterCriteria2 = null;
        this.filterCriteria2_2 = null;
        this.filterCriteria3 = false;
        this.filterStateType = null;
        this.halalFilter = null;
    }

    @Override
    public ASearchConfiguration<RequisitionOrderLight, RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria2_2 = null;
            this.filterCriteria3 = false;
            this.filterCriteria4 = null;
            this.filterCriteria5 = null;
            this.filterCriteria9 = null;
            this.filterStateType = null;
            this.filterCriteria6 = null;
            this.redirect = null;
            this.halalFilter = null;
        } else if (name == FILTER_NUMBER) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STATE) {
            if (Words.ALL.equals(value)) {
                this.filterCriteria2 = null;
                this.filterCriteria2_2 = null;
                this.filterCriteria3 = false;
            } else if (Words.PENDING.equals(value)) {
                this.filterCriteria2 = OrderStateE.PENDING;
                this.filterCriteria2_2 = null;
                this.filterCriteria3 = false;
            } else if (Words.PLACED.equals(value)) {
                this.filterCriteria2 = OrderStateE.PLACED;
                this.filterCriteria2_2 = null;
                this.filterCriteria3 = false;
            } else if (Words.CLOSED.equals(value)) {
                this.filterCriteria2 = OrderStateE.CLOSED;
                this.filterCriteria2_2 = null;
                this.filterCriteria3 = false;
            } else if (Words.CANCELLED.equals(value)) {
                this.filterCriteria2 = OrderStateE.CANCELLED;
                this.filterCriteria2_2 = null;
                this.filterCriteria3 = false;
            } else if (Words.CANCELED_OR_CLOSED.equals(value)) {
                this.filterCriteria2 = OrderStateE.CANCELLED;
                this.filterCriteria2_2 = OrderStateE.CLOSED;
                this.filterCriteria3 = false;
            } else if (Words.OPEN_ORDER.equals(value)) {
                this.filterCriteria3 = true;
                this.filterCriteria2 = OrderStateE.CANCELLED;
                this.filterCriteria2_2 = OrderStateE.CLOSED;
            }
        } else if (name == FILTER_INVERT) {
            this.filterCriteria3 = (Boolean)value;
        } else if (name == FILTER_RECEIVE_DEPARTMENT) {
            this.filterCriteria4 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_DELIVER_DEPARTMENT) {
            this.filterCriteria5 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_ORDERED_DEPARTMENT) {
            this.filterCriteria6 = value instanceof CostCenterComplete ? (CostCenterComplete)value : (value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : null);
        } else if (name == FILTER_DATE) {
            this.filterCriteria9 = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE_TYPE) {
            if (value instanceof String) {
                if (Words.ALL.equals(value)) {
                    this.filterStateType = null;
                } else if (Words.DELIVER_STATE.equals(value)) {
                    this.filterStateType = true;
                } else if (Words.RECEIVE_STATE.equals(value)) {
                    this.filterStateType = false;
                }
            } else {
                this.filterStateType = null;
            }
        } else if (name == FILTER_HALAL) {
            this.halalFilter = value instanceof String ? (Words.NOT_HALAL_ONLY.equals(value) ? Boolean.valueOf(false) : (Words.HALAL_ONLY.equals(value) ? Boolean.valueOf(true) : null)) : null;
        } else if (name == FILTER_REDIRECT) {
            this.redirect = value instanceof String ? (value.equals(Words.YES) ? Boolean.valueOf(true) : (value.equals(Words.NO_ANSWER) ? Boolean.valueOf(false) : null)) : null;
        }
        RequisitionOrderSearchConfiguration config = new RequisitionOrderSearchConfiguration();
        config.setState(this.filterCriteria2);
        config.setSecondState(this.filterCriteria2_2);
        config.setInvertState(this.filterCriteria3);
        config.setRequiredBy(this.filterCriteria4);
        config.setNumResults(this.numberOfShownResults);
        config.setStateType(this.filterStateType);
        config.setDeliverBy(this.filterCriteria5);
        config.setOrderedFor(this.filterCriteria6);
        config.setRedirectOrder(this.redirect);
        config.setHalal(this.halalFilter);
        if (this.filterCriteria9 != null) {
            PeriodComplete p = new PeriodComplete(this.filterCriteria9.getStartDate(), this.filterCriteria9.getEndDate());
            if (this.filterCriteria9.getStartDate() != null && this.filterCriteria9.getEndDate() != null) {
                switch ((PeriodMode)((Object)this.filterCriteria9.getComboBox().getSelectedItem())) {
                    case ALL: {
                        config.setPeriod(p);
                        break;
                    }
                    case LAST_RECEIVED: {
                        config.setLastRecieved(p);
                        break;
                    }
                    case PLACED: {
                        config.setPlaced(p);
                        break;
                    }
                    case SCHEDULED: {
                        config.setScheduled(p);
                        break;
                    }
                }
            }
        }
        if (this.filterCriteria1 != null) {
            try {
                int i = Integer.valueOf(this.filterCriteria1);
                config.setNumber(Integer.valueOf(i));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.currentColumnAttribute != null) {
            config.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            config.setSortDirection(SortDirection.ASCENDING);
        } else {
            config.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            config.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            config.setPageNumber(0);
        }
        if (config.getPageNumber() < 0) {
            config.setPageNumber(0);
        }
        return config;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.receiveDepartment.refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        this.receiveDepartment.addItem(Words.ALL);
        this.receiveDepartment.setSelectedItem(Words.ALL);
        this.deliverDepartment.refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        this.deliverDepartment.addItem(Words.ALL);
        this.deliverDepartment.setSelectedItem(Words.ALL);
        this.orderedDepartment.refreshPossibleValues(NodeToolkit.getAffixList(ExternalCostCenterComplete.class));
        this.orderedDepartment.addItem(Words.ALL);
        this.orderedDepartment.setSelectedItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<RequisitionOrderLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(RequisitionOrderSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<RequisitionOrderLight> model) {
        if (screen.getInvokingName().equals(RequisitionOrderAccess.ACTION_CANCEL_REQUISITION.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.ACTION_CLOSE_REQUISITION.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.TOOL_REQUISITION_DELIVER_CB.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.TOOL_REQUISITION_DELIVER_PB.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.TOOL_REQUISITION_RECEIVE_PREP_CB.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.TOOL_REQUISITION_RECEIVE_REJ_CB.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.PRINT_REQUISITION_DELIVER_SHEET.getIdentifier()) || screen.getInvokingName().equals(RequisitionOrderAccess.PRINT_REQUISITION_RECEIVE_SHEET.getIdentifier())) {
            if (model == null) {
                return false;
            }
            if (model.getNode() == null) {
                return false;
            }
            if (model.getNode().getValue(RequisitionOrderLight.class) == null) {
                return false;
            }
            if (((RequisitionOrderLight)model.getNode().getValue(RequisitionOrderLight.class)).getState() == OrderStateE.CLOSED) {
                return false;
            }
            if (((RequisitionOrderLight)model.getNode().getValue(RequisitionOrderLight.class)).getState() == OrderStateE.CANCELLED) {
                return false;
            }
        }
        if (screen.getInvokingName().equals(RequisitionOrderAccess.PRINT_REQUISITION.getIdentifier())) {
            return true;
        }
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<RequisitionOrderLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<RequisitionOrderLight> getRowEditorFactory() {
        return model -> {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            MessageProvidedRowEditor<RequisitionOrderLight> rowEditor = new MessageProvidedRowEditor<RequisitionOrderLight>(model, "Continue anyway?");
            RDProvider p = this.createProvider(model.isAddRow());
            if (model.isAddRow()) {
                ConfigurationDetailsPanel d2 = new ConfigurationDetailsPanel((RowEditor<RequisitionOrderLight>)rowEditor, p);
                CreateOrderDetailsPanel d1 = new CreateOrderDetailsPanel((RowEditor<RequisitionOrderLight>)rowEditor, p);
                TemplateDetailsPanel p1 = new TemplateDetailsPanel(rowEditor, p, d1);
                DetailsEditorParagraph p2 = null;
                int index = 0;
                rowEditor.add(p1, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
                if (p2 != null) {
                    rowEditor.add((JComponent)((Object)p2), (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
                }
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, index++, 1.0, 1.0));
                rowEditor.addToFocusQueue(p1);
                rowEditor.addToFocusQueue(d2);
                if (p2 != null) {
                    rowEditor.addToFocusQueue(p2);
                }
                rowEditor.addToFocusQueue(d1);
            } else {
                ConfigurationDetailsPanel d2 = new ConfigurationDetailsPanel((RowEditor<RequisitionOrderLight>)rowEditor, p);
                OrderPositionsDetailsPanel d1 = new OrderPositionsDetailsPanel((RowEditor<RequisitionOrderLight>)rowEditor, p);
                DeliveryGroupDetailsPanel d3 = new DeliveryGroupDetailsPanel((RowEditor<RequisitionOrderLight>)rowEditor, p);
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
                rowEditor.add(d1, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.add(d3, (Object)new TableLayoutConstraint(0, 2, 1.0, 1.0));
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new RequisitionOrderModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.DELIVER_STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.STATE, RequisitionOrderLight_.deliverState.getFieldName(), TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth, TableColumnInfo.state3WithExpandWidth));
        columns.add(new TableColumnInfo(Words.HAS_REJECTIONS, "", BooleanConverter.class, null, RequisitionOrderLight_.hasRejections, 25, 25, 25));
        columns.add(new TableColumnInfo(Words.RECEIVE_STATE, "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.STATE, RequisitionOrderLight_.receiveState.getFieldName(), TableColumnInfo.state3, TableColumnInfo.state3, TableColumnInfo.state3));
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.NUMBER, RequisitionOrderLight_.number, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.PLACED, "", (Class)DateTimeConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.PLACE_DATE, RequisitionOrderLight_.placeDate, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.SCHDULEDDELIVERY, "", (Class)DateAndTimeConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.DELIVERY, "requiredOn-requiredTime", TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.LAST_RECEIVED, "", (Class)DateTimeConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.LAST_RECEIVED, RequisitionOrderLight_.lastReceived, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.REQUIRED_BY_DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.REQUIRED_BY, RequisitionOrderLight_.requiredBy, TableColumnInfo.departmentWidth, Integer.MAX_VALUE, TableColumnInfo.departmentWidth));
        columns.add(new TableColumnInfo(Words.DELIVER_DEPARTMENT, "", CostCenterListConverter.class, null, RequisitionOrderLight_.allDeliverDepartments, TableColumnInfo.departmentWidth, Integer.MAX_VALUE, TableColumnInfo.departmentWidth));
        columns.add(new TableColumnInfo(Words.ORDERED_FOR_DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.ORDERED_FOR, RequisitionOrderLight_.orderedFor, TableColumnInfo.departmentWidth, Integer.MAX_VALUE, TableColumnInfo.departmentWidth));
        columns.add(new TableColumnInfo(Words.COMMENT, "", (Class)StringConverter.class, (Enum<?>)RequisitionOrderSearchConfiguration.REQUISITION_ORDER_COLUMN.COMMENT, RequisitionOrderLight_.remark, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.PURCHASE, "", IntegerConverter.class, null, "#generatedFromOrder-number", 100, Integer.MAX_VALUE, 100));
        columns.add(new TableColumnInfo(Words.HALAL, "", BooleanConverter.class, null, RequisitionOrderLight_.halalOrder, 25, 25, 25));
        columns.add(new TableColumnInfo(Words.INVOICED, "", BooleanConverter.class, null, RequisitionOrderLight_.invoiced, 25, 25, 25));
        return columns;
    }

    public static enum PeriodMode {
        ALL{

            public String toString() {
                return "ALL";
            }
        }
        ,
        PLACED{

            public String toString() {
                return "PLACED";
            }
        }
        ,
        SCHEDULED{

            public String toString() {
                return "DELIVERY";
            }
        }
        ,
        LAST_RECEIVED{

            public String toString() {
                return "LAST RECEIVED";
            }
        };

    }
}

