/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retailinmotion;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;

public class RetailInMotionModuleDataHandler
extends DefaultDataHandler<RetailInMotionDataImportLight, RetailInMotionDataImportComplete> {
    public RetailInMotionModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionDataImportLight group = (RetailInMotionDataImportLight)node.getValue(RetailInMotionDataImportLight.class);
                RetailInMotionDataImportComplete ngroup = (RetailInMotionDataImportComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionData(group).getValue();
                if (ngroup.getDeliveryDate() == null) {
                    ngroup.setDeliveryDate(new Date(ngroup.getCreationTime().getTime()));
                }
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<RetailInMotionDataImportLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionDataImportComplete g = (RetailInMotionDataImportComplete)node.getValue(RetailInMotionDataImportComplete.class);
                RetailInMotionDataImportComplete gn = (RetailInMotionDataImportComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).updateRetailInMotionData(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RetailInMotionDataImportComplete> createEmptyNode() {
        RetailInMotionDataImportComplete r = new RetailInMotionDataImportComplete();
        r.setCreationTime(new Timestamp(System.currentTimeMillis()));
        r.setCreationUser((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        r.setLocation((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
    }

    @Override
    public void createNewData(final Node<RetailInMotionDataImportComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionDataImportComplete g = (RetailInMotionDataImportComplete)node.getValue(RetailInMotionDataImportComplete.class);
                if (g.getLocation() == null) {
                    g.setLocation((LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                RetailInMotionDataImportComplete gn = (RetailInMotionDataImportComplete)((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).createRetailInMotionData(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RetailInMotionModuleDataHandler.this.setCurrentLoadMaximum(0);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return RetailInMotionModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<RetailInMotionDataImportComplete> resetData(Node<RetailInMotionDataImportComplete> node) {
        RetailInMotionDataImportComplete n = new RetailInMotionDataImportComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<RetailInMotionDataImportComplete> getCommittingClass() {
        return RetailInMotionDataImportComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<RetailInMotionDataImportLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

