/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.safetystock.details;

import ch.icit.pegasus.client.converter.SafetyStockStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockLight_;
import ch.icit.pegasus.server.core.dtos.ordering.safetystock.SafetyStockStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<SafetyStockLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDTextField> name;
    private TitledItem<RDComboBox> state;
    private TitledPeriodEditor calculationPeriod;
    private TitledItem<RDMultiLocationComboBox> location;

    public SpecificationDetailsPanel(RowEditor<SafetyStockLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.state = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(SafetyStockStateEConverter.class)), Words.STATE, TitledItem.TitledItemOrientation.NORTH);
        this.calculationPeriod = new TitledPeriodEditor(null, null, true, provider);
        this.calculationPeriod.getStartDateChooser().setOverrideName(SafetyStockComplete_.articles);
        this.calculationPeriod.getEndDateChooser().setOverrideName(SafetyStockComplete_.articles);
        this.calculationPeriod.getEndDateChooser().setCheckBoxEnabled();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.location = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.name);
        this.addToView(this.state);
        this.addToView(this.calculationPeriod);
        if (this.location != null) {
            this.addToView(this.location);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.number.getElement().setNode(node.getChildNamed(SafetyStockLight_.number));
        this.name.getElement().setNode(node.getChildNamed(SafetyStockLight_.name));
        this.state.getElement().refreshPossibleValues(NodeToolkit.getAffixList(SafetyStockStateE.class));
        this.state.getElement().setNode(node.getChildNamed(SafetyStockLight_.safetyStockState));
        this.calculationPeriod.setNode((Node<PeriodComplete>)node.getChildNamed(SafetyStockLight_.calculationPeriod));
        if (this.location != null) {
            this.location.getElement().setNode(node.getChildNamed(SafetyStockLight_.eligibleLocations));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.state);
        CheckedListAdder.addToList(focusList, this.calculationPeriod);
        CheckedListAdder.addToList(focusList, this.location);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        String n = (String)this.editor.getModel().getNode().getChildNamed(SafetyStockLight_.name).getValue();
        if (n == null || n.isEmpty()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean fixed = false;
        try {
            SafetyStockStateE value = (SafetyStockStateE)this.editor.getModel().getNode().getChildNamed(SafetyStockLight_.safetyStockState).getValue();
            switch (value) {
                case CALCULATED: 
                case PLANNED: {
                    fixed = false;
                    break;
                }
                case ACCEPTED: {
                    fixed = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.name.setEnabled(isEnabled && !fixed);
        this.number.setEnabled(isEnabled && !fixed);
        this.state.setEnabled(isEnabled && !fixed);
        if (this.location != null) {
            this.location.setEnabled(isEnabled && !fixed);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.number = null;
        this.name.kill();
        this.name = null;
        this.state.kill();
        this.state = null;
        this.calculationPeriod.kill();
        this.calculationPeriod = null;
        if (this.location != null) {
            this.location.kill();
        }
        this.location = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.number.setSize(80, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.number.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.name.getX()), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.state.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.state.setSize(180, (int)SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.calculationPeriod.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.state.getY() + SpecificationDetailsPanel.this.state.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.calculationPeriod.setSize(SpecificationDetailsPanel.this.calculationPeriod.getPreferredSize());
            if (SpecificationDetailsPanel.this.location != null) {
                SpecificationDetailsPanel.this.location.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.calculationPeriod.getY() + SpecificationDetailsPanel.this.calculationPeriod.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.location.setSize(SpecificationDetailsPanel.this.location.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.state.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.calculationPeriod.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (SpecificationDetailsPanel.this.location != null) {
                h = (int)((double)h + SpecificationDetailsPanel.this.location.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }
    }
}

