/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.NoProExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete_;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ServiceProductSpecificationDetailsPanel
extends StateDependantDetailsPanel<ServiceProductComplete>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> number;
    private TitledItem<RDSearchTextField2> customer;
    private TitledPeriodEditor period;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDCheckBox> hourlyWork;
    private TitledItem<RDCheckBox> fixWork;

    public ServiceProductSpecificationDetailsPanel(RowEditor<ServiceProductComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.hourlyWork = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.HOURLY_WORK, TitledItem.TitledItemOrientation.EAST);
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER, true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)n, true, provider, ServiceProductComplete_.period);
        this.period.enableInfinity(false, true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.fixWork = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.FIX_WORK, TitledItem.TitledItemOrientation.EAST);
        this.setCustomLayouter(new Layout());
        this.addToView(this.number);
        this.addToView(this.customer);
        this.addToView(this.period);
        this.addToView(this.hourlyWork);
        this.addToView(this.fixWork);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ServiceProductVariantComplete_.state;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && this.customer.getElement().getNode().getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.CUSTOMER_NOT_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.AT_LEAST_ONE_LOCATION_MUST_BE_SET));
        }
        if (this.fixWork.getElement().isChecked() && this.hourlyWork.getElement().isChecked()) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure only 'Fix Work' or 'Hourly Work' is selected (not both)"));
        }
        validationObjects.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{ServiceProductComplete_.period, PeriodComplete_.endDate}), this.period));
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isEnabled && isDraft;
        super.setEnabled(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
        this.number.setEnabled(b);
        this.customer.setEnabled(b);
        this.period.setEnabled(isEnabled);
        this.hourlyWork.setEnabled(isEnabled);
        this.fixWork.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.number.kill();
        this.customer.kill();
        this.period.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.hourlyWork.kill();
        this.fixWork.kill();
        this.number = null;
        this.customer = null;
        this.period = null;
        this.locations = null;
        this.hourlyWork = null;
        this.fixWork = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.customer.getElement());
        CheckedListAdder.addToList(focusList, this.period);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.hourlyWork);
        CheckedListAdder.addToList(focusList, this.fixWork);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        boolean isNoPro;
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            ServiceProductComplete dto = (ServiceProductComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.eligibleLocations}));
        }
        if ((isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings)) && this.editor.getModel().isAddRow()) {
            NoProExchangeSettingsComplete noProSettings = (NoProExchangeSettingsComplete)NodeToolkit.getAffixClass(NoProExchangeSettingsComplete.class).getValue();
            Node<?> n = node;
            n.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.customer}).setValue((Object)noProSettings.getNoProAsCustomer(), 0L);
        }
        this.customer.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.customer}));
        this.number.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.number}));
        this.period.setStartDateNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.period, PeriodComplete_.startDate}));
        this.period.setEndDateNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.period, PeriodComplete_.endDate}));
        this.hourlyWork.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.hourlyWork}));
        this.fixWork.getElement().setNode(node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.serviceProduct, ServiceProductComplete_.fixWork}));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.editor.setEnabled(this.editor.isEnabled());
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ServiceProductSpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ServiceProductSpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(ServiceProductSpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h += ServiceProductSpecificationDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + ServiceProductSpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
            } else {
                h += ServiceProductSpecificationDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + ServiceProductSpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            }
            return new Dimension(0, h += ServiceProductSpecificationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 3 * ServiceProductSpecificationDetailsPanel.this.horizontalBorder) / 2;
            ServiceProductSpecificationDetailsPanel.this.number.setLocation(ServiceProductSpecificationDetailsPanel.this.horizontalBorder, ServiceProductSpecificationDetailsPanel.this.verticalBorder);
            ServiceProductSpecificationDetailsPanel.this.number.setSize(80, (int)ServiceProductSpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            ServiceProductSpecificationDetailsPanel.this.customer.setLocation(ServiceProductSpecificationDetailsPanel.this.number.getX() + ServiceProductSpecificationDetailsPanel.this.number.getWidth() + ServiceProductSpecificationDetailsPanel.this.inner_horizontalBorder, ServiceProductSpecificationDetailsPanel.this.verticalBorder);
            ServiceProductSpecificationDetailsPanel.this.customer.setSize(w2tl, (int)ServiceProductSpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            ServiceProductSpecificationDetailsPanel.this.period.setLocation(ServiceProductSpecificationDetailsPanel.this.horizontalBorder, ServiceProductSpecificationDetailsPanel.this.number.getY() + ServiceProductSpecificationDetailsPanel.this.number.getHeight() + ServiceProductSpecificationDetailsPanel.this.inner_verticalBorder);
            ServiceProductSpecificationDetailsPanel.this.period.setSize(ServiceProductSpecificationDetailsPanel.this.period.getPreferredSize());
            ServiceProductSpecificationDetailsPanel.this.hourlyWork.setLocation(ServiceProductSpecificationDetailsPanel.this.period.getX() + ServiceProductSpecificationDetailsPanel.this.period.getWidth() + ServiceProductSpecificationDetailsPanel.this.horizontalBorder, (int)((double)(ServiceProductSpecificationDetailsPanel.this.period.getY() + ServiceProductSpecificationDetailsPanel.this.period.getHeight()) - ServiceProductSpecificationDetailsPanel.this.hourlyWork.getPreferredSize().getHeight()));
            ServiceProductSpecificationDetailsPanel.this.hourlyWork.setSize(ServiceProductSpecificationDetailsPanel.this.hourlyWork.getPreferredSize());
            ServiceProductSpecificationDetailsPanel.this.fixWork.setLocation(ServiceProductSpecificationDetailsPanel.this.hourlyWork.getX() + ServiceProductSpecificationDetailsPanel.this.hourlyWork.getWidth() + ServiceProductSpecificationDetailsPanel.this.horizontalBorder, (int)((double)(ServiceProductSpecificationDetailsPanel.this.period.getY() + ServiceProductSpecificationDetailsPanel.this.period.getHeight()) - ServiceProductSpecificationDetailsPanel.this.fixWork.getPreferredSize().getHeight()));
            ServiceProductSpecificationDetailsPanel.this.fixWork.setSize(ServiceProductSpecificationDetailsPanel.this.fixWork.getPreferredSize());
            if (Boolean.TRUE.equals(ServiceProductSpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                ServiceProductSpecificationDetailsPanel.this.locations.setLocation(ServiceProductSpecificationDetailsPanel.this.period.getX() + ServiceProductSpecificationDetailsPanel.this.period.getWidth() + ServiceProductSpecificationDetailsPanel.this.inner_horizontalBorder, ServiceProductSpecificationDetailsPanel.this.number.getY() + ServiceProductSpecificationDetailsPanel.this.number.getHeight() + ServiceProductSpecificationDetailsPanel.this.inner_verticalBorder);
                ServiceProductSpecificationDetailsPanel.this.locations.setSize(ServiceProductSpecificationDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

