/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details.utils;

import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class Loader
implements LoadingGroup,
RemoteLoader {
    private List<ReloadablePriceView> taxCosts = new ArrayList<ReloadablePriceView>();
    private BlockingQueue<ReloadablePriceView> queue = new LinkedBlockingQueue<ReloadablePriceView>();
    private boolean isRunning;
    private Component c;

    public Loader(Component c) {
        this.c = c;
    }

    public void addTaxCosts(ReloadablePriceView r) {
        this.taxCosts.add(r);
    }

    public void updateAll() {
        for (ReloadablePriceView r : this.taxCosts) {
            this.updateMe(r);
        }
    }

    private void runMe() {
        if (this.isRunning) {
            return;
        }
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                while (!Loader.this.queue.isEmpty()) {
                    ReloadablePriceView r = (ReloadablePriceView)Loader.this.queue.poll();
                    CalculationRunnable runing = r.getCurrentRunnable();
                    if (runing != null && runing.isAlive()) {
                        runing.run();
                        r.loaded();
                        continue;
                    }
                    r.loaded();
                }
                Loader.this.isRunning = false;
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return Loader.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        this.isRunning = true;
        ThreadSafeLoader.run(run);
    }

    @Override
    public void updateMe(ReloadablePriceView rpv) {
        this.queue.add(rpv);
        this.runMe();
    }

    public void remoteObjectLoaded(Node<?> node) {
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)exception, this.c);
    }
}

