/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stowinglist.details.utils;

import ch.icit.pegasus.client.converter.StowagePositionIdentifierConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.panels.MappingTable2D;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.ScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.AircraftServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.MapWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SwitchAircraftPopup
extends ScrollablePrintPopupInsert
implements AnimationListener,
SearchTextField2Listener {
    private static final long serialVersionUID = 1L;
    private TitledItem<TextLabel> stowingList;
    private TitledItem<SearchTextField2> aircraft;
    private HorizontalSeparator sep1;
    private TitledItem<MappingTable2D<StowagePositionIdentifier, StowagePositionIdentifier>> mapping;
    protected Map<StowagePositionIdentifier, StowagePositionIdentifier> defaultMapping;
    private TextButton validateButton;
    private final Node stowing;
    private Node aircraftNode;
    private static final int STATE_LOAD_STOWING = 3;
    private static final int STATE_DO_MAPPING = 5;
    private static final int STATE_ERROR = 7;
    private String errorMsg = "";
    private final String copyMsg = "";
    private boolean isLoading = false;
    private int currentState = 0;

    public SwitchAircraftPopup(Node<StowingListTemplateVariantLight> currentStowing) {
        this.stowing = currentStowing;
        this.addInnerComponents();
    }

    private void addInnerComponents() {
        this.getViewContainer().setLayout(new Layout());
        this.stowingList = new TitledItem<TextLabel>(new TextLabel(this.stowing, ConverterRegistry.getConverter(StowingListNameConverter.class)), "Stowing List to update", TitledItem.TitledItemOrientation.NORTH);
        this.aircraft = new TitledItem<SearchTextField2<AircraftLight>>(SearchTextField2Factory.getAircraftSearchField(false, new DTOProxyNode()), "New Prototyp Aircraft", TitledItem.TitledItemOrientation.NORTH);
        this.aircraft.getElement().addSearchTextFieldListener(this);
        this.sep1 = new HorizontalSeparator();
        this.validateButton = new TextButton("Validate");
        this.validateButton.addButtonListener(new ButtonListener(){

            @Override
            public void buttonPressed(Button source, int x, int y) {
                SwitchAircraftPopup.this.showValidation();
            }
        });
        this.mapping = new TitledItem<2>(new MappingTable2D<StowagePositionIdentifier, StowagePositionIdentifier>(StowagePositionIdentifierConverter.class, StowagePositionIdentifierConverter.class, "Equipment (from Stowing List)", "is loaded on (from Aircraft)", null, null){
            private static final long serialVersionUID = 1L;

            @Override
            public void findSelection(Node<StowagePositionIdentifier> currentNode, String text, List<Node<StowagePositionIdentifier>> mappingList, TextLabel currentCombo, List<Node<StowagePositionIdentifier>> sources) {
                StowagePositionIdentifier currentGroup = (StowagePositionIdentifier)currentNode.getValue();
                if (SwitchAircraftPopup.this.defaultMapping != null) {
                    StowagePositionIdentifier r = SwitchAircraftPopup.this.defaultMapping.get(currentNode.getValue());
                    if (r != null) {
                        Node id = INodeCreator.getDefaultImpl().getNode4DTO((Object)r, false, false);
                        currentCombo.setNode(id);
                    }
                } else {
                    for (Node<StowagePositionIdentifier> n : mappingList) {
                        StowagePositionIdentifier posID = (StowagePositionIdentifier)n.getValue();
                        if (!posID.getGalleyCode().equals(currentGroup.getGalleyCode()) || !posID.getPositionCode().equals(currentGroup.getPositionCode())) continue;
                        if (posID.getIsHold() && currentGroup.getIsHold()) {
                            currentCombo.setNode((Node)n);
                            return;
                        }
                        if (posID.getIsHold() || currentGroup.getIsHold()) continue;
                        currentCombo.setNode((Node)n);
                        return;
                    }
                }
            }
        }, "Stowage Mapping", TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add((Component)this.stowingList, -1);
        this.getViewContainer().add((Component)this.aircraft, -1);
        this.getViewContainer().add((Component)this.sep1, -1);
        this.getViewContainer().add((Component)this.mapping, -1);
        this.getViewContainer().add(this.validateButton);
    }

    private void showValidation() {
        Map<StowagePositionIdentifier, StowagePositionIdentifier> m;
        final Map<StowagePositionIdentifier, StowagePositionIdentifier> t = m = this.mapping.getElement().getInvertedMappingTable();
        Map<StowagePositionIdentifier, StowagePositionIdentifier> t2 = m;
        if (this.stowing.getValue() instanceof StowingListTemplateVariantLight) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    Map v = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).validateMapping((StowingListTemplateVariantReference)SwitchAircraftPopup.this.stowing.getValue(StowingListTemplateVariantLight.class), (AircraftReference)((AircraftLight)SwitchAircraftPopup.this.aircraftNode.getValue()), new MapWrapper(t)).getMap();
                    ViewNode node = new ViewNode("mappingValidation");
                    node.setValue((Object)v, 0L);
                    return node;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            Map v = (Map)node.getValue();
                            if (v.isEmpty()) {
                                InnerPopupFactory.showMessage("Mapping", "Mapping is ok", null, SwitchAircraftPopup.this);
                            } else {
                                ScreenValidationList errors = new ScreenValidationList();
                                for (StowagePositionIdentifier key : v.keySet()) {
                                    if (key.getGalleyCode() == null) continue;
                                    String s = key.getGalleyCode() + " - " + key.getPositionCode() + " (" + (key.getIsHold() ? "HOLD" : "CABINE") + "): " + (String)v.get(key);
                                    errors.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, s));
                                }
                                InnerPopupFactory.showErrorDialog((List<ScreenValidationObject>)errors, "Mapping not ok", (Component)SwitchAircraftPopup.this);
                            }
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog("Mapping not ok", exception.getMessage(), (Component)SwitchAircraftPopup.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        this.popup.enableOKButton(false);
    }

    @Override
    protected String getFinishedText() {
        if (this.currentState == 7) {
            return this.errorMsg;
        }
        if ("" != null && !"".trim().equals("")) {
            return "";
        }
        return "Aircraft successfully switched";
    }

    @Override
    protected String getProgressText() {
        if (this.currentState == 3) {
            return Words.LOAD_STOWING_LIST_AND_AIRCRAFT;
        }
        return Words.UPDATE_STOWING_LIST;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.aircraft != null) {
            this.aircraft.setEnabled(isEnabled);
        }
        if (this.stowingList != null) {
            this.stowingList.setEnabled(isEnabled);
        }
        if (this.mapping != null) {
            this.mapping.setEnabled(isEnabled);
        }
        if (this.sep1 != null) {
            this.sep1.setEnabled(isEnabled);
        }
    }

    private void createMapping(List<StowagePositionIdentifier> poses) {
        this.setEnabled(false);
        this.ensureAnimation("Init Components");
        ArrayList sourceList = new ArrayList();
        ArrayList destinationList = new ArrayList();
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        for (StowagePositionIdentifier pose : poses) {
            if (this.isKilled()) {
                return;
            }
            StowagePositionIdentifier g = pose;
            Node p1 = new Node();
            p1.setValue((Object)g, 0L);
            sourceList.add(p1);
        }
        for (StowagePositionIdentifier spi : this.defaultMapping.keySet()) {
            destinationList.add(INodeCreator.getDefaultImpl().getNode4DTO((Object)spi, false, false));
        }
        this.mapping.getElement().setData(destinationList, sourceList);
        this.mapping.getElement().startDownload();
    }

    @Override
    public void removeInheritedComponents() {
        this.stowingList.setVisible(false);
        this.aircraft.setVisible(false);
        this.mapping.setVisible(false);
        this.sep1.setVisible(false);
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.mapping != null) {
            return this.mapping.getFocusComponents();
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.stowingList != null) {
            this.stowingList.kill();
        }
        if (this.aircraft != null) {
            this.aircraft.kill();
        }
        if (this.mapping != null) {
            this.mapping.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        this.stowingList = null;
        this.aircraft = null;
        this.mapping = null;
        this.sep1 = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.OK_FOREGROUND) {
            return new Object[0];
        }
        return null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.mapping != null) {
            return this.mapping.getElement().isInnerComponent(c);
        }
        return false;
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    protected void startPrinting() {
        Map<StowagePositionIdentifier, StowagePositionIdentifier> m;
        this.isLoading = true;
        if (this.isKilled()) {
            return;
        }
        final Map<StowagePositionIdentifier, StowagePositionIdentifier> t = m = this.mapping.getElement().getInvertedMappingTable();
        final Map<StowagePositionIdentifier, StowagePositionIdentifier> t2 = m;
        super.startPrinting();
        this.validateButton.setVisible(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ScreenValidationList errors = new ScreenValidationList();
                if (SwitchAircraftPopup.this.stowing.getValue() instanceof StowingListTemplateVariantLight) {
                    Map v = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).validateMapping((StowingListTemplateVariantReference)SwitchAircraftPopup.this.stowing.getValue(StowingListTemplateVariantLight.class), (AircraftReference)((AircraftLight)SwitchAircraftPopup.this.aircraftNode.getValue()), new MapWrapper(t)).getMap();
                    StowingListTemplateVariantLight l = (StowingListTemplateVariantLight)SwitchAircraftPopup.this.stowing.getValue(StowingListTemplateVariantLight.class);
                    if (v.isEmpty()) {
                        StowingListTemplateVariantLight a = ((AircraftServiceManager)ServiceManagerRegistry.getService(AircraftServiceManager.class)).switchAircraft((StowingListTemplateVariantReference)SwitchAircraftPopup.this.stowing.getValue(StowingListTemplateVariantReference.class), (AircraftLight)SwitchAircraftPopup.this.aircraftNode.getValue(), t2);
                        SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.aircraft).removeExistingValues();
                        SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.aircraft).setValue((Object)a.getAircraft(), 0L);
                        SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.seatConfigurations).updateNode();
                        SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.loadConfigurations).setValue((Object)a.getLoadConfigurations(), 0L);
                        SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.loadConfigurations).updateNode();
                        for (SeatConfigurationComplete sc : a.getSeatConfigurations()) {
                            Node scn = INodeCreator.getDefaultImpl().getNode4DTO((Object)sc, true, false);
                            SwitchAircraftPopup.this.stowing.getChildNamed(StowingListTemplateVariantLight_.seatConfigurations).addChild(scn, 0L);
                        }
                        l.setSeatConfigurations(a.getSeatConfigurations());
                    } else {
                        for (StowagePositionIdentifier key : v.keySet()) {
                            if (key.getGalleyCode() == null) continue;
                            String s = "<li>";
                            s = s + key.getGalleyCode() + " - " + key.getPositionCode() + " (" + (key.getIsHold() ? "HOLD" : "CABINE") + "): " + (String)v.get(key);
                            s = s + "</li>";
                            errors.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, s));
                        }
                    }
                }
                if (!errors.isEmpty()) {
                    SwitchAircraftPopup.this.currentState = 7;
                    throw new ClientExceptionCollection("Unable to update Aircraft", errors);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SwitchAircraftPopup.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void animationFinished(boolean wasFadin) {
        this.removeAnimation(false);
        this.setEnabled(true);
        this.getViewContainer().add(this.mapping);
        this.mapping.fadeIn();
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.isError = true;
        this.errorMSG = exception.getMessage();
        this.removeAnimation(true);
    }

    public void newValueSelected(SearchTextField2 source, final Node n) {
        this.setEnabled(false);
        this.ensureAnimation("Load Aircraft");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                long id = 0L;
                if (SwitchAircraftPopup.this.stowing.getValue() instanceof StowingListTemplateVariantReference) {
                    id = ((StowingListTemplateVariantReference)SwitchAircraftPopup.this.stowing.getValue()).getId();
                } else if (SwitchAircraftPopup.this.stowing.getValue() instanceof StowingListReference) {
                    id = ((StowingListReference)SwitchAircraftPopup.this.stowing.getValue()).getId();
                }
                AircraftLight r = (AircraftLight)n.getValue(AircraftLight.class);
                List poses = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getTargetPositions((AircraftReference)r).getList();
                Map m = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getDefaultPositionMapping(new StowingListTemplateVariantReference(Long.valueOf(id)), new AircraftReference(r.getId())).getMap();
                SwitchAircraftPopup.this.aircraftNode = n;
                SwitchAircraftPopup.this.defaultMapping = m;
                Node l = INodeCreator.getDefaultImpl().createNodes(poses, false);
                return l;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        try {
                            SwitchAircraftPopup.this.createMapping((List)node.getValue());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        SwitchAircraftPopup.this.removeAnimation(false);
                        SwitchAircraftPopup.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        SwitchAircraftPopup.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            SwitchAircraftPopup.this.layoutInheritedComponents(parent);
            int border = 5;
            if (SwitchAircraftPopup.this.stowingList != null) {
                SwitchAircraftPopup.this.stowingList.setLocation(0, 0);
                SwitchAircraftPopup.this.stowingList.setSize(parent.getWidth() - border, (int)SwitchAircraftPopup.this.stowingList.getPreferredSize().getHeight());
                SwitchAircraftPopup.this.aircraft.setLocation(0, SwitchAircraftPopup.this.stowingList.getY() + SwitchAircraftPopup.this.stowingList.getHeight() + border);
                SwitchAircraftPopup.this.aircraft.setSize(parent.getWidth() - border, (int)SwitchAircraftPopup.this.aircraft.getPreferredSize().getHeight());
                SwitchAircraftPopup.this.sep1.setLocation(0, SwitchAircraftPopup.this.aircraft.getY() + SwitchAircraftPopup.this.aircraft.getHeight() + border);
                SwitchAircraftPopup.this.sep1.setSize(parent.getWidth() - border, (int)SwitchAircraftPopup.this.sep1.getPreferredSize().getHeight());
                if (SwitchAircraftPopup.this.mapping != null) {
                    SwitchAircraftPopup.this.mapping.setLocation(0, SwitchAircraftPopup.this.sep1.getY() + SwitchAircraftPopup.this.sep1.getHeight() + border);
                    SwitchAircraftPopup.this.mapping.setSize(parent.getWidth() - border, (int)SwitchAircraftPopup.this.mapping.getPreferredSize().getHeight());
                    SwitchAircraftPopup.this.validateButton.setLocation(0, SwitchAircraftPopup.this.mapping.getY() + SwitchAircraftPopup.this.mapping.getHeight() + border);
                    SwitchAircraftPopup.this.validateButton.setSize(SwitchAircraftPopup.this.validateButton.getPreferredSize());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 5;
            int h = 0;
            if (SwitchAircraftPopup.this.stowingList != null && !SwitchAircraftPopup.this.isLoading) {
                h = (int)SwitchAircraftPopup.this.stowingList.getPreferredSize().getHeight();
                h += border;
                h = (int)((double)h + SwitchAircraftPopup.this.aircraft.getPreferredSize().getHeight());
                h += border;
                h = (int)((double)h + SwitchAircraftPopup.this.sep1.getPreferredSize().getHeight());
                h += border;
                if (SwitchAircraftPopup.this.mapping != null) {
                    h = (int)((double)h + SwitchAircraftPopup.this.mapping.getPreferredSize().getHeight());
                    h += border;
                }
                h = (int)((double)h + SwitchAircraftPopup.this.validateButton.getPreferredSize().getHeight());
                h += border;
            } else {
                h = border;
                if (SwitchAircraftPopup.this.animation != null) {
                    h = (int)((double)h + SwitchAircraftPopup.this.animation.getPreferredSize().getHeight());
                }
                h += border;
            }
            int th = 0;
            if (SwitchAircraftPopup.this.msg != null) {
                th = (int)SwitchAircraftPopup.this.msg.getPreferredSize().getHeight();
            }
            return new Dimension(0, Math.max(h, th));
        }
    }
}

