/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.template.purchaseorder;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.template.purchaseorder.PurchaseTemplateModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.template.purchaseorder.details.ConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.template.purchaseorder.details.OrderPositionDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.PurchaseOrderTemplateSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateLight;
import ch.icit.pegasus.server.core.dtos.ordering.template.PurchaseOrderTemplateLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderTemplateAccess;
import ch.icit.pegasus.server.core.dtos.search.PurchaseOrderTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class PurchaseTemplateModule
extends ScreenTableView<PurchaseOrderTemplateLight, PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "Name";
    private static final String FILTER_DEPARTMENT = "CostCenter";
    private static final String FILTER_SUPPLIER = "Supplier";
    private ComboBox departmentComboBox;
    private String filterCriteria1;
    private SupplierLight filterCriteria2;
    private CostCenterComplete filterCriteria3;

    public PurchaseTemplateModule() {
        super(PurchaseOrderTemplateLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.departmentComboBox.kill();
        this.departmentComboBox = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return PurchaseOrderTemplateAccess.MODULE_PURCHASE_TEMPLATE;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.NAME + "<>" + false);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME, Words.NAME, "");
        this.departmentComboBox = new ComboBox(null, null, ConverterRegistry.getConverter(CostCenterConverter.class));
        this.filterChain.addSelectionComboBox(this.departmentComboBox, 180, FILTER_DEPARTMENT, Words.DEPARTMENT, Words.ALL);
        this.filterChain.addSupplierSearchField(FILTER_SUPPLIER);
        this.filterChain.addResetButton();
        this.isAsc = false;
        this.currentColumnAttribute = PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.NAME;
    }

    @Override
    public ASearchConfiguration<PurchaseOrderTemplateLight, PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria3 = null;
        } else if (name == FILTER_NAME) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_DEPARTMENT) {
            this.filterCriteria3 = value instanceof Node ? (CostCenterComplete)((Node)value).getValue() : (value instanceof CostCenterComplete ? (CostCenterComplete)value : null);
        } else if (name == FILTER_SUPPLIER) {
            this.filterCriteria2 = value instanceof Node ? (SupplierLight)((Node)value).getValue() : (value instanceof SupplierLight ? (SupplierLight)value : null);
        }
        PurchaseOrderTemplateSearchConfiguration c = new PurchaseOrderTemplateSearchConfiguration();
        c.setCostCenter(this.filterCriteria3);
        c.setName(this.filterCriteria1);
        c.setSupplier(this.filterCriteria2);
        c.setNumResults(this.numberOfShownResults);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.departmentComboBox.refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.departmentComboBox.addItem(Words.ALL);
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<PurchaseOrderTemplateLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(PurchaseOrderTemplateSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<PurchaseOrderTemplateLight> model) {
        return true;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.ONE;
    }

    @Override
    protected RowEditorFactory<PurchaseOrderTemplateLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor rowEditor = new MessageProvidedRowEditor(model, "");
            RDProvider p1 = this.createProvider(model.isAddRow());
            OrderPositionDetailsPanel<PurchaseOrderTemplateLight> p2 = new OrderPositionDetailsPanel<PurchaseOrderTemplateLight>(rowEditor, p1){

                @Override
                public boolean isWithoutAmount() {
                    return false;
                }

                @Override
                public boolean isWithPosition() {
                    return false;
                }
            };
            ConfigurationDetailsPanel p = new ConfigurationDetailsPanel(rowEditor, p1, true, true, p2);
            p2.setConfigurationPanel(p);
            rowEditor.add(p, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(p2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.addToFocusQueue(p);
            rowEditor.addToFocusQueue(p2);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new PurchaseTemplateModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.NAME, PurchaseOrderTemplateLight_.name, 100, Integer.MAX_VALUE, 100));
        info.add(new TableColumnInfo(Words.DEPARTMENT, "", (Class)CostCenterConverter.class, (Enum<?>)PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.COST_CENTER, PurchaseOrderTemplateLight_.costCenter, 100, 200, 100));
        info.add(new TableColumnInfo(Words.SUPPLIER, "", (Class)SupplierConverter.class, (Enum<?>)PurchaseOrderTemplateSearchConfiguration.PURCHASE_ORDER_TEMPLATE_COLUMN.SUPPLIER, PurchaseOrderTemplateLight_.supplier, 100, 200, 100));
        return info;
    }
}

