/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details;

import ch.icit.pegasus.client.converter.IntegerDividedByTwoConverter;
import ch.icit.pegasus.client.converter.LocationConverter;
import ch.icit.pegasus.client.converter.UserTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.useradmin.details.ContactDetailsPanel;
import ch.icit.pegasus.client.gui.modules.useradmin.details.ModuleRightsDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiDepartmentComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight_;
import ch.icit.pegasus.server.core.dtos.restaurant.RestaurantDeliverySettingsComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.UserManagementAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class BasicDetailsPanel
extends DefaultDetailsPanel<UserLight>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> type;
    private TitledItem<Component> userName;
    private TextButton changePassword;
    private TitledItem<RDCheckBox> mobileUser;
    private TitledItem<RDCheckBox> driverUser;
    private TitledItem<RDMultiDepartmentComboBox> departments;
    private TitledItem<ComboBox> currentLocation;
    private TitledItem<RDComboBox> defaultLocation;
    private TitledItem<TextField> pw1;
    private TitledItem<TextField> pw2;
    private TitledItem<TextLabel> incorrectLogins;
    private TextButton resetIncorrectLogins;
    private TitledItem<RDSearchTextField2<CustomerLight>> associatedCustomer;
    private TitledItem<RDCheckBox> restaurantUser;
    private TitledItem<RDTextField> comment;
    private boolean canChangePW;
    private boolean resetFailedLoginAttempts;
    private ModuleRightsDetailsPanel rightPanel;
    private ContactDetailsPanel contactPanel;

    public BasicDetailsPanel(RowEditor<UserLight> editor, RDProvider provider, ModuleRightsDetailsPanel rightsDetailsPanel, ContactDetailsPanel contactDetailsPanel) {
        super(editor, provider);
        RestaurantDeliverySettingsComplete restaurantSettings;
        this.rightPanel = rightsDetailsPanel;
        this.contactPanel = contactDetailsPanel;
        this.setTitleText(Words.BASIC_DATA);
        this.canChangePW = provider.isWritable(UserManagementAccess.PASSWORD);
        this.resetFailedLoginAttempts = provider.isWritable(UserManagementAccess.RESET_INCORRECT_LOGIN_ATTEMPTS);
        this.currentLocation = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(LocationConverter.class), false, true), Words.CURRENT_LOCATION, TitledItem.TitledItemOrientation.NORTH);
        this.currentLocation.getElement().addItemListener(this);
        this.defaultLocation = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(LocationConverter.class)), Words.USER_S_HOME_BASE, TitledItem.TitledItemOrientation.NORTH);
        if (editor.getModel().getNode().getValue().equals(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser())) {
            this.canChangePW = true;
        }
        this.userName = new TitledItem<TextField>(new TextField(), Words.USERNAME, TitledItem.TitledItemOrientation.NORTH);
        this.type = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(UserTypeConverter.class)), Words.USER_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.type.getElement().addItemListener(this);
        if (editor.getModel().isAddRow()) {
            this.pw1 = new TitledItem<TextField>(new TextField(), Words.PASSWORD, TitledItem.TitledItemOrientation.WEST);
            this.pw2 = new TitledItem<TextField>(new TextField(), Words.PASSWORD, TitledItem.TitledItemOrientation.WEST);
        } else if (this.canChangePW) {
            this.changePassword = new TextButton(Words.CHANGE_PASSWORD);
            this.changePassword.addButtonListener((source, x, y) -> InnerPopupFactory.showPasswordChangePopup(this.changePassword, (source1, xargs) -> {}, (UserComplete)editor.getModel().getNode().getValue(UserComplete.class), false));
        }
        this.mobileUser = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Mobile User", TitledItem.TitledItemOrientation.EAST);
        this.driverUser = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Driver User", TitledItem.TitledItemOrientation.EAST);
        this.departments = new TitledItem<RDMultiDepartmentComboBox>(new RDMultiDepartmentComboBox(provider), "Departments", TitledItem.TitledItemOrientation.NORTH);
        this.departments.getElement().setOverrideName(UserComplete_.departments);
        if (this.resetFailedLoginAttempts) {
            this.incorrectLogins = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(IntegerDividedByTwoConverter.class)), Words.INCORRECT_LOGIN_COUNT, TitledItem.TitledItemOrientation.NORTH);
            this.resetIncorrectLogins = new TextButton(Words.RESET_INCORRECT_LOGIN_COUNT);
            this.resetIncorrectLogins.addButtonListener((source, x, y) -> this.incorrectLogins.getElement().getNode().setValue((Object)0, 0L));
        }
        if ((restaurantSettings = (RestaurantDeliverySettingsComplete)NodeToolkit.getAffixClass(RestaurantDeliverySettingsComplete.class).getValue()) != null && Boolean.TRUE.equals(restaurantSettings.getUseRestaurantDelivery())) {
            this.associatedCustomer = new TitledItem(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER, true), "Associated Customer", TitledItem.TitledItemOrientation.NORTH);
            this.restaurantUser = new TitledItem<RDCheckBox>(new RDCheckBox(provider), "Restaurant User", TitledItem.TitledItemOrientation.EAST);
        }
        this.comment = new TitledItem<RDTextField>(new RDTextField(provider), "Comment", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.userName);
        this.addToView(this.type);
        if (this.changePassword != null) {
            this.addToView(this.changePassword);
        } else {
            if (this.pw1 != null) {
                this.addToView(this.pw1);
            }
            if (this.pw2 != null) {
                this.addToView(this.pw2);
            }
        }
        this.addToView(this.departments);
        if (this.currentLocation != null) {
            this.addToView(this.currentLocation);
        }
        this.addToView(this.defaultLocation);
        if (this.incorrectLogins != null) {
            this.addToView(this.incorrectLogins);
        }
        if (this.resetIncorrectLogins != null) {
            this.addToView(this.resetIncorrectLogins);
        }
        if (this.restaurantUser != null) {
            this.addToView(this.restaurantUser);
        }
        if (this.associatedCustomer != null) {
            this.addToView(this.associatedCustomer);
        }
        this.addToView(this.comment);
        this.addToView(this.mobileUser);
        this.addToView(this.driverUser);
    }

    @Override
    public boolean isRemoteValidation() {
        return this.editor.getModel().isAddRow();
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
        boolean a;
        if (this.editor.getModel().isAddRow() && (a = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).isUsernameAssigned(((TextField)this.userName.getElement()).getText()))) {
            callBack.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.USERNAME_IS_ALREADY_IN_USE, (Object[])new Object[]{((TextField)this.userName.getElement()).getText()})));
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.changePassword);
        CheckedListAdder.addToList(focusList, this.pw1);
        CheckedListAdder.addToList(focusList, this.pw2);
        CheckedListAdder.addToList(focusList, this.departments);
        CheckedListAdder.addToList(focusList, this.currentLocation);
        CheckedListAdder.addToList(focusList, this.defaultLocation);
        CheckedListAdder.addToList(focusList, this.comment);
        CheckedListAdder.addToList(focusList, this.mobileUser);
        CheckedListAdder.addToList(focusList, this.driverUser);
        CheckedListAdder.addToList(focusList, this.incorrectLogins);
        CheckedListAdder.addToList(focusList, this.resetIncorrectLogins);
        CheckedListAdder.addToList(focusList, this.restaurantUser);
        CheckedListAdder.addToList(focusList, this.associatedCustomer);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            this.userName.requestFocusInWindowNow();
        } else if (this.changePassword != null) {
            this.changePassword.requestFocusInWindowNow();
        } else if (this.pw1 != null) {
            this.pw1.requestFocusInWindowNow();
        }
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = true;
        if (((Boolean)((Node)this.type.getElement().getSelectedItem()).getValue()).equals(Boolean.TRUE)) {
            b = false;
        }
        this.contactPanel.setEnabled(isEnabled && b);
        this.userName.setEnabled(isEnabled);
        this.type.setEnabled(isEnabled && this.editor.getModel().isAddRow());
        if (this.changePassword != null) {
            this.changePassword.setEnabled(isEnabled & this.canChangePW && b);
        } else {
            if (this.pw1 != null) {
                this.pw1.setEnabled(isEnabled && b);
            }
            if (this.pw2 != null) {
                this.pw2.setEnabled(isEnabled && b);
            }
        }
        this.departments.setEnabled(isEnabled && b);
        if (this.currentLocation != null) {
            this.currentLocation.setEnabled(isEnabled && b);
        }
        this.defaultLocation.setEnabled(isEnabled && b);
        if (this.incorrectLogins != null) {
            this.incorrectLogins.setEnabled(isEnabled && b);
        }
        if (this.resetIncorrectLogins != null) {
            this.resetIncorrectLogins.setEnabled(isEnabled && b);
        }
        if (this.restaurantUser != null) {
            this.restaurantUser.setEnabled(isEnabled && b);
        }
        if (this.associatedCustomer != null) {
            this.associatedCustomer.setEnabled(isEnabled && b);
        }
        if (this.comment != null) {
            this.comment.setEnabled(isEnabled && b);
        }
        this.mobileUser.setEnabled(isEnabled && b);
        this.driverUser.setEnabled(isEnabled && b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.userName.kill();
        if (this.changePassword != null) {
            this.changePassword.kill();
        }
        if (this.pw1 != null) {
            this.pw1.kill();
        }
        if (this.pw2 != null) {
            this.pw2.kill();
        }
        if (this.currentLocation != null) {
            this.currentLocation.kill();
        }
        this.departments.kill();
        this.defaultLocation.kill();
        if (this.incorrectLogins != null) {
            this.incorrectLogins.kill();
        }
        if (this.resetIncorrectLogins != null) {
            this.resetIncorrectLogins.kill();
        }
        if (this.associatedCustomer != null) {
            this.associatedCustomer.kill();
        }
        if (this.restaurantUser != null) {
            this.restaurantUser.kill();
        }
        if (this.comment != null) {
            this.comment.kill();
        }
        this.comment = null;
        this.mobileUser.kill();
        this.driverUser.kill();
        this.userName = null;
        this.changePassword = null;
        this.currentLocation = null;
        this.defaultLocation = null;
        this.incorrectLogins = null;
        this.resetIncorrectLogins = null;
        this.associatedCustomer = null;
        this.restaurantUser = null;
        this.mobileUser = null;
        this.driverUser = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.userName.getElement() instanceof TextField) {
            ((TextField)this.userName.getElement()).setNode(node.getChildNamed(UserLight_.userName));
        } else if (this.userName.getElement() instanceof TextLabel) {
            ((TextLabel)this.userName.getElement()).setNode(node.getChildNamed(UserLight_.userName));
        }
        if (this.pw1 != null) {
            Node pw1Node = new Node();
            pw1Node.setName(DtoFieldConstants.PWD1);
            Node pw2Node = new Node();
            pw2Node.setName(DtoFieldConstants.PWD2);
            node.addChild(pw1Node, 0L);
            node.addChild(pw2Node, 0L);
            this.pw1.getElement().setNode(pw1Node);
            this.pw2.getElement().setNode(pw2Node);
        }
        this.type.getElement().setNode(node.getChildNamed(UserLight_.isUserRole));
        ArrayList<Boolean> trueFalse = new ArrayList<Boolean>();
        trueFalse.add(Boolean.FALSE);
        trueFalse.add(Boolean.TRUE);
        this.type.getElement().refreshPossibleValues(INodeCreator.getDefaultImpl().createNodes(trueFalse, false));
        this.departments.getElement().setNode(node.getChildNamed(UserComplete_.departments));
        this.defaultLocation.getElement().refreshPossibleValues(NodeToolkit.getAffixList(LocationComplete.class));
        this.defaultLocation.getElement().setNode(node.getChildNamed(UserComplete_.defaultLocation));
        if (this.incorrectLogins != null) {
            this.incorrectLogins.getElement().setNode(node.getChildNamed(UserComplete_.counterIncorrectLogins));
        }
        if (this.currentLocation != null) {
            this.currentLocation.getElement().refreshPossibleValues(NodeToolkit.getAffixList(LocationComplete.class));
            this.itemStateChanged(new ItemEvent(this.currentLocation.getElement(), 0, this.currentLocation.getElement().getSelectedItem(), 1));
        }
        if (this.associatedCustomer != null) {
            this.associatedCustomer.getElement().setNode(node.getChildNamed(UserComplete_.associatedCustomer));
        }
        if (this.restaurantUser != null) {
            this.restaurantUser.getElement().setNode(node.getChildNamed(UserComplete_.restaurantUser));
        }
        if (this.comment != null) {
            this.comment.getElement().setNode(node.getChildNamed(UserComplete_.comment));
        }
        this.mobileUser.getElement().setNode(node.getChildNamed(UserComplete_.mobileUser));
        this.driverUser.getElement().setNode(node.getChildNamed(UserComplete_.driverUser));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().isAddRow()) {
            if (((Node)this.type.getElement().getSelectedItem()).getValue().equals(Boolean.FALSE)) {
                if (((TextField)this.userName.getElement()).getText().isEmpty()) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_USER_NAME_IS_SET));
                    ((TextField)this.userName.getElement()).setInvalid();
                }
                if (!this.pw1.getElement().getText().equals(this.pw2.getElement().getText()) || this.pw1.getElement().getText().isEmpty()) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.BOTH_PASSWORD_MUST_BE_EQUALS));
                    this.pw1.getElement().setInvalid();
                    this.pw2.getElement().setInvalid();
                }
            } else if (((TextField)this.userName.getElement()).getText().isEmpty()) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ROLE_IS_SET));
                ((TextField)this.userName.getElement()).setInvalid();
            }
        }
        return validationObjects;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.type != null && e.getSource() == this.type.getElement().getEditor() && e.getStateChange() == 1) {
            if (((Boolean)((Node)this.type.getElement().getSelectedItem()).getValue()).equals(Boolean.TRUE)) {
                this.userName.setTitleText(Words.USER_ROLE_NAME);
            } else {
                this.userName.setTitleText(Words.USERNAME);
            }
            this.setEnabled(true);
        }
        if (this.currentLocation != null && this.rightPanel != null && e.getSource() == this.currentLocation.getElement() && e.getStateChange() == 1) {
            LocationComplete l = (LocationComplete)((Node)this.currentLocation.getElement().getSelectedItem()).getValue();
            this.rightPanel.loadLocationRights((UserComplete)this.editor.getModel().getNode().getValue(UserComplete.class), l);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.userName.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.type.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            if (BasicDetailsPanel.this.changePassword != null) {
                h = (int)((double)h + BasicDetailsPanel.this.changePassword.getPreferredSize().getHeight());
            } else {
                if (BasicDetailsPanel.this.pw1 != null) {
                    h = (int)((double)h + BasicDetailsPanel.this.pw1.getPreferredSize().getHeight());
                    h += BasicDetailsPanel.this.verticalBorder;
                }
                if (BasicDetailsPanel.this.pw2 != null) {
                    h = (int)((double)h + BasicDetailsPanel.this.pw2.getPreferredSize().getHeight());
                }
            }
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.departments.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            if (BasicDetailsPanel.this.currentLocation != null) {
                h = (int)((double)h + BasicDetailsPanel.this.currentLocation.getPreferredSize().getHeight());
                h += BasicDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + BasicDetailsPanel.this.defaultLocation.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            if (BasicDetailsPanel.this.incorrectLogins != null) {
                h = (int)((double)h + BasicDetailsPanel.this.incorrectLogins.getPreferredSize().getHeight());
                h += BasicDetailsPanel.this.verticalBorder;
            }
            if (BasicDetailsPanel.this.restaurantUser != null) {
                h = (int)((double)h + BasicDetailsPanel.this.restaurantUser.getPreferredSize().getHeight());
                h += BasicDetailsPanel.this.verticalBorder;
            }
            if (BasicDetailsPanel.this.associatedCustomer != null) {
                h = (int)((double)h + BasicDetailsPanel.this.associatedCustomer.getPreferredSize().getHeight());
                h += BasicDetailsPanel.this.verticalBorder;
            }
            h = (int)((double)h + BasicDetailsPanel.this.comment.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.mobileUser.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.driverUser.getPreferredSize().getHeight());
            return new Dimension(0, h += BasicDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicDetailsPanel.this.type.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.type.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.type.getPreferredSize().getHeight());
            BasicDetailsPanel.this.userName.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.type.getY() + BasicDetailsPanel.this.type.getHeight() + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.userName.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.userName.getPreferredSize().getHeight());
            int cy = 0;
            if (BasicDetailsPanel.this.changePassword != null) {
                BasicDetailsPanel.this.changePassword.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.userName.getY() + BasicDetailsPanel.this.userName.getHeight() + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.changePassword.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.changePassword.getPreferredSize().getHeight());
                cy = BasicDetailsPanel.this.changePassword.getY() + BasicDetailsPanel.this.changePassword.getHeight();
            } else if (BasicDetailsPanel.this.pw1 != null) {
                BasicDetailsPanel.this.pw1.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.userName.getY() + BasicDetailsPanel.this.userName.getHeight() + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.pw1.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.pw1.getPreferredSize().getHeight());
                BasicDetailsPanel.this.pw2.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.pw1.getY() + BasicDetailsPanel.this.pw1.getHeight() + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.pw2.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.pw2.getPreferredSize().getHeight());
                cy = BasicDetailsPanel.this.pw2.getY() + BasicDetailsPanel.this.pw2.getHeight();
            }
            BasicDetailsPanel.this.departments.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.departments.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.departments.getPreferredSize().getHeight());
            cy = BasicDetailsPanel.this.departments.getY() + BasicDetailsPanel.this.departments.getHeight();
            if (BasicDetailsPanel.this.currentLocation != null) {
                BasicDetailsPanel.this.currentLocation.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.currentLocation.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.currentLocation.getX(), (int)BasicDetailsPanel.this.currentLocation.getPreferredSize().getHeight());
                cy = BasicDetailsPanel.this.currentLocation.getY() + BasicDetailsPanel.this.currentLocation.getHeight();
            }
            BasicDetailsPanel.this.defaultLocation.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.defaultLocation.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.defaultLocation.getX(), (int)BasicDetailsPanel.this.defaultLocation.getPreferredSize().getHeight());
            cy = BasicDetailsPanel.this.defaultLocation.getY() + BasicDetailsPanel.this.defaultLocation.getHeight();
            BasicDetailsPanel.this.comment.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.comment.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.comment.getX(), (int)BasicDetailsPanel.this.comment.getPreferredSize().getHeight());
            cy = BasicDetailsPanel.this.comment.getY() + BasicDetailsPanel.this.comment.getHeight();
            BasicDetailsPanel.this.mobileUser.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.mobileUser.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.mobileUser.getX(), (int)BasicDetailsPanel.this.mobileUser.getPreferredSize().getHeight());
            cy = BasicDetailsPanel.this.mobileUser.getY() + BasicDetailsPanel.this.mobileUser.getHeight();
            BasicDetailsPanel.this.driverUser.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.driverUser.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.driverUser.getX(), (int)BasicDetailsPanel.this.driverUser.getPreferredSize().getHeight());
            cy = BasicDetailsPanel.this.driverUser.getY() + BasicDetailsPanel.this.driverUser.getHeight();
            if (BasicDetailsPanel.this.incorrectLogins != null) {
                BasicDetailsPanel.this.incorrectLogins.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.incorrectLogins.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.incorrectLogins.getX(), (int)BasicDetailsPanel.this.incorrectLogins.getPreferredSize().getHeight());
                BasicDetailsPanel.this.resetIncorrectLogins.setLocation(21 * BasicDetailsPanel.this.horizontalBorder + 4, cy + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.resetIncorrectLogins.setSize(parent.getWidth() / 2, (int)BasicDetailsPanel.this.resetIncorrectLogins.getPreferredSize().getHeight());
                cy = BasicDetailsPanel.this.resetIncorrectLogins.getY() + BasicDetailsPanel.this.incorrectLogins.getHeight();
            }
            if (BasicDetailsPanel.this.restaurantUser != null) {
                BasicDetailsPanel.this.restaurantUser.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.restaurantUser.setSize(BasicDetailsPanel.this.restaurantUser.getPreferredSize());
                cy = BasicDetailsPanel.this.restaurantUser.getY() + BasicDetailsPanel.this.restaurantUser.getHeight();
            }
            if (BasicDetailsPanel.this.associatedCustomer != null) {
                BasicDetailsPanel.this.associatedCustomer.setLocation(BasicDetailsPanel.this.horizontalBorder, cy + BasicDetailsPanel.this.verticalBorder);
                BasicDetailsPanel.this.associatedCustomer.setSize(200, (int)BasicDetailsPanel.this.associatedCustomer.getPreferredSize().getHeight());
            }
        }
    }
}

