/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.flight.count;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCountActionComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(ImportCountActionComponent.class);
    private Node<FlightLight> flightNode;
    private File selectedFile;

    public ImportCountActionComponent(Node<FlightLight> dto) {
        super(false, false, false, false, null);
        this.flightNode = dto;
        this.setIsAutoCloseDisabled(true);
    }

    private void startLoading() {
        this.removeInheritedComponents();
        this.ensureAnimation(Words.SELECT_DATA);
        this.popup.disablePreviewButton();
        this.reportTypesLoaded = true;
        MainFrame.isTempRelease = true;
        this.selectedFile = FileChooserUtil.loadFile();
        MainFrame.isTempRelease = false;
        this.popup.setEnabled(false);
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        ThreadSafeLoader.run(this.getJob());
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.printed) {
            super.enterPressed(isOK);
        } else if (isOK == PopupAction.OK_BACKGROUND || isOK == PopupAction.OK_FOREGROUND || isOK == PopupAction.PREVIEW) {
            this.startLoading();
        } else {
            super.enterPressed(isOK);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    protected String getProgressText() {
        return Words.CONSUME;
    }

    @Override
    public String getTitleString() {
        return "Upload Count Data";
    }

    @Override
    public String getTitleValue() {
        return ((FlightLight)this.flightNode.getValue()).getOutboundCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        this.popup.repaint(32L);
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean success = true;
                if (ImportCountActionComponent.this.selectedFile != null) {
                    File f = ImportCountActionComponent.this.selectedFile;
                    ImportCountActionComponent.this.ensureAnimation(Words.PROCESS_FILE);
                    try {
                        PegasusFileComplete r = new PegasusFileComplete();
                        r.setCategory(FileCategoryE.IMPORT);
                        r.setLocalFile(f);
                        PegasusFileComplete uploaded = FileTransferUtil.upload((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[0]);
                        ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).uploadCounts(uploaded, new FlightReference(((FlightLight)ImportCountActionComponent.this.flightNode.getValue()).getId()));
                        ImportCountActionComponent.this.printed = true;
                        ImportCountActionComponent.this.removeAnimation(false, true);
                    }
                    catch (ExcelToolkitException e) {
                        ImportCountActionComponent.this.log.error(e.getMessage(), (Throwable)e);
                        ImportCountActionComponent.this.setIsAutoCloseDisabled(false);
                        InnerPopupFactory.showErrorDialog("Could not read Excel file. Ensure file is closed.", (Component)ImportCountActionComponent.this);
                    }
                    catch (Exception e) {
                        ImportCountActionComponent.this.log.error(e.getMessage(), (Throwable)e);
                        ImportCountActionComponent.this.removeAnimation(false, true);
                        ImportCountActionComponent.this.showMessage(Words.UNABLE_TO_IMPORT_DATA);
                        success = false;
                        if (ImportCountActionComponent.this.popup != null) {
                            ImportCountActionComponent.this.popup.hideCancelButton();
                            ImportCountActionComponent.this.popup.disablePreviewButton();
                            ImportCountActionComponent.this.popup.setOkButtonText(Words.CLOSE);
                            ImportCountActionComponent.this.popup.enableOKButton(true);
                            ImportCountActionComponent.this.printed = true;
                        }
                    }
                } else {
                    ImportCountActionComponent.this.removeAnimation(false, true);
                    ImportCountActionComponent.this.showMessage(Words.DATA_IMPORT_CANCELLED);
                    success = false;
                    if (ImportCountActionComponent.this.popup != null) {
                        ImportCountActionComponent.this.popup.hideCancelButton();
                        ImportCountActionComponent.this.popup.disablePreviewButton();
                        ImportCountActionComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ImportCountActionComponent.this.popup.enableOKButton(true);
                        ImportCountActionComponent.this.printed = true;
                    }
                }
                Node b = new Node();
                b.setValue((Object)success, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ImportCountActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    protected String getFinishedText() {
        return "Import successful";
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.popup.setOkNullAnyway();
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO(this.flightNode.getValue(), false, true);
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ImportCountActionComponent.this.layoutInheritedComponents(parent) + ImportCountActionComponent.this.border;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ImportCountActionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (ImportCountActionComponent.this.animation != null) {
                h = (int)((double)h + ImportCountActionComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(ImportCountActionComponent.this.border * 2) + ImportCountActionComponent.this.animation.getPreferredSize().getWidth()), h += ImportCountActionComponent.this.border);
            }
            return new Dimension(w, h);
        }
    }
}

