/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.store.validate;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.IInventoryCountImportUtil;
import ch.icit.pegasus.client.gui.submodules.tool.store.article.inventorynew.utils.InventoryCountImportUtil;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.file.FileCategoryE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.StringUtil;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateInventoryCountActionComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements IInventoryCountImportUtil {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(ValidateInventoryCountActionComponent.class);
    private Node<StoreLight> storeNode;
    private File selectedFile;
    private TitledItem<CheckBox> chargeBased;
    private Map<String, Set<Integer>> registeredArticles = new HashMap<String, Set<Integer>>();

    public ValidateInventoryCountActionComponent(Node<StoreLight> dto) {
        super(false, false, false, false, null);
        this.storeNode = dto;
        this.chargeBased = new TitledItem<CheckBox>(new CheckBox(), "Charge based", TitledItem.TitledItemOrientation.EAST);
        this.setIsAutoCloseDisabled(true);
        this.getViewContainer().add(this.chargeBased);
    }

    private void startLoading() {
        this.removeInheritedComponents();
        this.ensureAnimation(Words.SELECT_DATA);
        this.popup.disablePreviewButton();
        this.reportTypesLoaded = true;
        MainFrame.isTempRelease = true;
        this.selectedFile = FileChooserUtil.loadFile();
        MainFrame.isTempRelease = false;
        this.popup.setEnabled(false);
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        ThreadSafeLoader.run(this.getJob());
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.printed) {
            super.enterPressed(isOK);
        } else if (isOK == PopupAction.OK_BACKGROUND || isOK == PopupAction.OK_FOREGROUND || isOK == PopupAction.PREVIEW) {
            this.startLoading();
        } else {
            super.enterPressed(isOK);
        }
    }

    private void showErrorsAndDownloadExcel(List<ScreenValidationObject> validations, List<ExcelRow> excelRows) {
        this.setIsAutoCloseDisabled(false);
        validations.add(0, new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "An Excel with the faulty rows will be generated."));
        InnerPopupFactory.showErrorDialog(validations, "Import Inventory", "Unable to import", (source, xargs) -> {
            try {
                File pegFile = new InventoryCountImportUtil(this, this.chargeBased.getElement().isChecked()).createExcelWithErrors(excelRows);
                Desktop.getDesktop().open(pegFile);
            }
            catch (IOException e) {
                this.log.error("Unable to generate Excel File", (Throwable)e);
            }
        }, this);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String string = s[1];
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
    }

    @Override
    protected String getProgressText() {
        return Words.CONSUME;
    }

    @Override
    public String getTitleString() {
        return Words.STORE;
    }

    @Override
    public String getTitleValue() {
        return ((StoreLight)this.storeNode.getValue()).getCode();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void showLoadingAnimation(int current, int max) {
        this.ensureAnimation("Validating " + (int)((double)current / (double)max * 100.0) + "%");
    }

    @Override
    public boolean addToLower(ArticleChargeBatchComplete content, QuantityComplete quantityComplete) {
        Set<Integer> integers = this.registeredArticles.get(content.getPosition().getName());
        if (integers != null) {
            if (integers.contains(content.getCharge().getNumber())) {
                return false;
            }
        } else {
            integers = new HashSet<Integer>();
            this.registeredArticles.put(content.getPosition().getName(), integers);
        }
        integers.add(content.getCharge().getNumber());
        return true;
    }

    @Override
    public boolean addToLower(StorePositionContentComplete content, QuantityComplete quantityComplete) {
        Set<Integer> integers = this.registeredArticles.get(content.getStorePosition().getName());
        if (integers != null) {
            if (integers.contains(content.getArticle().getNumber())) {
                return false;
            }
        } else {
            integers = new HashSet<Integer>();
            this.registeredArticles.put(content.getStorePosition().getName(), integers);
        }
        integers.add(content.getArticle().getNumber());
        return true;
    }

    @Override
    public boolean checkForDuplicationsInLower(int artNo, InventoryCheckinComplete scc) {
        Set<Integer> integers = this.registeredArticles.get(scc.getStorePosition().getName());
        return integers == null || !integers.contains(scc.getArticle().getNumber());
    }

    @Override
    public String getDuplicationText() {
        return "Duplication";
    }

    @Override
    public ThreadSafeExecutable getJob() {
        this.popup.repaint(32L);
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean success = true;
                if (ValidateInventoryCountActionComponent.this.selectedFile != null) {
                    File f = ValidateInventoryCountActionComponent.this.selectedFile;
                    ValidateInventoryCountActionComponent.this.ensureAnimation(Words.PROCESS_FILE);
                    try {
                        StoreComplete store = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference(new StoreReference(((StoreLight)ValidateInventoryCountActionComponent.this.storeNode.getValue()).getId())).getValue();
                        List rows = ExcelToolkit.readRows((File)f, (int)0, (boolean)true);
                        rows.removeIf(excelRow -> {
                            boolean foundValue = false;
                            for (Object cell : excelRow.getCells()) {
                                if (cell == null) continue;
                                if (cell instanceof String) {
                                    if (StringUtil.isBlank((String)((String)cell))) continue;
                                    foundValue = true;
                                    continue;
                                }
                                foundValue = true;
                            }
                            return !foundValue;
                        });
                        InventoryCountImportUtil util = new InventoryCountImportUtil(ValidateInventoryCountActionComponent.this, ((CheckBox)ValidateInventoryCountActionComponent.this.chargeBased.getElement()).isChecked());
                        List<Tuple<Integer, String>> notOkList = util.importRows(rows, store);
                        if (notOkList == null || !notOkList.isEmpty()) {
                            ArrayList<ScreenValidationObject> validations = new ArrayList<ScreenValidationObject>();
                            for (Tuple<Integer, String> tuple : notOkList) {
                                validations.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Article " + tuple.getS() + ": " + (String)tuple.getT()));
                            }
                            ValidateInventoryCountActionComponent.this.showErrorsAndDownloadExcel(validations, rows);
                        } else {
                            PegasusFileComplete r = new PegasusFileComplete();
                            r.setCategory(FileCategoryE.IMPORT);
                            r.setLocalFile(f);
                            PegasusFileComplete uploaded = FileTransferUtil.upload((PegasusFileComplete)r, (FileTransferListener[])new FileTransferListener[0]);
                            ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).validateInventoryCount(uploaded, new StoreReference(((StoreLight)ValidateInventoryCountActionComponent.this.storeNode.getValue()).getId()));
                            ValidateInventoryCountActionComponent.this.printed = true;
                        }
                        ValidateInventoryCountActionComponent.this.removeAnimation(false, true);
                    }
                    catch (ExcelToolkitException e) {
                        ValidateInventoryCountActionComponent.this.log.error(e.getMessage(), (Throwable)e);
                        ValidateInventoryCountActionComponent.this.setIsAutoCloseDisabled(false);
                        InnerPopupFactory.showErrorDialog("Could not read Excel file. Ensure file is closed.", (Component)ValidateInventoryCountActionComponent.this);
                    }
                    catch (Exception e) {
                        ValidateInventoryCountActionComponent.this.log.error(e.getMessage(), (Throwable)e);
                        ValidateInventoryCountActionComponent.this.removeAnimation(false, true);
                        ValidateInventoryCountActionComponent.this.showMessage(Words.UNABLE_TO_IMPORT_DATA);
                        success = false;
                        if (ValidateInventoryCountActionComponent.this.popup != null) {
                            ValidateInventoryCountActionComponent.this.popup.hideCancelButton();
                            ValidateInventoryCountActionComponent.this.popup.disablePreviewButton();
                            ValidateInventoryCountActionComponent.this.popup.setOkButtonText(Words.CLOSE);
                            ValidateInventoryCountActionComponent.this.popup.enableOKButton(true);
                            ValidateInventoryCountActionComponent.this.printed = true;
                        }
                    }
                } else {
                    ValidateInventoryCountActionComponent.this.removeAnimation(false, true);
                    ValidateInventoryCountActionComponent.this.showMessage(Words.DATA_IMPORT_CANCELLED);
                    success = false;
                    if (ValidateInventoryCountActionComponent.this.popup != null) {
                        ValidateInventoryCountActionComponent.this.popup.hideCancelButton();
                        ValidateInventoryCountActionComponent.this.popup.disablePreviewButton();
                        ValidateInventoryCountActionComponent.this.popup.setOkButtonText(Words.CLOSE);
                        ValidateInventoryCountActionComponent.this.popup.enableOKButton(true);
                        ValidateInventoryCountActionComponent.this.printed = true;
                    }
                }
                Node b = new Node();
                b.setValue((Object)success, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ValidateInventoryCountActionComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    protected String getFinishedText() {
        return "Validation successful";
    }

    @Override
    public void openErrorDialog(String message) {
        this.setIsAutoCloseDisabled(false);
        InnerPopupFactory.showErrorDialog(message, (Component)this);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.popup.setOkNullAnyway();
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO(this.storeNode.getValue(), false, true);
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = ValidateInventoryCountActionComponent.this.layoutInheritedComponents(parent) + ValidateInventoryCountActionComponent.this.border;
            ValidateInventoryCountActionComponent.this.chargeBased.setLocation(ValidateInventoryCountActionComponent.this.border, y);
            ValidateInventoryCountActionComponent.this.chargeBased.setSize(ValidateInventoryCountActionComponent.this.chargeBased.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ValidateInventoryCountActionComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (ValidateInventoryCountActionComponent.this.animation != null) {
                h = (int)((double)h + ValidateInventoryCountActionComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(ValidateInventoryCountActionComponent.this.border * 2) + ValidateInventoryCountActionComponent.this.animation.getPreferredSize().getWidth()), h += ValidateInventoryCountActionComponent.this.border);
            }
            return new Dimension(w, h);
        }
    }
}

