/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.close;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.DefaultExportAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CloseAllFlightsComponent
extends DefaultExportAnalysisComponent<FlightLight> {
    private static final long serialVersionUID = 1L;

    public CloseAllFlightsComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    protected String getFinishedText() {
        return Words.SUCCESSFUL;
    }

    @Override
    protected String getProgressText() {
        return Words.CLOSE_FLIGHTS;
    }

    @Override
    public String getPrefixText() {
        return Words.CLOSING;
    }

    @Override
    public String getExportCurrentText() {
        return Words.CLOSE_CURRENT;
    }

    @Override
    public String getExportFilteredText() {
        return Words.CLOSE_FILTERED;
    }

    @Override
    public String getExportAllText() {
        return Words.CLOSE_ALL;
    }

    @Override
    public String getTitleText() {
        return Words.FLIGHTS;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }

    @Override
    public void process(Iterator<FlightLight> sri, List<ExcelRow> rows) throws ClientServerCallException {
        while (sri.hasNext()) {
            this.updateItemCount();
            FlightLight f = sri.next();
            if (f == null || f.getId() == null || f.getFlightState() == FlightStateE.CANCELLED || f.getFlightState() == FlightStateE.CLOSED) continue;
            ArrayList innerErrors = new ArrayList();
            try {
                FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                fc.setFlightState(FlightStateE.CLOSED);
                ((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(innerErrors), false, false, false, false);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        }
    }

    @Override
    protected List<ExcelRow> createRow(FlightLight product) throws ClientServerCallException {
        return null;
    }
}

