/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.popup.content;

import ch.icit.pegasus.client.gui.submodules.popup.SubModulePopupContent;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.util.PrinterToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;

public class PrinterContent
extends SubModulePopupContent {
    protected TitledItem<ComboBox> printer = new TitledItem<ComboBox>(new ComboBox(), Words.PRINTER, TitledItem.TitledItemOrientation.NORTH);
    protected TitledItem<TextField> copies = new TitledItem<TextField>(new TextField(), Words.COPIES, TitledItem.TitledItemOrientation.NORTH);
    private int copiesFieldWith = 80;

    public PrinterContent() {
        this.copies.getElement().setText(this.getNumberOfSavedCopies());
        this.setLayout(new Layout());
        this.add(this.printer);
        this.add(this.copies);
        this.fillPrinters();
    }

    private void fillPrinters() {
        List l = PrinterToolkit.getAvailablePrinters();
        for (PrintService t : l) {
            this.printer.getElement().addItem(PrinterToolkit.convertPrintServiceToString((PrintService)t));
        }
        PrintService s = PrintPopupToolkit.getDefaultPrinter((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
        if (s != null) {
            this.printer.getElement().setSelectedItem(PrinterToolkit.convertPrintServiceToString((PrintService)s));
        }
    }

    private String getNumberOfSavedCopies() {
        return PrintPopupToolkit.getDefaultCopyCount((UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.printer);
        CheckedListAdder.addToList(focusList, this.copies);
        return focusList;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        this.printer.requestFocusInWindow();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, (int)PrinterContent.this.copies.getPreferredSize().getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            PrinterContent.this.printer.setLocation(0, 0);
            PrinterContent.this.printer.setSize(parent.getWidth() - (PrinterContent.this.border + PrinterContent.this.copiesFieldWith), (int)PrinterContent.this.printer.getPreferredSize().getHeight());
            PrinterContent.this.copies.setLocation(PrinterContent.this.printer.getX() + PrinterContent.this.printer.getWidth() + PrinterContent.this.border, 0);
            PrinterContent.this.copies.setSize(PrinterContent.this.copiesFieldWith, (int)PrinterContent.this.copies.getPreferredSize().getHeight());
        }
    }
}

